/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.junit.rules.Timeout;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestTimedOutException;
import org.neo4j.test.ThreadTestUtils;

public class VerboseTimeout
extends Timeout {
    private VerboseTimeoutBuilder timeoutBuilder;

    private VerboseTimeout(VerboseTimeoutBuilder timeoutBuilder) {
        super((Timeout.Builder)timeoutBuilder);
        this.timeoutBuilder = timeoutBuilder;
    }

    public static VerboseTimeoutBuilder builder() {
        return new VerboseTimeoutBuilder();
    }

    protected Statement createFailOnTimeoutStatement(Statement statement) throws Exception {
        return new VerboseFailOnTimeout(statement, this.timeoutBuilder);
    }

    private class VerboseFailOnTimeout
    extends Statement {
        private final Statement originalStatement;
        private final TimeUnit timeUnit;
        private final long timeout;
        private final List<VerboseTimeoutBuilder.FailureParameter> additionalParameters;

        VerboseFailOnTimeout(Statement statement, VerboseTimeoutBuilder builder) {
            this.originalStatement = statement;
            this.timeout = builder.timeout;
            this.timeUnit = builder.getTimeUnit();
            this.additionalParameters = builder.getAdditionalParameters();
        }

        public void evaluate() throws Throwable {
            CallableStatement callable = new CallableStatement();
            FutureTask<Throwable> task = new FutureTask<Throwable>(callable);
            Thread thread = new Thread(task, "Time-limited test");
            thread.setDaemon(true);
            thread.start();
            callable.awaitStarted();
            Throwable throwable = this.getResult(task, thread);
            if (throwable != null) {
                throw throwable;
            }
        }

        private Throwable getResult(FutureTask<Throwable> task, Thread thread) throws Throwable {
            try {
                if (this.timeout > 0L) {
                    return task.get(this.timeout, this.timeUnit);
                }
                return task.get();
            }
            catch (ExecutionException e) {
                ThreadTestUtils.dumpAllStackTraces();
                return e.getCause();
            }
            catch (TimeoutException e) {
                if (!this.additionalParameters.isEmpty()) {
                    System.err.println("==== Requested additional parameters: ====");
                    for (VerboseTimeoutBuilder.FailureParameter additionalParameter : this.additionalParameters) {
                        System.err.println(additionalParameter.describe());
                    }
                }
                System.err.println("=== Thread dump ===");
                ThreadTestUtils.dumpAllStackTraces();
                return this.buildTimeoutException(thread);
            }
        }

        private Throwable buildTimeoutException(Thread thread) throws TestTimedOutException {
            StackTraceElement[] stackTrace = thread.getStackTrace();
            TestTimedOutException timedOutException = new TestTimedOutException(this.timeout, this.timeUnit);
            timedOutException.setStackTrace(stackTrace);
            return timedOutException;
        }

        private class CallableStatement
        implements Callable<Throwable> {
            private final CountDownLatch startLatch = new CountDownLatch(1);

            private CallableStatement() {
            }

            @Override
            public Throwable call() throws Exception {
                try {
                    this.startLatch.countDown();
                    VerboseFailOnTimeout.this.originalStatement.evaluate();
                }
                catch (Throwable e) {
                    return e;
                }
                return null;
            }

            public void awaitStarted() throws InterruptedException {
                this.startLatch.await();
            }
        }
    }

    public static class VerboseTimeoutBuilder
    extends Timeout.Builder {
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private long timeout = 0L;
        private List<FailureParameter> additionalParameters = new ArrayList<FailureParameter>();

        private static Function<Object, String> toStringFunction() {
            return value -> value == null ? "" : value.toString();
        }

        public VerboseTimeoutBuilder withTimeout(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.timeUnit = unit;
            return this;
        }

        public <T> VerboseTimeoutBuilder describeOnFailure(T entity, Function<T, String> descriptor) {
            this.additionalParameters.add(new FailureParameter<T>(entity, descriptor));
            return this;
        }

        public <T> VerboseTimeoutBuilder describeOnFailure(T entity) {
            return this.describeOnFailure(entity, VerboseTimeoutBuilder.toStringFunction());
        }

        public VerboseTimeout build() {
            return new VerboseTimeout(this);
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public List<FailureParameter> getAdditionalParameters() {
            return this.additionalParameters;
        }

        private class FailureParameter<T> {
            private final T entity;
            private final Function<T, String> descriptor;

            FailureParameter(T entity, Function<T, String> descriptor) {
                this.entity = entity;
                this.descriptor = descriptor;
            }

            String describe() {
                return this.descriptor.apply(this.entity);
            }
        }
    }
}

