/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.internal.StoreLocker;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInserterImplTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final ExpectedException expected = ExpectedException.none();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.expected).around((TestRule)this.fileSystemRule);

    @Test
    public void testHonorsPassedInParams() throws Exception {
        BatchInserter inserter = BatchInserters.inserter((File)this.testDirectory.graphDbDir(), (FileSystemAbstraction)this.fileSystemRule.get(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "280K", GraphDatabaseSettings.mapped_memory_page_size.name(), "1K"}));
        NeoStores neoStores = ReflectionUtil.getPrivateField(inserter, "neoStores", NeoStores.class);
        PageCache pageCache = ReflectionUtil.getPrivateField(neoStores, "pageCache", PageCache.class);
        inserter.shutdown();
        int mappedMemoryTotalSize = pageCache.maxCachedPages() * pageCache.pageSize();
        Assert.assertThat((String)"memory mapped config is active", (Object)mappedMemoryTotalSize, (Matcher)Matchers.is((Object)286720));
    }

    @Test
    public void testCreatesStoreLockFile() throws Exception {
        File file = this.testDirectory.graphDbDir();
        BatchInserter inserter = BatchInserters.inserter((File)file.getAbsoluteFile(), (FileSystemAbstraction)this.fileSystemRule.get());
        Assert.assertThat((Object)new File(file, "store_lock").exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        inserter.shutdown();
    }

    @Test
    public void testFailsOnExistingStoreLockFile() throws IOException {
        File parent = this.testDirectory.graphDbDir();
        try (DefaultFileSystemAbstraction fileSystemAbstraction = new DefaultFileSystemAbstraction();
             StoreLocker lock = new StoreLocker((FileSystemAbstraction)fileSystemAbstraction);){
            lock.checkLock(parent);
            this.expected.expect(StoreLockException.class);
            this.expected.expectMessage("Unable to obtain lock on store lock file");
            BatchInserters.inserter((File)parent.getAbsoluteFile(), (FileSystemAbstraction)fileSystemAbstraction);
        }
    }
}

