/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.storageengine.api.Token;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.CapturingSender;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.NodeEncoderStep;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;

public class NodeEncoderStepTest {
    private final StageControl control = (StageControl)Mockito.mock(StageControl.class);
    private final TokenStore<LabelTokenRecord, Token> tokenStore = (TokenStore)Mockito.mock(TokenStore.class);
    private final BatchingTokenRepository.BatchingLabelTokenRepository tokenRepository = new BatchingTokenRepository.BatchingLabelTokenRepository(this.tokenStore);
    private final NodeStore nodeStore = (NodeStore)Mockito.mock(NodeStore.class);
    private final CapturingSender sender = new CapturingSender();

    @Test
    public void shouldNotAssignLabelsForNodesWithJustLabelField() throws Exception {
        NodeEncoderStep step = new NodeEncoderStep(this.control, Configuration.DEFAULT, IdMappers.actual(), IdGenerators.fromInput(), this.tokenRepository, this.nodeStore, (StatsProvider)Mockito.mock(StatsProvider.class));
        InputNode node = new InputNode("source", 0L, 0L, (Object)0L, InputEntity.NO_PROPERTIES, null, null, Long.valueOf(1L));
        Batch batchBefore = new Batch((Object[])new InputNode[]{node});
        step.process(batchBefore, (BatchSender)this.sender);
        Batch batchAfter = (Batch)Iterables.single((Iterable)this.sender);
        Assert.assertNull((Object)batchAfter.labels[0]);
    }

    @Test
    public void shouldNotAssignLabelsForNodesWithNoLabels() throws Exception {
        NodeEncoderStep step = new NodeEncoderStep(this.control, Configuration.DEFAULT, IdMappers.actual(), IdGenerators.fromInput(), this.tokenRepository, this.nodeStore, (StatsProvider)Mockito.mock(StatsProvider.class));
        InputNode node = new InputNode("source", 0L, 0L, (Object)0L, InputEntity.NO_PROPERTIES, null, InputEntity.NO_LABELS, null);
        Batch batchBefore = new Batch((Object[])new InputNode[]{node});
        step.process(batchBefore, (BatchSender)this.sender);
        Batch batchAfter = (Batch)Iterables.single((Iterable)this.sender);
        Assert.assertNull((Object)batchAfter.labels[0]);
    }

    @Test
    public void shouldAssignLabelsForNodesWithLabels() throws Exception {
        NodeEncoderStep step = new NodeEncoderStep(this.control, Configuration.DEFAULT, IdMappers.actual(), IdGenerators.fromInput(), this.tokenRepository, this.nodeStore, (StatsProvider)Mockito.mock(StatsProvider.class));
        InputNode node = new InputNode("source", 0L, 0L, (Object)0L, InputEntity.NO_PROPERTIES, null, new String[]{"one", "two"}, null);
        Batch batchBefore = new Batch((Object[])new InputNode[]{node});
        step.process(batchBefore, (BatchSender)this.sender);
        Batch batchAfter = (Batch)Iterables.single((Iterable)this.sender);
        Assert.assertNotNull((Object)batchAfter.labels[0]);
        Assert.assertEquals((long)2L, (long)batchAfter.labels[0].length);
    }
}

