/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.StringEncoder;

public class StringEncoderTest {
    @Test
    public void shouldEncodeStringWithZeroLength() throws Exception {
        StringEncoder encoder = new StringEncoder();
        long eId = encoder.encode((Object)"");
        Assert.assertTrue((eId != 0L ? 1 : 0) != 0);
    }

    @Test
    public void shouldEncodeStringWithAnyLength() throws Exception {
        StringEncoder encoder = new StringEncoder();
        PrimitiveLongSet encoded = Primitive.longSet();
        int total = 1000;
        int duplicates = 0;
        for (int i = 0; i < total; ++i) {
            long encode = encoder.encode((Object)this.abcStringOfLength(i));
            Assert.assertTrue((encode != 0L ? 1 : 0) != 0);
            if (encoded.add(encode)) continue;
            ++duplicates;
        }
        Assert.assertTrue(((float)duplicates / (float)total < 0.01f ? 1 : 0) != 0);
    }

    private String abcStringOfLength(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            int ch = 97 + i % 20;
            chars[i] = (char)ch;
        }
        return new String(chars);
    }
}

