/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;

public class InputEntityTest {
    @Test
    public void shouldAddProperties() throws Exception {
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", new Object[]{"first", "Yeah", "second", "Yo"}, null, InputEntity.NO_LABELS, null);
        node.updateProperties(UpdateBehaviour.ADD, new Object[]{"third", "Yee"});
        Assert.assertArrayEquals((Object[])new Object[]{"first", "Yeah", "second", "Yo", "third", "Yee"}, (Object[])node.properties());
    }

    @Test
    public void shouldAddToExistingProperty() throws Exception {
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", new Object[]{"first", "Yeah", "second", "Yo"}, null, InputEntity.NO_LABELS, null);
        node.updateProperties(UpdateBehaviour.ADD, new Object[]{"second", "Ya"});
        Assert.assertArrayEquals((Object[])new Object[]{"first", "Yeah", "second", new String[]{"Yo", "Ya"}}, (Object[])node.properties());
    }

    @Test
    public void shouldAddToExistingArrayProperty() throws Exception {
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", new Object[]{"first", "Yeah", "second", "Yo"}, null, InputEntity.NO_LABELS, null);
        node.updateProperties(UpdateBehaviour.ADD, new Object[]{"second", "Ya"});
        node.updateProperties(UpdateBehaviour.ADD, new Object[]{"second", "Yi"});
        Assert.assertArrayEquals((Object[])new Object[]{"first", "Yeah", "second", new String[]{"Yo", "Ya", "Yi"}}, (Object[])node.properties());
    }

    @Test
    public void shouldSetProperties() throws Exception {
        InputNode node = new InputNode("source", 1L, 0L, (Object)"id", new Object[]{"first", "Yeah", "second", "Yo"}, null, InputEntity.NO_LABELS, null);
        node.setProperties(new Object[]{"third", "Yee"});
        Assert.assertArrayEquals((Object[])new Object[]{"third", "Yee"}, (Object[])node.properties());
    }
}

