/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class LonelyProcessingStepTest {
    @Rule
    public SuppressOutput mute = SuppressOutput.suppressAll();

    @Test(timeout=1000L)
    public void issuePanicBeforeCompletionOnError() throws Exception {
        ArrayList stepsPipeline = new ArrayList();
        FaultyLonelyProcessingStepTest faultyStep = new FaultyLonelyProcessingStepTest(stepsPipeline);
        stepsPipeline.add((Step<?>)faultyStep);
        faultyStep.receive(1L, null);
        while (!faultyStep.isCompleted()) {
            Thread.sleep(10L);
        }
        Assert.assertTrue((String)"On upstream end step should be already on panic in case of exception", (boolean)faultyStep.isPanicOnEndUpstream());
        Assert.assertTrue((boolean)faultyStep.isPanic());
        Assert.assertFalse((boolean)faultyStep.stillWorking());
    }

    private class FaultyLonelyProcessingStepTest
    extends LonelyProcessingStep {
        private volatile boolean panicOnEndUpstream;

        public FaultyLonelyProcessingStepTest(List<Step<?>> pipeLine) {
            super((StageControl)new StageExecution("Faulty", Configuration.DEFAULT, pipeLine, 0), "Faulty", Configuration.DEFAULT, new StatsProvider[0]);
            this.panicOnEndUpstream = false;
        }

        protected void process() {
            throw new RuntimeException("Process exception");
        }

        public void endOfUpstream() {
            this.panicOnEndUpstream = this.isPanic();
            super.endOfUpstream();
        }

        public boolean isPanicOnEndUpstream() {
            return this.panicOnEndUpstream;
        }
    }
}

