/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.ControlledStep;
import org.neo4j.unsafe.impl.batchimport.staging.SpectrumExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;

public class SpectrumExecutionMonitorTest {
    @Test
    public void shouldAlternateStagesWithMultiple() throws Exception {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        SpectrumExecutionMonitor monitor = new SpectrumExecutionMonitor(0L, TimeUnit.MILLISECONDS, new PrintStream(out), 100);
        StageExecution[] stages = new StageExecution[]{this.stage("A_1", "A_2"), this.stage("B_1", "B_2")};
        monitor.check(stages);
        String[] lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)1L, (long)lines.length);
        Assert.assertTrue((String)lines[0], (boolean)lines[0].contains("A_1"));
        Assert.assertFalse((String)lines[0], (boolean)lines[0].contains("B_1"));
        monitor.check(stages);
        lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)2L, (long)lines.length);
        Assert.assertTrue((String)lines[1], (boolean)lines[1].contains("B_1"));
        Assert.assertFalse((String)lines[1], (boolean)lines[1].contains("A_1"));
        monitor.check(stages);
        lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)3L, (long)lines.length);
        Assert.assertTrue((String)lines[2], (boolean)lines[0].contains("A_1"));
        Assert.assertFalse((String)lines[2], (boolean)lines[0].contains("B_1"));
    }

    @Test
    public void shouldOnlyAlternativeBetweenActiveStages() throws Exception {
        StageExecution stageB;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bytes);
        SpectrumExecutionMonitor monitor = new SpectrumExecutionMonitor(0L, TimeUnit.MILLISECONDS, new PrintStream(out), 100);
        StageExecution[] stages = new StageExecution[]{this.stage("A_1", "A_2"), stageB = this.stage("B_1", "B_2"), this.stage("C_1", "C_2")};
        monitor.check(stages);
        String[] lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)1L, (long)lines.length);
        Assert.assertTrue((String)lines[0], (boolean)lines[0].contains("A_1"));
        Assert.assertFalse((String)lines[0], (boolean)lines[0].contains("B_1"));
        this.complete(stageB);
        monitor.check(stages);
        lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)2L, (long)lines.length);
        Assert.assertTrue((String)lines[1], (boolean)lines[1].contains("C_1"));
        Assert.assertFalse((String)lines[1], (boolean)lines[1].contains("A_1"));
        Assert.assertFalse((String)lines[1], (boolean)lines[1].contains("B_1"));
        monitor.check(stages);
        lines = this.linesOf(out, bytes);
        Assert.assertEquals((long)3L, (long)lines.length);
        Assert.assertTrue((String)lines[2], (boolean)lines[2].contains("A_1"));
        Assert.assertFalse((String)lines[2], (boolean)lines[2].contains("B_1"));
        Assert.assertFalse((String)lines[2], (boolean)lines[2].contains("C_1"));
    }

    private void complete(StageExecution stage) {
        for (Step step : stage.steps()) {
            ((ControlledStep)step).complete();
        }
    }

    private String[] linesOf(PrintStream out, ByteArrayOutputStream bytes) {
        out.flush();
        String string = bytes.toString();
        String[] allLines = string.split("\r");
        return Arrays.copyOfRange(allLines, 1, allLines.length);
    }

    private StageExecution stage(String ... stepNames) {
        ArrayList pipeline = new ArrayList();
        long avg = 10L;
        for (String name : stepNames) {
            pipeline.add(ControlledStep.stepWithStats(name, 1, Keys.avg_processing_time, avg, Keys.done_batches, 1L));
            avg += 10L;
        }
        return new StageExecution("Test", Configuration.DEFAULT, pipeline, 0);
    }
}

