/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.impl.notification;

import java.util.ArrayList;
import java.util.TreeSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.SeverityLevel;
import org.neo4j.graphdb.impl.notification.NotificationCode;
import org.neo4j.graphdb.impl.notification.NotificationDetail;

class NotificationCodeTest {
    NotificationCodeTest() {
    }

    @Test
    void shouldConstructNotificationFor_INDEX_HINT_UNFULFILLABLE() {
        NotificationDetail indexDetail = NotificationDetail.Factory.index((String)"Person", (String[])new String[]{"name"});
        NotificationCode.Notification notification = NotificationCode.INDEX_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{indexDetail});
        MatcherAssert.assertThat((Object)notification.getTitle(), (Matcher)CoreMatchers.equalTo((Object)"The request (directly or indirectly) referred to an index that does not exist."));
        MatcherAssert.assertThat((Object)notification.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)SeverityLevel.WARNING));
        MatcherAssert.assertThat((Object)notification.getCode(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientError.Schema.IndexNotFound"));
        MatcherAssert.assertThat((Object)notification.getPosition(), (Matcher)CoreMatchers.equalTo((Object)InputPosition.empty));
        MatcherAssert.assertThat((Object)notification.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"The hinted index does not exist, please check the schema (hinted index is: index on :Person(name))"));
    }

    @Test
    void shouldConstructNotificationFor_CARTESIAN_PRODUCT() {
        TreeSet<String> idents = new TreeSet<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail identifierDetail = NotificationDetail.Factory.cartesianProduct(idents);
        NotificationCode.Notification notification = NotificationCode.CARTESIAN_PRODUCT.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        MatcherAssert.assertThat((Object)notification.getTitle(), (Matcher)CoreMatchers.equalTo((Object)"This query builds a cartesian product between disconnected patterns."));
        MatcherAssert.assertThat((Object)notification.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)SeverityLevel.WARNING));
        MatcherAssert.assertThat((Object)notification.getCode(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientNotification.Statement.CartesianProductWarning"));
        MatcherAssert.assertThat((Object)notification.getPosition(), (Matcher)CoreMatchers.equalTo((Object)InputPosition.empty));
        MatcherAssert.assertThat((Object)notification.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"If a part of a query contains multiple disconnected patterns, this will build a cartesian product between all those parts. This may produce a large amount of data and slow down query processing. While occasionally intended, it may often be possible to reformulate the query that avoids the use of this cross product, perhaps by adding a relationship between the different parts or by using OPTIONAL MATCH (identifiers are: (n, node2))"));
    }

    @Test
    void shouldConstructNotificationsFor_JOIN_HINT_UNFULFILLABLE() {
        ArrayList<String> idents = new ArrayList<String>();
        idents.add("n");
        idents.add("node2");
        NotificationDetail identifierDetail = NotificationDetail.Factory.joinKey(idents);
        NotificationCode.Notification notification = NotificationCode.JOIN_HINT_UNFULFILLABLE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        MatcherAssert.assertThat((Object)notification.getTitle(), (Matcher)CoreMatchers.equalTo((Object)"The database was unable to plan a hinted join."));
        MatcherAssert.assertThat((Object)notification.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)SeverityLevel.WARNING));
        MatcherAssert.assertThat((Object)notification.getCode(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientNotification.Statement.JoinHintUnfulfillableWarning"));
        MatcherAssert.assertThat((Object)notification.getPosition(), (Matcher)CoreMatchers.equalTo((Object)InputPosition.empty));
        MatcherAssert.assertThat((Object)notification.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"The hinted join was not planned. This could happen because no generated plan contained the join key, please try using a different join key or restructure your query. (hinted join key identifiers are: n, node2)"));
    }

    @Test
    void shouldConstructNotificationsFor_DEPRECATED_PROCEDURE() {
        NotificationDetail identifierDetail = NotificationDetail.Factory.deprecatedName((String)"oldName", (String)"newName");
        NotificationCode.Notification notification = NotificationCode.DEPRECATED_PROCEDURE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        MatcherAssert.assertThat((Object)notification.getTitle(), (Matcher)CoreMatchers.equalTo((Object)"This feature is deprecated and will be removed in future versions."));
        MatcherAssert.assertThat((Object)notification.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)SeverityLevel.WARNING));
        MatcherAssert.assertThat((Object)notification.getCode(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientNotification.Statement.FeatureDeprecationWarning"));
        MatcherAssert.assertThat((Object)notification.getPosition(), (Matcher)CoreMatchers.equalTo((Object)InputPosition.empty));
        MatcherAssert.assertThat((Object)notification.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"The query used a deprecated procedure. ('oldName' has been replaced by 'newName')"));
    }

    @Test
    void shouldConstructNotificationsFor_DEPRECATED_PROCEDURE_with_no_newName() {
        NotificationDetail identifierDetail = NotificationDetail.Factory.deprecatedName((String)"oldName", (String)"");
        NotificationCode.Notification notification = NotificationCode.DEPRECATED_PROCEDURE.notification(InputPosition.empty, new NotificationDetail[]{identifierDetail});
        MatcherAssert.assertThat((Object)notification.getTitle(), (Matcher)CoreMatchers.equalTo((Object)"This feature is deprecated and will be removed in future versions."));
        MatcherAssert.assertThat((Object)notification.getSeverity(), (Matcher)CoreMatchers.equalTo((Object)SeverityLevel.WARNING));
        MatcherAssert.assertThat((Object)notification.getCode(), (Matcher)CoreMatchers.equalTo((Object)"Neo.ClientNotification.Statement.FeatureDeprecationWarning"));
        MatcherAssert.assertThat((Object)notification.getPosition(), (Matcher)CoreMatchers.equalTo((Object)InputPosition.empty));
        MatcherAssert.assertThat((Object)notification.getDescription(), (Matcher)CoreMatchers.equalTo((Object)"The query used a deprecated procedure. ('oldName' is no longer supported)"));
    }
}

