/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexEntryUpdateTest {
    private final Value[] multiValue = new Value[]{Values.of((Object)"value"), Values.of((Object)"value2")};
    private final Value singleValue = Values.of((Object)"value");

    IndexEntryUpdateTest() {
    }

    @Test
    void indexEntryUpdatesShouldBeEqual() {
        IndexEntryUpdate a = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate b = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        MatcherAssert.assertThat((Object)a, (Matcher)Matchers.equalTo((Object)b));
        MatcherAssert.assertThat((Object)a.hashCode(), (Matcher)Matchers.equalTo((Object)b.hashCode()));
    }

    @Test
    void addShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{this.singleValue}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    void removeShouldRetainValues() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multi = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue);
        MatcherAssert.assertThat((Object)single, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)multi)));
        MatcherAssert.assertThat((Object)single.values(), (Matcher)Matchers.equalTo((Object)new Object[]{this.singleValue}));
        MatcherAssert.assertThat((Object)multi.values(), (Matcher)Matchers.equalTo((Object)this.multiValue));
    }

    @Test
    void addShouldThrowIfAskedForChanged() {
        IndexEntryUpdate single = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((IndexEntryUpdate)single).beforeValues());
    }

    @Test
    void removeShouldThrowIfAskedForChanged() {
        IndexEntryUpdate single = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((IndexEntryUpdate)single).beforeValues());
    }

    @Test
    void updatesShouldEqualRegardlessOfCreationMethod() {
        IndexEntryUpdate singleAdd = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        Value[] singleAsArray = new Value[]{this.singleValue};
        IndexEntryUpdate multiAdd = IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleRemove = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])new Value[]{this.singleValue});
        IndexEntryUpdate multiRemove = IndexEntryUpdate.remove((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray);
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)this.singleValue);
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value[])singleAsArray, (Value[])singleAsArray);
        MatcherAssert.assertThat((Object)singleAdd, (Matcher)Matchers.equalTo((Object)multiAdd));
        MatcherAssert.assertThat((Object)singleRemove, (Matcher)Matchers.equalTo((Object)multiRemove));
        MatcherAssert.assertThat((Object)singleChange, (Matcher)Matchers.equalTo((Object)multiChange));
    }

    @Test
    void changedShouldRetainValues() {
        Value singleAfter = Values.of((Object)"Hello");
        IndexEntryUpdate singleChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4}), (Value)this.singleValue, (Value)singleAfter);
        Value[] multiAfter = new Value[]{Values.of((Object)"Hello"), Values.of((Object)"Hi")};
        IndexEntryUpdate multiChange = IndexEntryUpdate.change((long)0L, (SchemaDescriptorSupplier)SchemaDescriptor.forLabel((int)3, (int[])new int[]{4, 5}), (Value[])this.multiValue, (Value[])multiAfter);
        MatcherAssert.assertThat((Object)new Object[]{this.singleValue}, (Matcher)Matchers.equalTo((Object)singleChange.beforeValues()));
        MatcherAssert.assertThat((Object)new Object[]{singleAfter}, (Matcher)Matchers.equalTo((Object)singleChange.values()));
        MatcherAssert.assertThat((Object)this.multiValue, (Matcher)Matchers.equalTo((Object)multiChange.beforeValues()));
        MatcherAssert.assertThat((Object)multiAfter, (Matcher)Matchers.equalTo((Object)multiChange.values()));
    }
}

