/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.availability;

import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.availability.AvailabilityListener;
import org.neo4j.kernel.availability.AvailabilityRequirement;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DatabaseAvailabilityGuard;
import org.neo4j.kernel.availability.DescriptiveAvailabilityRequirement;
import org.neo4j.kernel.database.TestDatabaseIdRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.Log;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.time.Clocks;

@Timeout(value=30L)
@ExtendWith(value={LifeExtension.class})
class DatabaseAvailabilityGuardTest {
    private static final AvailabilityRequirement REQUIREMENT_1 = new DescriptiveAvailabilityRequirement("Requirement 1");
    private static final AvailabilityRequirement REQUIREMENT_2 = new DescriptiveAvailabilityRequirement("Requirement 2");
    private final Clock clock = Clocks.systemClock();
    private final Log log = (Log)Mockito.mock(Log.class);
    @Inject
    private LifeSupport life;

    DatabaseAvailabilityGuardTest() {
    }

    @Test
    void notStartedGuardIsNotAvailable() {
        DatabaseAvailabilityGuard availabilityGuard = DatabaseAvailabilityGuardTest.createAvailabilityGuard(this.clock, this.log);
        Assertions.assertFalse((boolean)availabilityGuard.isAvailable());
        Assertions.assertFalse((boolean)availabilityGuard.isAvailable(0L));
        Assertions.assertTrue((boolean)availabilityGuard.isShutdown());
    }

    @Test
    void shutdownAvailabilityGuardIsNotAvailable() throws Exception {
        DatabaseAvailabilityGuard availabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        Assertions.assertTrue((boolean)availabilityGuard.isAvailable());
        Assertions.assertFalse((boolean)availabilityGuard.isShutdown());
        availabilityGuard.stop();
        availabilityGuard.shutdown();
        Assertions.assertFalse((boolean)availabilityGuard.isAvailable());
        Assertions.assertTrue((boolean)availabilityGuard.isShutdown());
    }

    @Test
    void restartedAvailabilityGuardIsAvailable() throws Exception {
        DatabaseAvailabilityGuard availabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        Assertions.assertTrue((boolean)availabilityGuard.isAvailable());
        Assertions.assertFalse((boolean)availabilityGuard.isShutdown());
        availabilityGuard.stop();
        availabilityGuard.shutdown();
        availabilityGuard.init();
        Assertions.assertFalse((boolean)availabilityGuard.isShutdown());
        Assertions.assertTrue((boolean)availabilityGuard.isAvailable());
        availabilityGuard.start();
        Assertions.assertFalse((boolean)availabilityGuard.isShutdown());
        Assertions.assertTrue((boolean)availabilityGuard.isAvailable());
    }

    @Test
    void logOnAvailabilityChange() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.log});
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(this.log, Mockito.atLeastOnce());
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(this.log, Mockito.times((int)4));
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        DatabaseAvailabilityGuardTest.verifyLogging(this.log, Mockito.times((int)6));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        DatabaseAvailabilityGuardTest.verifyLogging(this.log, Mockito.times((int)6));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        DatabaseAvailabilityGuardTest.verifyLogging(this.log, Mockito.times((int)8));
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenAwaitThenTimeoutAndReturnFalse() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        boolean result = databaseAvailabilityGuard.isAvailable(1000L);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenAwaitThenActuallyWaitGivenTimeout() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long timeout = 1000L;
        long start = this.clock.millis();
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assertions.assertFalse((boolean)result);
        MatcherAssert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitThenTimeoutAndReturnFalse() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assertions.assertFalse((boolean)result);
        MatcherAssert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenGrantEachAndAwaitThenTrue() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        Assertions.assertTrue((boolean)databaseAvailabilityGuard.isAvailable(1000L));
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenGrantTwiceAndDenyOnceAndAwaitThenTimeoutAndReturnFalse() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        long start = this.clock.millis();
        long timeout = 1000L;
        boolean result = databaseAvailabilityGuard.isAvailable(timeout);
        long end = this.clock.millis();
        long waitTime = end - start;
        Assertions.assertFalse((boolean)result);
        MatcherAssert.assertThat((Object)waitTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(timeout)));
    }

    @Test
    void givenAccessGuardWith2ConditionsWhenGrantOnceAndAwaitAndGrantAgainThenReturnTrue() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_2);
        Assertions.assertFalse((boolean)databaseAvailabilityGuard.isAvailable(100L));
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        Assertions.assertTrue((boolean)databaseAvailabilityGuard.isAvailable(100L));
    }

    @Test
    void givenAccessGuardWithConditionWhenGrantThenNotifyListeners() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityListener availabilityListener = new AvailabilityListener(){

            public void available() {
                notified.set(true);
            }

            public void unavailable() {
            }
        };
        databaseAvailabilityGuard.addListener(availabilityListener);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        Assertions.assertTrue((boolean)notified.get());
    }

    @Test
    void givenAccessGuardWithConditionWhenGrantAndDenyThenNotifyListeners() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        final AtomicBoolean notified = new AtomicBoolean();
        AvailabilityListener availabilityListener = new AvailabilityListener(){

            public void available() {
            }

            public void unavailable() {
                notified.set(true);
            }
        };
        databaseAvailabilityGuard.addListener(availabilityListener);
        databaseAvailabilityGuard.fulfill(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        Assertions.assertTrue((boolean)notified.get());
    }

    @Test
    void shouldExplainWhoIsBlockingAccess() {
        DatabaseAvailabilityGuard databaseAvailabilityGuard = this.getDatabaseAvailabilityGuard(this.clock, this.log);
        databaseAvailabilityGuard.require(REQUIREMENT_1);
        databaseAvailabilityGuard.require(REQUIREMENT_2);
        MatcherAssert.assertThat((Object)databaseAvailabilityGuard.describe(), (Matcher)CoreMatchers.equalTo((Object)"2 reasons for blocking: Requirement 1, Requirement 2."));
    }

    @Test
    void shouldWaitForAvailabilityWhenShutdown() throws Exception {
        long waitMs = TimeUnit.DAYS.toMillis(1L);
        DatabaseAvailabilityGuard availabilityGuard = DatabaseAvailabilityGuardTest.createAvailabilityGuard(this.clock, this.log);
        availabilityGuard.init();
        availabilityGuard.start();
        Assertions.assertFalse((boolean)availabilityGuard.isShutdown());
        Assertions.assertTrue((boolean)availabilityGuard.isAvailable(waitMs));
        availabilityGuard.stop();
        availabilityGuard.shutdown();
        Assertions.assertTrue((boolean)availabilityGuard.isShutdown());
        CompletableFuture<Boolean> isAvailableFuture = CompletableFuture.supplyAsync(() -> availabilityGuard.isAvailable(waitMs));
        TimeUnit.SECONDS.sleep(1L);
        Assertions.assertFalse((boolean)isAvailableFuture.isDone());
        availabilityGuard.init();
        availabilityGuard.start();
        Assertions.assertTrue((boolean)isAvailableFuture.get(5L, TimeUnit.SECONDS));
    }

    private static void verifyLogging(Log log, VerificationMode mode) {
        ((Log)Mockito.verify((Object)log, (VerificationMode)mode)).info(ArgumentMatchers.anyString(), (Object[])Mockito.any());
    }

    private DatabaseAvailabilityGuard getDatabaseAvailabilityGuard(Clock clock, Log log) {
        DatabaseAvailabilityGuard availabilityGuard = DatabaseAvailabilityGuardTest.createAvailabilityGuard(clock, log);
        this.life.add((Lifecycle)availabilityGuard);
        return availabilityGuard;
    }

    private static DatabaseAvailabilityGuard createAvailabilityGuard(Clock clock, Log log) {
        return new DatabaseAvailabilityGuard(new TestDatabaseIdRepository().defaultDatabase(), clock, log, 0L, (CompositeDatabaseAvailabilityGuard)Mockito.mock(CompositeDatabaseAvailabilityGuard.class));
    }
}

