/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.availability.CompositeDatabaseAvailabilityGuard;
import org.neo4j.kernel.database.GlobalAvailabilityGuardController;
import org.neo4j.kernel.database.NamedDatabaseId;

class GlobalAvailabilityGuardControllerTest {
    private final CompositeDatabaseAvailabilityGuard guard = (CompositeDatabaseAvailabilityGuard)Mockito.mock(CompositeDatabaseAvailabilityGuard.class);
    private final GlobalAvailabilityGuardController guardController = new GlobalAvailabilityGuardController(this.guard);

    GlobalAvailabilityGuardControllerTest() {
    }

    @Test
    void doNotAbortOnRunning() {
        Mockito.when((Object)this.guard.isShutdown()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.guardController.shouldAbort(new NamedDatabaseId("any", UUID.randomUUID())));
    }

    @Test
    void abortOnShutdown() {
        Mockito.when((Object)this.guard.isShutdown()).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.guardController.shouldAbort(new NamedDatabaseId("any", UUID.randomUUID())));
    }
}

