/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexSampler;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

class OnlineIndexSamplingJobTest {
    private final LogProvider logProvider = NullLogProvider.getInstance();
    private final long indexId = 1L;
    private final IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexStatisticsStore indexStatisticsStore = (IndexStatisticsStore)Mockito.mock(IndexStatisticsStore.class);
    private final IndexDescriptor indexDescriptor = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptor.forLabel((int)1, (int[])new int[]{2}), (IndexProviderDescriptor)IndexProviderDescriptor.UNDECIDED).withName("index").materialise(1L);
    private final IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
    private final IndexSampler indexSampler = (IndexSampler)Mockito.mock(IndexSampler.class);
    private final long indexUniqueValues = 21L;
    private final long indexSize = 23L;

    OnlineIndexSamplingJobTest() {
    }

    @BeforeEach
    void setup() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexProxy.getDescriptor()).thenReturn((Object)this.indexDescriptor);
        Mockito.when((Object)this.indexProxy.newReader()).thenReturn((Object)this.indexReader);
        Mockito.when((Object)this.indexReader.createSampler()).thenReturn((Object)this.indexSampler);
        Mockito.when((Object)this.indexSampler.sampleIndex()).thenReturn((Object)new IndexSample(23L, 21L, 23L));
    }

    @Test
    void shouldSampleTheIndexAndStoreTheValueWhenTheIndexIsOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(1L, this.indexProxy, this.indexStatisticsStore, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        job.run();
        ((IndexStatisticsStore)Mockito.verify((Object)this.indexStatisticsStore)).replaceStats(1L, 21L, 23L, 23L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStatisticsStore});
    }

    @Test
    void shouldSampleTheIndexButDoNotStoreTheValuesIfTheIndexIsNotOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(1L, this.indexProxy, this.indexStatisticsStore, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.FAILED);
        job.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStatisticsStore});
    }
}

