/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.LongPredicate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.ThreadSafePeakMemoryAllocationTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.Barrier;
import org.neo4j.test.Race;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.actors.Actor;
import org.neo4j.test.extension.actors.ActorsExtension;
import org.neo4j.test.extension.pagecache.EphemeralPageCacheExtension;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

@ActorsExtension
@EphemeralPageCacheExtension
class BlockBasedIndexPopulatorTest {
    private static final LabelSchemaDescriptor SCHEMA_DESCRIPTOR = SchemaDescriptor.forLabel((int)1, (int[])new int[]{1});
    private static final IndexDescriptor INDEX_DESCRIPTOR = IndexPrototype.forSchema((SchemaDescriptor)SCHEMA_DESCRIPTOR).withName("index").materialise(1L);
    @Inject
    Actor merger;
    @Inject
    Actor closer;
    private IndexFiles indexFiles;
    @Inject
    FileSystemAbstraction fs;
    @Inject
    TestDirectory testDir;
    @Inject
    PageCache pageCache;

    BlockBasedIndexPopulatorTest() {
    }

    @BeforeEach
    void setup() {
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor("test", "v1");
        IndexDirectoryStructure directoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.testDir.homeDir()).forProvider(providerDescriptor);
        this.indexFiles = new IndexFiles.Directory(this.fs, directoryStructure, INDEX_DESCRIPTOR.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldAwaitMergeToBeFullyAbortedBeforeLeavingCloseMethod() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false));
            this.closer.untilWaiting();
            monitor.barrier.release();
            closeFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    private Callable<Object> scanCompletedTask(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator) {
        return () -> {
            populator.scanCompleted(PhaseTracker.nullInstance);
            return null;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldHandleBeingAbortedWhileMerging() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 2L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.await();
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Future closeFuture = this.closer.submit(() -> populator.close(false));
            this.closer.untilWaiting();
            monitor.mergeFinishedBarrier.release();
            closeFuture.get();
            closed = true;
            mergeFuture.get();
        }
        finally {
            if (!closed) {
                populator.close(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldReportAccurateProgressThroughoutThePhases() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(numberOfBlocks -> numberOfBlocks == 1L);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.5f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.barrier.release();
            monitor.mergeFinishedBarrier.awaitUninterruptibly();
            Assertions.assertEquals((float)0.7f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.1f);
            monitor.mergeFinishedBarrier.release();
            mergeFuture.get();
            Assertions.assertEquals((float)1.0f, (float)populator.progress(PopulationProgress.DONE).getProgress(), (float)0.0f);
        }
        finally {
            populator.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldCorrectlyDecideToAwaitMergeDependingOnProgress() throws Throwable {
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Race race = new Race();
            race.addContestant(Race.throwing(() -> populator.scanCompleted(PhaseTracker.nullInstance)));
            race.addContestant(Race.throwing(() -> populator.close(false)));
            race.go();
            closed = true;
            EphemeralFileSystemAbstraction ephemeralFileSystem = (EphemeralFileSystemAbstraction)this.fs;
            ephemeralFileSystem.assertNoOpenFiles();
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeleteDirectoryOnDrop() throws Exception {
        TrappingMonitor monitor = new TrappingMonitor(ignore -> false);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator((BlockStorage.Monitor)monitor);
        boolean closed = false;
        try {
            populator.add(BlockBasedIndexPopulatorTest.batchOfUpdates());
            Future mergeFuture = this.merger.submit(this.scanCompletedTask(populator));
            monitor.barrier.awaitUninterruptibly();
            Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getBase()));
            Assertions.assertTrue((boolean)this.fs.isDirectory(this.indexFiles.getBase()));
            Assertions.assertTrue((this.fs.listFiles(this.indexFiles.getBase()).length > 0 ? 1 : 0) != 0);
            Future dropFuture = this.closer.submit(() -> populator.drop());
            this.closer.untilWaiting();
            monitor.barrier.release();
            dropFuture.get();
            closed = true;
            Assertions.assertTrue((boolean)mergeFuture.isDone());
            Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getBase()));
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnClose() throws IndexEntryConflictException {
        ThreadSafePeakMemoryAllocationTracker memoryTracker = new ThreadSafePeakMemoryAllocationTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator((MemoryAllocationTracker)memoryTracker), 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedDirectMemory();
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.close(true);
            Assertions.assertEquals((long)memoryBeforeScanCompleted, (long)memoryTracker.usedDirectMemory(), (String)"expected all allocated memory to have been freed on close");
            closed = true;
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldDeallocateAllAllocatedMemoryOnDrop() throws IndexEntryConflictException {
        ThreadSafePeakMemoryAllocationTracker memoryTracker = new ThreadSafePeakMemoryAllocationTracker();
        ByteBufferFactory bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator((MemoryAllocationTracker)memoryTracker), 100);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = this.instantiatePopulator(BlockStorage.Monitor.NO_MONITOR, bufferFactory);
        boolean closed = false;
        try {
            Collection<IndexEntryUpdate<?>> updates = BlockBasedIndexPopulatorTest.batchOfUpdates();
            populator.add(updates);
            int nextId = updates.size();
            this.externalUpdates(populator, nextId, nextId + 10);
            long memoryBeforeScanCompleted = memoryTracker.usedDirectMemory();
            populator.scanCompleted(PhaseTracker.nullInstance);
            this.externalUpdates(populator, nextId += 10, nextId + 10);
            Assertions.assertTrue((memoryTracker.peakMemoryUsage() > memoryBeforeScanCompleted ? 1 : 0) != 0, (String)"expected some memory to have been temporarily allocated in scanCompleted");
            populator.drop();
            closed = true;
            Assertions.assertEquals((long)memoryBeforeScanCompleted, (long)memoryTracker.usedDirectMemory(), (String)"expected all allocated memory to have been freed on drop");
            bufferFactory.close();
            Assertions.assertEquals((long)0L, (long)memoryTracker.usedDirectMemory());
        }
        finally {
            if (!closed) {
                populator.close(true);
            }
        }
    }

    private void externalUpdates(BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator, int firstId, int lastId) throws IndexEntryConflictException {
        try (IndexUpdater updater = populator.newPopulatingUpdater();){
            for (int i = firstId; i < lastId; ++i) {
                updater.process(BlockBasedIndexPopulatorTest.add(i));
            }
        }
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor) {
        return this.instantiatePopulator(monitor, ByteBufferFactory.heapBufferFactory((int)100));
    }

    private BlockBasedIndexPopulator<GenericKey, NativeIndexValue> instantiatePopulator(BlockStorage.Monitor monitor, ByteBufferFactory bufferFactory) {
        IndexSpecificSpaceFillingCurveSettings spatialSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
        GenericLayout layout = new GenericLayout(1, spatialSettings);
        BlockBasedIndexPopulator<GenericKey, NativeIndexValue> populator = new BlockBasedIndexPopulator<GenericKey, NativeIndexValue>(this.pageCache, this.fs, this.indexFiles, (IndexLayout)layout, IndexProvider.Monitor.EMPTY, INDEX_DESCRIPTOR, false, bufferFactory, 2, monitor){

            NativeIndexReader<GenericKey, NativeIndexValue> newReader() {
                throw new UnsupportedOperationException("Not needed in this test");
            }
        };
        populator.create();
        return populator;
    }

    private static Collection<IndexEntryUpdate<?>> batchOfUpdates() {
        ArrayList updates = new ArrayList();
        for (int i = 0; i < 50; ++i) {
            updates.add(BlockBasedIndexPopulatorTest.add(i));
        }
        return updates;
    }

    private static IndexEntryUpdate<IndexDescriptor> add(int i) {
        return IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)INDEX_DESCRIPTOR, (Value[])new Value[]{Values.stringValue((String)("Value" + i))});
    }

    private static class TrappingMonitor
    extends BlockStorage.Monitor.Adapter {
        private final Barrier.Control barrier = new Barrier.Control();
        private final Barrier.Control mergeFinishedBarrier = new Barrier.Control();
        private final LongPredicate trapForMergeIterationFinished;

        TrappingMonitor(LongPredicate trapForMergeIterationFinished) {
            this.trapForMergeIterationFinished = trapForMergeIterationFinished;
        }

        public void mergedBlocks(long resultingBlockSize, long resultingEntryCount, long numberOfBlocks) {
            this.barrier.reached();
        }

        public void mergeIterationFinished(long numberOfBlocksBefore, long numberOfBlocksAfter) {
            if (this.trapForMergeIterationFinished.test(numberOfBlocksAfter)) {
                this.mergeFinishedBarrier.reached();
            }
        }
    }
}

