/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.schema.index.TestIndexDescriptorFactory;
import org.neo4j.kernel.impl.index.schema.DeferredConflictCheckingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NodeIdsIndexReaderQueryAnswer;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class DeferredConflictCheckingIndexUpdaterTest {
    private static final int labelId = 1;
    private final int[] propertyKeyIds = new int[]{2, 3};
    private final IndexDescriptor descriptor = TestIndexDescriptorFactory.forLabel(1, this.propertyKeyIds);

    DeferredConflictCheckingIndexUpdaterTest() {
    }

    @Test
    void shouldQueryAboutAddedAndChangedValueTuples() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        ((IndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.descriptor, new long[]{0L})).when((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexOrder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexQuery[])ArgumentMatchers.any());
        long nodeId = 0L;
        ArrayList<IndexEntryUpdate> updates = new ArrayList<IndexEntryUpdate>();
        updates.add(IndexEntryUpdate.add((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(10, 11)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple("abc", "def"), (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple("ghi", "klm")));
        updates.add(IndexEntryUpdate.remove((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(1001L, 1002L)));
        updates.add(IndexEntryUpdate.change((long)nodeId++, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple((byte)2, (byte)3), (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple((byte)4, (byte)5)));
        updates.add(IndexEntryUpdate.add((long)nodeId, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(5, "5")));
        try (DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor);){
            for (IndexEntryUpdate update : updates) {
                updater.process(update);
                ((IndexUpdater)Mockito.verify((Object)actual)).process(update);
            }
        }
        for (IndexEntryUpdate update : updates) {
            if (update.updateMode() != UpdateMode.ADDED && update.updateMode() != UpdateMode.CHANGED) continue;
            Value[] tuple = update.values();
            IndexQuery[] query = new IndexQuery[tuple.length];
            for (int i = 0; i < tuple.length; ++i) {
                query[i] = IndexQuery.exact((int)this.propertyKeyIds[i], (Object)tuple[i]);
            }
            ((IndexReader)Mockito.verify((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexOrder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), new IndexQuery[]{(IndexQuery)ArgumentMatchers.eq((Object)query[0]), (IndexQuery)ArgumentMatchers.eq((Object)query[1])});
        }
        ((IndexReader)Mockito.verify((Object)reader)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{reader});
    }

    @Test
    void shouldThrowOnIndexEntryConflict() throws Exception {
        IndexUpdater actual = (IndexUpdater)Mockito.mock(IndexUpdater.class);
        IndexReader reader = (IndexReader)Mockito.mock(IndexReader.class);
        ((IndexReader)Mockito.doAnswer((Answer)new NodeIdsIndexReaderQueryAnswer(this.descriptor, new long[]{101L, 202L})).when((Object)reader)).query((QueryContext)ArgumentMatchers.any(), (IndexProgressor.EntityValueClient)ArgumentMatchers.any(), (IndexOrder)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (IndexQuery[])ArgumentMatchers.any());
        DeferredConflictCheckingIndexUpdater updater = new DeferredConflictCheckingIndexUpdater(actual, () -> reader, this.descriptor);
        updater.process(IndexEntryUpdate.add((long)0L, (SchemaDescriptorSupplier)this.descriptor, (Value[])DeferredConflictCheckingIndexUpdaterTest.tuple(10, 11)));
        IndexEntryConflictException e = (IndexEntryConflictException)Assertions.assertThrows(IndexEntryConflictException.class, () -> ((DeferredConflictCheckingIndexUpdater)updater).close());
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"101"));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"202"));
    }

    private static Value[] tuple(Object ... values) {
        Value[] result = new Value[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = Values.of((Object)values[i]);
        }
        return result;
    }
}

