/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.configuration.Config;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.io.pagecache.ByteArrayPageCursor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GeometryType;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.string.UTF8;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.values.AnyValues;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;

@ExtendWith(value={RandomExtension.class})
@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class GenericKeyStateTest {
    private final IndexSpecificSpaceFillingCurveSettings noSpecificIndexSettings = IndexSpecificSpaceFillingCurveSettings.fromConfig((Config)Config.defaults());
    @Inject
    private static RandomRule random;

    GenericKeyStateTest() {
    }

    @BeforeEach
    void setupRandomConfig() {
        random = random.withConfiguration(new RandomValues.Configuration(){

            public int stringMinLength() {
                return 0;
            }

            public int stringMaxLength() {
                return 50;
            }

            public int arrayMinLength() {
                return 0;
            }

            public int arrayMaxLength() {
                return 10;
            }

            public int maxCodePoint() {
                return 65535;
            }

            public int minCodePoint() {
                return 0;
            }
        });
        random.reset();
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void readWhatIsWritten(ValueGenerator valueGenerator) {
        PageCursor cursor = this.newPageCursor();
        GenericKey writeState = this.newKeyState();
        Value value = valueGenerator.next();
        int offset = cursor.getOffset();
        writeState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        writeState.put(cursor);
        GenericKey readState = this.newKeyState();
        int size = writeState.size();
        cursor.setOffset(offset);
        Assertions.assertTrue((boolean)readState.get(cursor, size), (String)"failed to read");
        Assertions.assertEquals((int)0, (int)readState.compareValueTo(writeState), (String)"key states are not equal");
        Value readValue = readState.asValue();
        Assertions.assertEquals((Object)value, (Object)readValue, (String)"deserialized values are not equal");
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void copyShouldCopy(ValueGenerator valueGenerator) {
        GenericKey from = this.newKeyState();
        Value value = valueGenerator.next();
        from.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey to = this.genericKeyStateWithSomePreviousState(valueGenerator);
        to.copyFrom(from);
        Assertions.assertEquals((int)0, (int)from.compareValueTo(to), (String)"states not equals after copy");
    }

    @Test
    void copyShouldCopyExtremeValues() {
        GenericKey extreme = this.newKeyState();
        GenericKey copy = this.newKeyState();
        for (ValueGroup valueGroup : ValueGroup.values()) {
            if (valueGroup == ValueGroup.NO_VALUE) continue;
            extreme.initValueAsLowest(valueGroup);
            copy.copyFrom(extreme);
            Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy), (String)("states not equals after copy, valueGroup=" + valueGroup));
            extreme.initValueAsHighest(valueGroup);
            copy.copyFrom(extreme);
            Assertions.assertEquals((int)0, (int)extreme.compareValueTo(copy), (String)("states not equals after copy, valueGroup=" + valueGroup));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"validComparableValueGenerators"})
    void compareToMustAlignWithValuesCompareTo(ValueGenerator valueGenerator) {
        int i;
        ArrayList<Value> values = new ArrayList<Value>();
        ArrayList<GenericKey> states = new ArrayList<GenericKey>();
        for (i = 0; i < 10; ++i) {
            Value value = valueGenerator.next();
            values.add(value);
            GenericKey state = this.newKeyState();
            state.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
            states.add(state);
        }
        values.sort((Comparator<Value>)Values.COMPARATOR);
        states.sort(GenericKey::compareValueTo);
        for (i = 0; i < values.size(); ++i) {
            Assertions.assertEquals(values.get(i), (Object)((GenericKey)states.get(i)).asValue(), (String)"sort order was different");
        }
    }

    @Test
    void comparePointsMustOnlyReturnZeroForEqualPoints() {
        PointValue firstPoint = random.randomValues().nextPointValue();
        PointValue equalPoint = Values.point((Point)firstPoint);
        CoordinateReferenceSystem crs = firstPoint.getCoordinateReferenceSystem();
        SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs);
        Long spaceFillingCurveValue = curve.derivedValueFor(firstPoint.coordinate());
        PointValue centerPoint = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        GenericKey firstKey = this.newKeyState();
        firstKey.writeValue((Value)firstPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey equalKey = this.newKeyState();
        equalKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey centerKey = this.newKeyState();
        centerKey.writeValue((Value)centerPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey noCoordsKey = this.newKeyState();
        noCoordsKey.writeValue((Value)equalPoint, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstPoint.compareTo(centerPoint) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo(centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(noCoordsKey), (String)"expected keys to be equal");
    }

    @Test
    void comparePointArraysMustOnlyReturnZeroForEqualArrays() {
        PointArray firstArray = random.randomValues().nextPointArray();
        PointValue[] sourcePointValues = (PointValue[])firstArray.asObjectCopy();
        PointArray equalArray = Values.pointArray((PointValue[])sourcePointValues);
        PointValue[] centerPointValues = new PointValue[sourcePointValues.length];
        for (int i = 0; i < sourcePointValues.length; ++i) {
            PointValue sourcePointValue = sourcePointValues[i];
            CoordinateReferenceSystem crs = sourcePointValue.getCoordinateReferenceSystem();
            SpaceFillingCurve curve = this.noSpecificIndexSettings.forCrs(crs);
            Long spaceFillingCurveValue = curve.derivedValueFor(sourcePointValue.coordinate());
            centerPointValues[i] = Values.pointValue((CoordinateReferenceSystem)crs, (double[])curve.centerPointFor(spaceFillingCurveValue.longValue()));
        }
        PointArray centerArray = Values.pointArray((PointValue[])centerPointValues);
        GenericKey firstKey = this.newKeyState();
        firstKey.writeValue((Value)firstArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey equalKey = this.newKeyState();
        equalKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey centerKey = this.newKeyState();
        centerKey.writeValue((Value)centerArray, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey noCoordsKey = this.newKeyState();
        noCoordsKey.writeValue((Value)equalArray, NativeIndexKey.Inclusion.NEUTRAL);
        GeometryType.setNoCoordinates((GenericKey)noCoordsKey);
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(equalKey), (String)"expected keys to be equal");
        Assertions.assertEquals((Object)(firstArray.compareToSequence((SequenceValue)centerArray, AnyValues.COMPARATOR) != 0 ? 1 : 0), (Object)(firstKey.compareValueTo(centerKey) != 0 ? 1 : 0), (String)"expected keys to be equal if and only if source points are equal");
        Assertions.assertEquals((int)0, (int)firstKey.compareValueTo(noCoordsKey), (String)"expected keys to be equal");
    }

    @ParameterizedTest
    @MethodSource(value={"validComparableValueGenerators"})
    void mustProduceValidMinimalSplitters(ValueGenerator valueGenerator) {
        Value value2;
        Value value1 = valueGenerator.next();
        while (Values.COMPARATOR.compare(value1, value2 = valueGenerator.next()) == 0) {
        }
        Value left = this.pickSmaller(value1, value2);
        Value right = left == value1 ? value2 : value1;
        this.assertValidMinimalSplitter(left, right);
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void mustProduceValidMinimalSplittersWhenValuesAreEqual(ValueGenerator valueGenerator) {
        this.assertValidMinimalSplitterForEqualValues(valueGenerator.next());
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void mustReportCorrectSize(ValueGenerator valueGenerator) {
        PageCursor cursor = this.newPageCursor();
        Value value = valueGenerator.next();
        GenericKey state = this.newKeyState();
        state.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        int offsetBefore = cursor.getOffset();
        int reportedSize = state.size();
        state.put(cursor);
        int offsetAfter = cursor.getOffset();
        int actualSize = offsetAfter - offsetBefore;
        Assertions.assertEquals((int)reportedSize, (int)actualSize, (String)String.format("did not report correct size, value=%s, actualSize=%d, reportedSize=%d", value, actualSize, reportedSize));
    }

    @Test
    void lowestMustBeLowest() {
        this.assertLowest((Value)PointValue.MIN_VALUE);
        this.assertLowest((Value)DateTimeValue.MIN_VALUE);
        this.assertLowest((Value)LocalDateTimeValue.MIN_VALUE);
        this.assertLowest((Value)DateValue.MIN_VALUE);
        this.assertLowest((Value)TimeValue.MIN_VALUE);
        this.assertLowest((Value)LocalTimeValue.MIN_VALUE);
        this.assertLowest((Value)DurationValue.duration((Duration)Duration.ofSeconds(Long.MIN_VALUE, 0L)));
        this.assertLowest((Value)DurationValue.duration((Period)Period.of(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE)));
        this.assertLowest(Values.of((Object)UTF8.decode((byte[])new byte[0])));
        this.assertLowest(Values.of((Object)false));
        this.assertLowest(Values.of((Object)-128));
        this.assertLowest(Values.of((Object)Short.MIN_VALUE));
        this.assertLowest(Values.of((Object)Integer.MIN_VALUE));
        this.assertLowest(Values.of((Object)Long.MIN_VALUE));
        this.assertLowest(Values.of((Object)Float.valueOf(Float.NEGATIVE_INFINITY)));
        this.assertLowest(Values.of((Object)Double.NEGATIVE_INFINITY));
        this.assertLowest((Value)Values.pointArray((PointValue[])new PointValue[0]));
        this.assertLowest((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[0]));
        this.assertLowest((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[0]));
        this.assertLowest((Value)Values.dateArray((LocalDate[])new LocalDate[0]));
        this.assertLowest((Value)Values.timeArray((OffsetTime[])new OffsetTime[0]));
        this.assertLowest((Value)Values.localTimeArray((LocalTime[])new LocalTime[0]));
        this.assertLowest((Value)Values.durationArray((DurationValue[])new DurationValue[0]));
        this.assertLowest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[0]));
        this.assertLowest(Values.of((Object)new String[0]));
        this.assertLowest(Values.of((Object)new boolean[0]));
        this.assertLowest(Values.of((Object)new byte[0]));
        this.assertLowest(Values.of((Object)new short[0]));
        this.assertLowest(Values.of((Object)new int[0]));
        this.assertLowest(Values.of((Object)new long[0]));
        this.assertLowest(Values.of((Object)new float[0]));
        this.assertLowest(Values.of((Object)new double[0]));
    }

    @Test
    void highestMustBeHighest() {
        this.assertHighest((Value)PointValue.MAX_VALUE);
        this.assertHighest((Value)DateTimeValue.MAX_VALUE);
        this.assertHighest((Value)LocalDateTimeValue.MAX_VALUE);
        this.assertHighest((Value)DateValue.MAX_VALUE);
        this.assertHighest((Value)TimeValue.MAX_VALUE);
        this.assertHighest((Value)LocalTimeValue.MAX_VALUE);
        this.assertHighest((Value)DurationValue.duration((Duration)Duration.ofSeconds(Long.MAX_VALUE, 999999999L)));
        this.assertHighest((Value)DurationValue.duration((Period)Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)));
        this.assertHighestString();
        this.assertHighest(Values.of((Object)true));
        this.assertHighest(Values.of((Object)127));
        this.assertHighest(Values.of((Object)Short.MAX_VALUE));
        this.assertHighest(Values.of((Object)Integer.MAX_VALUE));
        this.assertHighest(Values.of((Object)Long.MAX_VALUE));
        this.assertHighest(Values.of((Object)Float.valueOf(Float.POSITIVE_INFINITY)));
        this.assertHighest(Values.of((Object)Double.POSITIVE_INFINITY));
        this.assertHighest((Value)Values.pointArray((PointValue[])new PointValue[]{PointValue.MAX_VALUE}));
        this.assertHighest((Value)Values.dateTimeArray((ZonedDateTime[])new ZonedDateTime[]{(ZonedDateTime)DateTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.localDateTimeArray((LocalDateTime[])new LocalDateTime[]{(LocalDateTime)LocalDateTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.dateArray((LocalDate[])new LocalDate[]{(LocalDate)DateValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.timeArray((OffsetTime[])new OffsetTime[]{(OffsetTime)TimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.localTimeArray((LocalTime[])new LocalTime[]{(LocalTime)LocalTimeValue.MAX_VALUE.asObjectCopy()}));
        this.assertHighest((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Duration)Duration.ofSeconds(Long.MAX_VALUE, 999999999L))}));
        this.assertHighest((Value)Values.durationArray((DurationValue[])new DurationValue[]{DurationValue.duration((Period)Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE))}));
        this.assertHighest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[]{Duration.ofSeconds(Long.MAX_VALUE, 999999999L)}));
        this.assertHighest((Value)Values.durationArray((TemporalAmount[])new TemporalAmount[]{Period.of(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE)}));
        this.assertHighestStringArray();
        this.assertHighest((Value)Values.booleanArray((boolean[])new boolean[]{true}));
        this.assertHighest((Value)Values.byteArray((byte[])new byte[]{127}));
        this.assertHighest((Value)Values.shortArray((short[])new short[]{Short.MAX_VALUE}));
        this.assertHighest((Value)Values.intArray((int[])new int[]{Integer.MAX_VALUE}));
        this.assertHighest((Value)Values.longArray((long[])new long[]{Long.MAX_VALUE}));
        this.assertHighest((Value)Values.floatArray((float[])new float[]{Float.POSITIVE_INFINITY}));
        this.assertHighest((Value)Values.doubleArray((double[])new double[]{Double.POSITIVE_INFINITY}));
    }

    @Test
    void shouldNeverOverwriteDereferencedTextValues() {
        TextValue srcValue = Values.utf8Value((byte[])"First string".getBytes(StandardCharsets.UTF_8));
        GenericKey genericKeyState = this.newKeyState();
        genericKeyState.writeValue((Value)srcValue, NativeIndexKey.Inclusion.NEUTRAL);
        Value dereferencedValue = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
        PageCursor cursor = this.newPageCursor();
        int offset = cursor.getOffset();
        genericKeyState.put(cursor);
        int keySize = cursor.getOffset() - offset;
        cursor.setOffset(offset);
        genericKeyState.clear();
        TextValue srcValue2 = Values.utf8Value((byte[])"Secondstring".getBytes(StandardCharsets.UTF_8));
        genericKeyState.writeValue((Value)srcValue2, NativeIndexKey.Inclusion.NEUTRAL);
        Value dereferencedValue2 = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue2, (Object)dereferencedValue2);
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
        genericKeyState.clear();
        genericKeyState.get(cursor, keySize);
        Value dereferencedValue3 = genericKeyState.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue3);
        Assertions.assertEquals((Object)srcValue2, (Object)dereferencedValue2);
        Assertions.assertEquals((Object)srcValue, (Object)dereferencedValue);
    }

    @Test
    void indexedCharShouldComeBackAsCharValue() {
        this.shouldReadBackToExactOriginalValue((Value)random.randomValues().nextCharValue());
    }

    @Test
    void indexedCharArrayShouldComeBackAsCharArrayValue() {
        this.shouldReadBackToExactOriginalValue((Value)random.randomValues().nextCharArray());
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void minimalSplitterForSameValueShouldDivideLeftAndRight(ValueGenerator valueGenerator) {
        Value value = valueGenerator.next();
        GenericLayout layout = this.newLayout(1);
        GenericKey left = layout.newKey();
        GenericKey right = layout.newKey();
        GenericKey minimalSplitter = layout.newKey();
        left.initialize(1L);
        left.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
        right.initialize(2L);
        right.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertTrue((layout.compare((NativeIndexKey)left, (NativeIndexKey)minimalSplitter) < 0 ? 1 : 0) != 0, (String)("Expected minimal splitter to be strictly greater than left but wasn't for value " + value));
        Assertions.assertTrue((layout.compare((NativeIndexKey)minimalSplitter, (NativeIndexKey)right) <= 0 ? 1 : 0) != 0, (String)("Expected right to be greater than or equal to minimal splitter but wasn't for value " + value));
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void minimalSplitterShouldRemoveEntityIdIfPossible(ValueGenerator valueGenerator) {
        Value firstValue = valueGenerator.next();
        Value secondValue = this.uniqueSecondValue(valueGenerator, firstValue);
        Value leftValue = this.pickSmaller(firstValue, secondValue);
        Value rightValue = this.pickOther(firstValue, secondValue, leftValue);
        GenericLayout layout = this.newLayout(1);
        GenericKey left = layout.newKey();
        GenericKey right = layout.newKey();
        GenericKey minimalSplitter = layout.newKey();
        left.initialize(1L);
        left.initFromValue(0, leftValue, NativeIndexKey.Inclusion.NEUTRAL);
        right.initialize(2L);
        right.initFromValue(0, rightValue, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertEquals((long)-1L, (long)minimalSplitter.getEntityId(), (String)("Expected minimal splitter to have entityId removed when constructed from keys with unique values: left=" + leftValue + ", right=" + rightValue));
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void minimalSplitterForSameValueShouldDivideLeftAndRightCompositeKey(ValueGenerator valueGenerator) {
        int nbrOfSlots = random.nextInt(1, 5);
        GenericLayout layout = this.newLayout(nbrOfSlots);
        GenericKey left = layout.newKey();
        GenericKey right = layout.newKey();
        GenericKey minimalSplitter = layout.newKey();
        left.initialize(1L);
        right.initialize(2L);
        Object[] values = new Value[nbrOfSlots];
        for (int slot = 0; slot < nbrOfSlots; ++slot) {
            Value value;
            values[slot] = value = valueGenerator.next();
            left.initFromValue(slot, value, NativeIndexKey.Inclusion.NEUTRAL);
            right.initFromValue(slot, value, NativeIndexKey.Inclusion.NEUTRAL);
        }
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertTrue((layout.compare((NativeIndexKey)left, (NativeIndexKey)minimalSplitter) < 0 ? 1 : 0) != 0, (String)("Expected minimal splitter to be strictly greater than left but wasn't for value " + Arrays.toString(values)));
        Assertions.assertTrue((layout.compare((NativeIndexKey)minimalSplitter, (NativeIndexKey)right) <= 0 ? 1 : 0) != 0, (String)("Expected right to be greater than or equal to minimal splitter but wasn't for value " + Arrays.toString(values)));
    }

    @ParameterizedTest
    @MethodSource(value={"validValueGenerators"})
    void minimalSplitterShouldRemoveEntityIdIfPossibleCompositeKey(ValueGenerator valueGenerator) {
        int nbrOfSlots = random.nextInt(1, 5);
        int differingSlot = random.nextInt(nbrOfSlots);
        GenericLayout layout = this.newLayout(nbrOfSlots);
        GenericKey left = layout.newKey();
        GenericKey right = layout.newKey();
        GenericKey minimalSplitter = layout.newKey();
        left.initialize(1L);
        right.initialize(2L);
        for (int slot = 0; slot < nbrOfSlots; ++slot) {
            if (slot == differingSlot) continue;
            Value value = valueGenerator.next();
            left.initFromValue(slot, value, NativeIndexKey.Inclusion.NEUTRAL);
            right.initFromValue(slot, value, NativeIndexKey.Inclusion.NEUTRAL);
        }
        Value firstValue = valueGenerator.next();
        Value secondValue = this.uniqueSecondValue(valueGenerator, firstValue);
        Value leftValue = this.pickSmaller(firstValue, secondValue);
        Value rightValue = this.pickOther(firstValue, secondValue, leftValue);
        left.initFromValue(differingSlot, leftValue, NativeIndexKey.Inclusion.NEUTRAL);
        right.initFromValue(differingSlot, rightValue, NativeIndexKey.Inclusion.NEUTRAL);
        layout.minimalSplitter(left, right, minimalSplitter);
        Assertions.assertEquals((long)-1L, (long)minimalSplitter.getEntityId(), (String)("Expected minimal splitter to have entityId removed when constructed from keys with unique values: left=" + leftValue + ", right=" + rightValue));
    }

    @ParameterizedTest
    @MethodSource(value={"singleValueGeneratorsStream"})
    void testDocumentedKeySizesNonArrays(ValueGenerator generator) {
        int expectedSizeOfData;
        Value value = generator.next();
        GenericKey key = this.newKeyState();
        key.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
        int keySize = key.size();
        int keyOverhead = 8;
        int actualSizeOfData = keySize - keyOverhead;
        String typeName = value.getTypeName();
        switch (value.valueGroup()) {
            case NUMBER: {
                expectedSizeOfData = this.getNumberSize(value);
                break;
            }
            case BOOLEAN: {
                expectedSizeOfData = 2;
                break;
            }
            case DATE: {
                expectedSizeOfData = 9;
                break;
            }
            case ZONED_TIME: {
                expectedSizeOfData = 13;
                break;
            }
            case LOCAL_TIME: {
                expectedSizeOfData = 9;
                break;
            }
            case ZONED_DATE_TIME: {
                expectedSizeOfData = 17;
                break;
            }
            case LOCAL_DATE_TIME: {
                expectedSizeOfData = 13;
                break;
            }
            case DURATION: {
                expectedSizeOfData = 29;
                break;
            }
            case GEOMETRY: {
                expectedSizeOfData = this.getGeometrySize(value);
                break;
            }
            case TEXT: {
                expectedSizeOfData = this.getStringSize(value);
                break;
            }
            default: {
                throw new RuntimeException("Did not expect this type to be tested in this test. Value was " + value);
            }
        }
        GenericKeyStateTest.assertKeySize(expectedSizeOfData, actualSizeOfData, typeName);
    }

    @ParameterizedTest
    @MethodSource(value={"arrayValueGeneratorsStream"})
    void testDocumentedKeySizesArrays(ValueGenerator generator) {
        int arrayElementSize;
        int arrayOverhead;
        Value value = generator.next();
        GenericKey key = this.newKeyState();
        key.initFromValue(0, value, NativeIndexKey.Inclusion.NEUTRAL);
        int keySize = key.size();
        int keyOverhead = 8;
        int actualSizeOfData = keySize - keyOverhead;
        int arrayLength = 0;
        if (value instanceof ArrayValue) {
            arrayLength = ((ArrayValue)value).length();
        }
        int normalArrayOverhead = 3;
        int numberArrayOverhead = 4;
        int geometryArrayOverhead = 6;
        String typeName = value.getTypeName();
        switch (value.valueGroup()) {
            case NUMBER_ARRAY: {
                arrayOverhead = numberArrayOverhead;
                arrayElementSize = this.getNumberArrayElementSize(value);
                break;
            }
            case BOOLEAN_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 1;
                break;
            }
            case DATE_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 8;
                break;
            }
            case ZONED_TIME_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 12;
                break;
            }
            case LOCAL_TIME_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 8;
                break;
            }
            case ZONED_DATE_TIME_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 16;
                break;
            }
            case LOCAL_DATE_TIME_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 12;
                break;
            }
            case DURATION_ARRAY: {
                arrayOverhead = normalArrayOverhead;
                arrayElementSize = 28;
                break;
            }
            case GEOMETRY_ARRAY: {
                arrayOverhead = geometryArrayOverhead;
                arrayElementSize = this.getGeometryArrayElementSize(value, arrayLength);
                break;
            }
            case TEXT_ARRAY: {
                this.assertTextArraySize(value, actualSizeOfData, normalArrayOverhead, typeName);
                return;
            }
            default: {
                throw new RuntimeException("Did not expect this type to be tested in this test. Value was " + value + " is value group " + value.valueGroup());
            }
        }
        int expectedSizeOfData = arrayOverhead + arrayLength * arrayElementSize;
        GenericKeyStateTest.assertKeySize(expectedSizeOfData, actualSizeOfData, typeName);
    }

    private static void assertKeySize(int expectedKeySize, int actualKeySize, String type) {
        Assertions.assertEquals((int)expectedKeySize, (int)actualKeySize, (String)("Expected keySize for type " + type + " to be " + expectedKeySize + " but was " + actualKeySize));
    }

    private void shouldReadBackToExactOriginalValue(Value srcValue) {
        GenericKey state = this.newKeyState();
        state.clear();
        state.writeValue(srcValue, NativeIndexKey.Inclusion.NEUTRAL);
        Value retrievedValueAfterWrittenToState = state.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)retrievedValueAfterWrittenToState);
        Assertions.assertEquals(srcValue.getClass(), retrievedValueAfterWrittenToState.getClass());
        PageCursor cursor = this.newPageCursor();
        int offset = cursor.getOffset();
        state.put(cursor);
        int keySize = cursor.getOffset() - offset;
        cursor.setOffset(offset);
        state.clear();
        state.get(cursor, keySize);
        Value retrievedValueAfterReadFromCursor = state.asValue();
        Assertions.assertEquals((Object)srcValue, (Object)retrievedValueAfterReadFromCursor);
        Assertions.assertEquals(srcValue.getClass(), retrievedValueAfterReadFromCursor.getClass());
    }

    private void assertHighestStringArray() {
        for (int i = 0; i < 1000; ++i) {
            this.assertHighest((Value)random.randomValues().nextTextArray());
        }
    }

    private void assertHighestString() {
        for (int i = 0; i < 1000; ++i) {
            this.assertHighest((Value)random.randomValues().nextTextValue());
        }
    }

    private void assertHighest(Value value) {
        GenericKey highestOfAll = this.newKeyState();
        GenericKey highestInValueGroup = this.newKeyState();
        GenericKey other = this.newKeyState();
        highestOfAll.initValueAsHighest(ValueGroup.UNKNOWN);
        highestInValueGroup.initValueAsHighest(value.valueGroup());
        other.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        Assertions.assertTrue((highestInValueGroup.compareValueTo(other) > 0 ? 1 : 0) != 0, (String)("highestInValueGroup not higher than " + value));
        Assertions.assertTrue((highestOfAll.compareValueTo(other) > 0 ? 1 : 0) != 0, (String)("highestOfAll not higher than " + value));
        Assertions.assertTrue((highestOfAll.compareValueTo(highestInValueGroup) > 0 || highestOfAll.type == highestInValueGroup.type ? 1 : 0) != 0, (String)"highestOfAll not higher than highestInValueGroup");
    }

    private void assertLowest(Value value) {
        GenericKey lowestOfAll = this.newKeyState();
        GenericKey lowestInValueGroup = this.newKeyState();
        GenericKey other = this.newKeyState();
        lowestOfAll.initValueAsLowest(ValueGroup.UNKNOWN);
        lowestInValueGroup.initValueAsLowest(value.valueGroup());
        other.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        Assertions.assertTrue((lowestInValueGroup.compareValueTo(other) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lowestOfAll.compareValueTo(other) <= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((lowestOfAll.compareValueTo(lowestInValueGroup) <= 0 ? 1 : 0) != 0);
    }

    private Value pickSmaller(Value value1, Value value2) {
        return Values.COMPARATOR.compare(value1, value2) < 0 ? value1 : value2;
    }

    private void assertValidMinimalSplitter(Value left, Value right) {
        GenericKey leftState = this.newKeyState();
        leftState.writeValue(left, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey rightState = this.newKeyState();
        rightState.writeValue(right, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey minimalSplitter = this.newKeyState();
        rightState.minimalSplitter(leftState, rightState, minimalSplitter);
        Assertions.assertTrue((leftState.compareValueTo(minimalSplitter) < 0 ? 1 : 0) != 0, (String)("left state not less than minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
        Assertions.assertTrue((rightState.compareValueTo(minimalSplitter) >= 0 ? 1 : 0) != 0, (String)("right state not less than minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
    }

    private void assertValidMinimalSplitterForEqualValues(Value value) {
        GenericKey leftState = this.newKeyState();
        leftState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey rightState = this.newKeyState();
        rightState.writeValue(value, NativeIndexKey.Inclusion.NEUTRAL);
        GenericKey minimalSplitter = this.newKeyState();
        rightState.minimalSplitter(leftState, rightState, minimalSplitter);
        Assertions.assertEquals((int)0, (int)leftState.compareValueTo(minimalSplitter), (String)("left state not equal to minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
        Assertions.assertEquals((int)0, (int)rightState.compareValueTo(minimalSplitter), (String)("right state not equal to minimal splitter, leftState=" + leftState + ", rightState=" + rightState + ", minimalSplitter=" + minimalSplitter));
    }

    private static Value nextValidValue(boolean includeIncomparable) {
        Value value;
        do {
            value = random.randomValues().nextValue();
        } while (!includeIncomparable && GenericKeyStateTest.isIncomparable(value));
        return value;
    }

    private static boolean isIncomparable(Value value) {
        return Values.isGeometryValue((Value)value) || Values.isGeometryArray((Value)value);
    }

    private static ValueGenerator[] listValueGenerators(boolean includeIncomparable) {
        ArrayList<ValueGenerator> generators = new ArrayList<ValueGenerator>();
        generators.addAll(GenericKeyStateTest.singleValueGenerators(includeIncomparable));
        generators.addAll(GenericKeyStateTest.arrayValueGenerators(includeIncomparable));
        generators.add(() -> GenericKeyStateTest.nextValidValue(includeIncomparable));
        return generators.toArray(new ValueGenerator[0]);
    }

    private static List<ValueGenerator> singleValueGenerators(boolean includeIncomparable) {
        ArrayList<ValueGenerator> generators = new ArrayList<ValueGenerator>(Arrays.asList(() -> random.randomValues().nextDateTimeValue(), () -> random.randomValues().nextLocalDateTimeValue(), () -> random.randomValues().nextDateValue(), () -> random.randomValues().nextTimeValue(), () -> random.randomValues().nextLocalTimeValue(), () -> random.randomValues().nextPeriod(), () -> random.randomValues().nextDuration(), () -> random.randomValues().nextCharValue(), () -> random.randomValues().nextTextValue(), () -> random.randomValues().nextAlphaNumericTextValue(), () -> random.randomValues().nextBooleanValue(), () -> random.randomValues().nextNumberValue()));
        if (includeIncomparable) {
            generators.addAll(Arrays.asList(() -> random.randomValues().nextPointValue(), () -> random.randomValues().nextGeographicPoint(), () -> random.randomValues().nextGeographic3DPoint(), () -> random.randomValues().nextCartesianPoint(), () -> random.randomValues().nextCartesian3DPoint()));
        }
        return generators;
    }

    private static List<ValueGenerator> arrayValueGenerators(boolean includeIncomparable) {
        ArrayList<ValueGenerator> generators = new ArrayList<ValueGenerator>(Arrays.asList(() -> random.randomValues().nextDateTimeArray(), () -> random.randomValues().nextLocalDateTimeArray(), () -> random.randomValues().nextDateArray(), () -> random.randomValues().nextTimeArray(), () -> random.randomValues().nextLocalTimeArray(), () -> random.randomValues().nextDurationArray(), () -> random.randomValues().nextDurationArray(), () -> random.randomValues().nextCharArray(), () -> random.randomValues().nextTextArray(), () -> random.randomValues().nextAlphaNumericTextArray(), () -> random.randomValues().nextBooleanArray(), () -> random.randomValues().nextByteArray(), () -> random.randomValues().nextShortArray(), () -> random.randomValues().nextIntArray(), () -> random.randomValues().nextLongArray(), () -> random.randomValues().nextFloatArray(), () -> random.randomValues().nextDoubleArray()));
        if (includeIncomparable) {
            generators.addAll(Arrays.asList(() -> random.randomValues().nextPointArray(), () -> random.randomValues().nextGeographicPointArray(), () -> random.randomValues().nextGeographic3DPointArray(), () -> random.randomValues().nextCartesianPointArray(), () -> random.randomValues().nextCartesian3DPointArray()));
        }
        return generators;
    }

    private static Stream<ValueGenerator> validValueGenerators() {
        return Stream.of(GenericKeyStateTest.listValueGenerators(true));
    }

    private static Stream<ValueGenerator> singleValueGeneratorsStream() {
        return GenericKeyStateTest.singleValueGenerators(true).stream();
    }

    private static Stream<ValueGenerator> arrayValueGeneratorsStream() {
        return GenericKeyStateTest.arrayValueGenerators(true).stream();
    }

    private static Stream<ValueGenerator> validComparableValueGenerators() {
        return Stream.of(GenericKeyStateTest.listValueGenerators(false));
    }

    private int getStringSize(Value value) {
        if (!(value instanceof TextValue)) {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.TEXT + ", was " + value.getClass());
        }
        int expectedSizeOfData = 3 + ((TextValue)value).stringValue().getBytes(StandardCharsets.UTF_8).length;
        return expectedSizeOfData;
    }

    private int getGeometrySize(Value value) {
        int expectedSizeOfData;
        if (!(value instanceof PointValue)) {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.GEOMETRY + ", was " + value.getClass());
        }
        int dimensions = ((PointValue)value).coordinate().length;
        if (dimensions == 2) {
            expectedSizeOfData = 28;
        } else if (dimensions == 3) {
            expectedSizeOfData = 36;
        } else {
            throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
        }
        return expectedSizeOfData;
    }

    private int getNumberSize(Value value) {
        int expectedSizeOfData;
        if (value instanceof ByteValue) {
            expectedSizeOfData = 3;
        } else if (value instanceof ShortValue) {
            expectedSizeOfData = 4;
        } else if (value instanceof IntValue) {
            expectedSizeOfData = 6;
        } else if (value instanceof LongValue) {
            expectedSizeOfData = 10;
        } else if (value instanceof FloatValue) {
            expectedSizeOfData = 6;
        } else if (value instanceof DoubleValue) {
            expectedSizeOfData = 10;
        } else {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.NUMBER + ", was " + value.getClass());
        }
        return expectedSizeOfData;
    }

    private int getNumberArrayElementSize(Value value) {
        int arrayElementSize;
        if (value instanceof ByteArray) {
            arrayElementSize = 1;
        } else if (value instanceof ShortArray) {
            arrayElementSize = 2;
        } else if (value instanceof IntArray) {
            arrayElementSize = 4;
        } else if (value instanceof LongArray) {
            arrayElementSize = 8;
        } else if (value instanceof FloatArray) {
            arrayElementSize = 4;
        } else if (value instanceof DoubleArray) {
            arrayElementSize = 8;
        } else {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.NUMBER_ARRAY + ", was " + value.getClass());
        }
        return arrayElementSize;
    }

    private void assertTextArraySize(Value value, int actualSizeOfData, int normalArrayOverhead, String typeName) {
        int sumOfStrings;
        if (value instanceof TextArray) {
            sumOfStrings = 0;
            TextArray stringArray = (TextArray)value;
            for (int i = 0; i < stringArray.length(); ++i) {
                String string = stringArray.stringValue(i);
                sumOfStrings += 2 + string.getBytes(StandardCharsets.UTF_8).length;
            }
        } else {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.TEXT_ARRAY + ", was " + value.getClass());
        }
        int totalTextArraySize = normalArrayOverhead + sumOfStrings;
        GenericKeyStateTest.assertKeySize(totalTextArraySize, actualSizeOfData, typeName);
    }

    private int getGeometryArrayElementSize(Value value, int arrayLength) {
        int arrayElementSize;
        if (arrayLength < 1) {
            return 0;
        }
        if (!(value instanceof PointArray)) {
            throw new RuntimeException("Unexpected class for value in value group " + ValueGroup.GEOMETRY_ARRAY + ", was " + value.getClass());
        }
        int dimensions = ((PointArray)value).pointValue(0).coordinate().length;
        if (dimensions == 2) {
            arrayElementSize = 24;
        } else if (dimensions == 3) {
            arrayElementSize = 32;
        } else {
            throw new RuntimeException("Did not expect spatial value with " + dimensions + " dimensions.");
        }
        return arrayElementSize;
    }

    private GenericKey genericKeyStateWithSomePreviousState(ValueGenerator valueGenerator) {
        GenericKey to = this.newKeyState();
        if (random.nextBoolean()) {
            NativeIndexKey.Inclusion inclusion = (NativeIndexKey.Inclusion)random.among((Object[])NativeIndexKey.Inclusion.values());
            Value value = valueGenerator.next();
            to.writeValue(value, inclusion);
        }
        return to;
    }

    private PageCursor newPageCursor() {
        return ByteArrayPageCursor.wrap((int)8192);
    }

    private GenericKey newKeyState() {
        return new GenericKey(this.noSpecificIndexSettings);
    }

    private Value pickOther(Value value1, Value value2, Value currentValue) {
        return currentValue == value1 ? value2 : value1;
    }

    private Value uniqueSecondValue(ValueGenerator valueGenerator, Value firstValue) {
        Value secondValue;
        while (Values.COMPARATOR.compare(firstValue, secondValue = valueGenerator.next()) == 0) {
        }
        return secondValue;
    }

    private GenericLayout newLayout(int numberOfSlots) {
        return new GenericLayout(numberOfSlots, this.noSpecificIndexSettings);
    }

    @FunctionalInterface
    private static interface ValueGenerator {
        public Value next();
    }
}

