/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeBuilder;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.ValueCreatorUtil;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.rule.RandomRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.values.storable.ValueGroup;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
public abstract class NativeIndexTestUtil<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue> {
    static final long NON_EXISTENT_ENTITY_ID = 1000000000L;
    @Inject
    protected DefaultFileSystemAbstraction fs;
    @Inject
    private TestDirectory directory;
    @Inject
    protected PageCache pageCache;
    @Inject
    protected RandomRule random;
    IndexDescriptor indexDescriptor;
    ValueCreatorUtil<KEY, VALUE> valueCreatorUtil;
    IndexLayout<KEY, VALUE> layout;
    private IndexDirectoryStructure indexDirectoryStructure;
    IndexFiles indexFiles;
    IndexProvider.Monitor monitor = IndexProvider.Monitor.EMPTY;

    @BeforeEach
    public void setup() throws IOException {
        this.valueCreatorUtil = this.createValueCreatorUtil();
        this.indexDescriptor = this.valueCreatorUtil.indexDescriptor();
        this.layout = this.createLayout();
        this.indexDirectoryStructure = IndexDirectoryStructure.directoriesByProvider((File)this.directory.directory("root", new String[0])).forProvider(this.indexDescriptor.getIndexProvider());
        this.indexFiles = new IndexFiles.Directory((FileSystemAbstraction)this.fs, this.indexDirectoryStructure, this.indexDescriptor.getId());
        this.fs.mkdirs(this.indexFiles.getStoreFile().getParentFile());
    }

    abstract ValueCreatorUtil<KEY, VALUE> createValueCreatorUtil();

    abstract IndexLayout<KEY, VALUE> createLayout();

    private void copyValue(VALUE value, VALUE intoValue) {
        this.valueCreatorUtil.copyValue(value, intoValue);
    }

    void verifyUpdates(IndexEntryUpdate<IndexDescriptor>[] updates) throws IOException {
        Pair<KEY, VALUE>[] expectedHits = this.convertToHits(updates, (Layout<KEY, VALUE>)this.layout);
        ArrayList<Pair<KEY, VALUE>> actualHits = new ArrayList<Pair<KEY, VALUE>>();
        try (GBPTree<KEY, VALUE> tree = this.getTree();
             Seeker<KEY, VALUE> scan = this.scan(tree);){
            while (scan.next()) {
                actualHits.add(this.deepCopy(scan));
            }
        }
        Comparator hitComparator = (h1, h2) -> {
            int keyCompare = this.layout.compare((NativeIndexKey)h1.getKey(), (NativeIndexKey)h2.getKey());
            if (keyCompare == 0) {
                return this.valueCreatorUtil.compareIndexedPropertyValue((NativeIndexKey)h1.getKey(), (NativeIndexKey)h2.getKey());
            }
            return keyCompare;
        };
        this.assertSameHits(expectedHits, actualHits.toArray(new Pair[0]), hitComparator);
    }

    GBPTree<KEY, VALUE> getTree() {
        return new GBPTreeBuilder(this.pageCache, this.indexFiles.getStoreFile(), this.layout).build();
    }

    private Seeker<KEY, VALUE> scan(GBPTree<KEY, VALUE> tree) throws IOException {
        NativeIndexKey lowest = (NativeIndexKey)this.layout.newKey();
        lowest.initialize(Long.MIN_VALUE);
        lowest.initValueAsLowest(0, ValueGroup.UNKNOWN);
        NativeIndexKey highest = (NativeIndexKey)this.layout.newKey();
        highest.initialize(Long.MAX_VALUE);
        highest.initValueAsHighest(0, ValueGroup.UNKNOWN);
        return tree.seek((Object)lowest, (Object)highest);
    }

    private void assertSameHits(Pair<KEY, VALUE>[] expectedHits, Pair<KEY, VALUE>[] actualHits, Comparator<Pair<KEY, VALUE>> comparator) {
        Arrays.sort(expectedHits, comparator);
        Arrays.sort(actualHits, comparator);
        Assertions.assertEquals((int)expectedHits.length, (int)actualHits.length, (String)String.format("Array length differ%nExpected:%d, Actual:%d", expectedHits.length, actualHits.length));
        for (int i = 0; i < expectedHits.length; ++i) {
            Pair<KEY, VALUE> expected = expectedHits[i];
            Pair<KEY, VALUE> actual = actualHits[i];
            Assertions.assertEquals((int)0, (int)comparator.compare(expected, actual), (String)("Hits differ on item number " + i + ". Expected " + expected + " but was " + actual));
        }
    }

    private Pair<KEY, VALUE> deepCopy(Seeker<KEY, VALUE> from) {
        NativeIndexKey intoKey = (NativeIndexKey)this.layout.newKey();
        NativeIndexValue intoValue = this.layout.newValue();
        this.layout.copyKey((Object)((NativeIndexKey)from.key()), (Object)intoKey);
        this.copyValue((NativeIndexValue)from.value(), intoValue);
        return Pair.of((Object)intoKey, (Object)intoValue);
    }

    private Pair<KEY, VALUE>[] convertToHits(IndexEntryUpdate<IndexDescriptor>[] updates, Layout<KEY, VALUE> layout) {
        ArrayList<Pair> hits = new ArrayList<Pair>(updates.length);
        for (IndexEntryUpdate<IndexDescriptor> u : updates) {
            NativeIndexKey key = (NativeIndexKey)layout.newKey();
            key.initialize(u.getEntityId());
            for (int i = 0; i < u.values().length; ++i) {
                key.initFromValue(i, u.values()[i], NativeIndexKey.Inclusion.NEUTRAL);
            }
            NativeIndexValue value = (NativeIndexValue)layout.newValue();
            value.from(u.values());
            hits.add(Pair.of((Object)key, (Object)value));
        }
        return hits.toArray(new Pair[0]);
    }

    void assertFilePresent() {
        Assertions.assertTrue((boolean)this.fs.fileExists(this.indexFiles.getStoreFile()));
    }

    void assertFileNotPresent() {
        Assertions.assertFalse((boolean)this.fs.fileExists(this.indexFiles.getStoreFile()));
    }

    void setSeed(long seed) {
        this.random.setSeed(seed);
        this.random.reset();
    }
}

