/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.IndexCursor;

class IndexCursorTest {
    IndexCursorTest() {
    }

    @Test
    void shouldClosePreviousBeforeReinitialize() {
        StubIndexCursor cursor = new StubIndexCursor();
        StubProgressor progressor = new StubProgressor();
        cursor.initialize(progressor);
        Assertions.assertFalse((boolean)progressor.isClosed, (String)"open before re-initialize");
        StubProgressor otherProgressor = new StubProgressor();
        cursor.initialize(otherProgressor);
        Assertions.assertTrue((boolean)progressor.isClosed, (String)"closed after re-initialize");
        Assertions.assertFalse((boolean)otherProgressor.isClosed, (String)"new still open");
    }

    private static class StubProgressor
    implements IndexProgressor {
        boolean isClosed = false;

        StubProgressor() {
        }

        public boolean next() {
            return false;
        }

        public void close() {
            this.isClosed = true;
        }
    }

    private static class StubIndexCursor
    extends IndexCursor<StubProgressor> {
        private StubIndexCursor() {
        }

        public boolean next() {
            return false;
        }

        public void closeInternal() {
        }

        public boolean isClosed() {
            return false;
        }
    }
}

