/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.helpers.StubCursorFactory;
import org.neo4j.internal.kernel.api.helpers.StubNodeCursor;
import org.neo4j.internal.kernel.api.helpers.StubRead;
import org.neo4j.internal.kernel.api.helpers.StubRelationshipCursor;
import org.neo4j.internal.kernel.api.helpers.TestRelationshipChain;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.newapi.TwoPhaseNodeForRelationshipLocking;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

class TwoPhaseNodeForRelationshipLockingTest {
    private static final long nodeId = 42L;
    private static final int TYPE = 77;
    private final KernelTransaction transaction = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final Locks.Client locks = (Locks.Client)Mockito.mock(Locks.Client.class);

    TwoPhaseNodeForRelationshipLockingTest() {
    }

    @Test
    void shouldLockNodesInOrderAndConsumeTheRelationships() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking((ThrowingConsumer)collector, this.locks, LockTracer.NONE);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.transaction, false, new TestRelationshipChain(42L).outgoing(21L, 43L, 0).incoming(22L, 40L, 77).outgoing(23L, 41L, 77).outgoing(2L, 3L, 77).incoming(3L, 49L, 77).outgoing(50L, 41L, 77));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.transaction, (NodeCursor)new StubNodeCursor(false).withNode(42L));
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L, 40L, 41L, 42L, 43L, 49L});
        Assertions.assertEquals((Object)Iterators.set((Object[])new Long[]{21L, 22L, 23L, 2L, 3L, 50L}), collector.set);
    }

    @Test
    void shouldLockNodesInOrderAndConsumeTheRelationshipsAndRetryIfTheNewRelationshipsAreCreated() throws Throwable {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking((ThrowingConsumer)collector, this.locks, LockTracer.NONE);
        TestRelationshipChain chain = new TestRelationshipChain(42L).outgoing(21L, 43L, 77).incoming(22L, 40L, 77).outgoing(23L, 41L, 77);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.transaction, true, chain);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.locks});
        locking.lockAllNodesAndConsumeRelationships(42L, this.transaction, (NodeCursor)new StubNodeCursor(false).withNode(42L));
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{40L, 41L, 42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{40L, 41L, 42L});
        ((Locks.Client)inOrder.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{40L, 41L, 42L, 43L});
        Assertions.assertEquals((Object)Iterators.set((Object[])new Long[]{21L, 22L, 23L}), collector.set);
    }

    @Test
    void lockNodeWithoutRelationships() throws Exception {
        Collector collector = new Collector();
        TwoPhaseNodeForRelationshipLocking locking = new TwoPhaseNodeForRelationshipLocking((ThrowingConsumer)collector, this.locks, LockTracer.NONE);
        TwoPhaseNodeForRelationshipLockingTest.returnRelationships(this.transaction, false, new TestRelationshipChain(42L));
        locking.lockAllNodesAndConsumeRelationships(42L, this.transaction, (NodeCursor)new StubNodeCursor(false).withNode(42L));
        ((Locks.Client)Mockito.verify((Object)this.locks)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.locks});
    }

    static void returnRelationships(KernelTransaction transaction, boolean skipFirst, TestRelationshipChain relIds) throws EntityNotFoundException {
        StubRead read = new StubRead();
        Mockito.when((Object)transaction.dataRead()).thenReturn((Object)read);
        StubCursorFactory cursorFactory = new StubCursorFactory(true);
        if (skipFirst) {
            cursorFactory.withRelationshipTraversalCursors(new RelationshipTraversalCursor[]{new StubRelationshipCursor(relIds.tail()), new StubRelationshipCursor(relIds)});
        } else {
            cursorFactory.withRelationshipTraversalCursors(new RelationshipTraversalCursor[]{new StubRelationshipCursor(relIds)});
        }
        Mockito.when((Object)transaction.cursors()).thenReturn((Object)cursorFactory);
    }

    private static class Collector
    implements ThrowingConsumer<Long, KernelException> {
        public final Set<Long> set = new HashSet<Long>();

        private Collector() {
        }

        public void accept(Long input) throws KernelException {
            Assertions.assertNotNull((Object)input);
            this.set.add(input);
        }
    }
}

