/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThresholdTestSupport;

class CheckPointThresholdTest
extends CheckPointThresholdTestSupport {
    CheckPointThresholdTest() {
    }

    @Test
    void mustCreateThresholdThatTriggersAfterTransactionCount() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx - 1), this.notTriggered));
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded((long)this.intervalTx.intValue(), this.notTriggered));
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded((long)(this.intervalTx + 1), this.triggered));
        this.verifyTriggered("every 100000 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustCreateThresholdThatTriggersAfterTime() {
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(1L);
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, this.notTriggered));
        this.clock.forward(this.intervalTime.toMillis(), TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, this.triggered));
        this.verifyTriggered("every 15 minutes threshold");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerBeforeTimeWithTooFewCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(50L, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
    }

    @Test
    void mustTriggerWhenTimeThresholdIsReachedAndThereAreCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(42L, this.triggered));
        this.verifyTriggered("every 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustTriggerWhenWeirdTimeThresholdIsReachedAndThereAreCommittedTransactions() {
        this.withIntervalTime("1100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(2199L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(42L, this.triggered));
        this.verifyTriggered("every 1 seconds 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerWhenTimeThresholdIsReachedAndThereAreNoCommittedTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(42L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerPastTimeThresholdSinceLastCheckpointWithNoNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(42L, this.notTriggered));
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustTriggerPastTimeThresholdSinceLastCheckpointWithNewTransactions() {
        this.withIntervalTime("100ms");
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        this.clock.forward(199L, TimeUnit.MILLISECONDS);
        threshold.checkPointHappened(42L);
        this.clock.forward(100L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(43L, this.triggered));
        this.verifyTriggered("every 100 milliseconds");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerOnTransactionCountWhenThereAreNoNewTransactions() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(2L, this.notTriggered));
    }

    @Test
    void mustNotTriggerOnTransactionCountWhenCountIsBellowThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(3L, this.notTriggered));
    }

    @Test
    void mustTriggerOnTransactionCountWhenCountIsAtThreshold() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(4L, this.triggered));
        this.verifyTriggered("every 2 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void mustNotTriggerOnTransactionCountAtThresholdIfCheckPointAlreadyHappened() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(4L, this.notTriggered));
    }

    @Test
    void mustNotTriggerWhenTransactionCountIsWithinThresholdSinceLastTrigger() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assertions.assertFalse((boolean)threshold.isCheckPointingNeeded(5L, this.notTriggered));
    }

    @Test
    void mustTriggerOnTransactionCountWhenCountIsAtThresholdSinceLastCheckPoint() {
        this.withIntervalTx(2);
        CheckPointThreshold threshold = this.createThreshold();
        threshold.initialize(2L);
        threshold.checkPointHappened(4L);
        Assertions.assertTrue((boolean)threshold.isCheckPointingNeeded(6L, this.triggered));
        this.verifyTriggered("2 transactions");
        this.verifyNoMoreTriggers();
    }

    @Test
    void timeBasedThresholdMustSuggestSchedulingFrequency() {
        MatcherAssert.assertThat((Object)this.createThreshold().checkFrequencyMillis(), (Matcher)Matchers.is((Object)CheckPointThreshold.DEFAULT_CHECKING_FREQUENCY_MILLIS));
        this.withIntervalTime("100ms");
        MatcherAssert.assertThat((Object)this.createThreshold().checkFrequencyMillis(), (Matcher)Matchers.is((Object)100L));
    }
}

