/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FlushableChecksumChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.fs.WritableChecksumChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.api.TestCommand;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.GivenTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.reverse.ReverseTransactionCursorLoggingMonitor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedSingleFileTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.LifeExtension;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.rule.RandomRule;

@Neo4jLayoutExtension
@ExtendWith(value={RandomExtension.class, LifeExtension.class})
class ReversedSingleFileTransactionCursorTest {
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private DatabaseLayout databaseLayout;
    @Inject
    private LifeSupport life;
    @Inject
    private RandomRule random;
    private long txId = 1L;
    private final LogProvider logProvider = new AssertableLogProvider(true);
    private final ReverseTransactionCursorLoggingMonitor monitor = new ReverseTransactionCursorLoggingMonitor(this.logProvider.getLog(ReversedSingleFileTransactionCursor.class));
    private LogFile logFile;
    private LogFiles logFiles;

    ReversedSingleFileTransactionCursorTest() {
    }

    @BeforeEach
    void setUp() throws IOException {
        SimpleLogVersionRepository logVersionRepository = new SimpleLogVersionRepository();
        SimpleTransactionIdStore transactionIdStore = new SimpleTransactionIdStore();
        this.logFiles = LogFilesBuilder.builder((DatabaseLayout)this.databaseLayout, (FileSystemAbstraction)this.fs).withLogVersionRepository((LogVersionRepository)logVersionRepository).withTransactionIdStore((TransactionIdStore)transactionIdStore).withLogEntryReader(TestLogEntryReader.logEntryReader()).withStoreId(StoreId.UNKNOWN).build();
        this.life.add((Lifecycle)this.logFiles);
        this.logFile = this.logFiles.getLogFile();
    }

    @Test
    void shouldHandleVerySmallTransactions() throws Exception {
        this.writeTransactions(10, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    void shouldHandleManyVerySmallTransactions() throws Exception {
        this.writeTransactions(20000, 1, 1);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    void shouldHandleLargeTransactions() throws Exception {
        this.writeTransactions(10, 1000, 1000);
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        this.assertTransactionRange(readTransactions, this.txId, 1L);
    }

    @Test
    void shouldHandleEmptyLog() throws Exception {
        CommittedTransactionRepresentation[] readTransactions = this.readAllFromReversedCursor();
        Assertions.assertEquals((int)0, (int)readTransactions.length);
    }

    @Test
    void shouldDetectAndPreventChannelReadingMultipleLogVersions() throws Exception {
        this.writeTransactions(1, 1, 1);
        this.logFile.rotate();
        this.writeTransactions(1, 1, 1);
        try (ReadAheadLogChannel channel = (ReadAheadLogChannel)this.logFile.getReader(this.logFiles.extractHeader(0L).getStartPosition());){
            new ReversedSingleFileTransactionCursor(channel, TestLogEntryReader.logEntryReader(), false, (ReversedTransactionCursorMonitor)this.monitor);
            Assertions.fail((String)"Should've failed");
        }
        catch (IllegalArgumentException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"multiple log versions"));
        }
    }

    @Test
    void readCorruptedTransactionLog() throws IOException {
        int readableTransactions = 10;
        this.writeTransactions(readableTransactions, 1, 1);
        this.appendCorruptedTransaction();
        this.writeTransactions(readableTransactions, 1, 1);
        CommittedTransactionRepresentation[] committedTransactionRepresentations = this.readAllFromReversedCursor();
        this.assertTransactionRange(committedTransactionRepresentations, (long)readableTransactions + 1L, 1L);
    }

    @Test
    void failToReadCorruptedTransactionLogWhenConfigured() throws IOException {
        int readableTransactions = 10;
        this.writeTransactions(readableTransactions, 1, 1);
        this.appendCorruptedTransaction();
        this.writeTransactions(readableTransactions, 1, 1);
        Assertions.assertThrows(IOException.class, this::readAllFromReversedCursorFailOnCorrupted);
    }

    private CommittedTransactionRepresentation[] readAllFromReversedCursor() throws IOException {
        try (ReversedSingleFileTransactionCursor cursor = this.txCursor(false);){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private CommittedTransactionRepresentation[] readAllFromReversedCursorFailOnCorrupted() throws IOException {
        try (ReversedSingleFileTransactionCursor cursor = this.txCursor(true);){
            CommittedTransactionRepresentation[] committedTransactionRepresentationArray = GivenTransactionCursor.exhaust((TransactionCursor)cursor);
            return committedTransactionRepresentationArray;
        }
    }

    private void assertTransactionRange(CommittedTransactionRepresentation[] readTransactions, long highTxId, long lowTxId) {
        long expectedTxId = highTxId;
        for (CommittedTransactionRepresentation tx : readTransactions) {
            Assertions.assertEquals((long)expectedTxId, (long)tx.getCommitEntry().getTxId());
            --expectedTxId;
        }
        Assertions.assertEquals((long)expectedTxId, (long)lowTxId);
    }

    private ReversedSingleFileTransactionCursor txCursor(boolean failOnCorruptedLogFiles) throws IOException {
        ReadAheadLogChannel fileReader = (ReadAheadLogChannel)this.logFile.getReader(this.logFiles.extractHeader(0L).getStartPosition(), LogVersionBridge.NO_MORE_CHANNELS);
        try {
            return new ReversedSingleFileTransactionCursor(fileReader, TestLogEntryReader.logEntryReader(), failOnCorruptedLogFiles, (ReversedTransactionCursorMonitor)this.monitor);
        }
        catch (Exception e) {
            fileReader.close();
            throw e;
        }
    }

    private void writeTransactions(int transactionCount, int minTransactionSize, int maxTransactionSize) throws IOException {
        FlushablePositionAwareChecksumChannel channel = this.logFile.getWriter();
        TransactionLogWriter writer = new TransactionLogWriter(new LogEntryWriter((WritableChecksumChannel)channel));
        int previousChecksum = -559063315;
        for (int i = 0; i < transactionCount; ++i) {
            previousChecksum = writer.append(this.tx(this.random.intBetween(minTransactionSize, maxTransactionSize)), ++this.txId, previousChecksum);
        }
        channel.prepareForFlush().flush();
    }

    private void appendCorruptedTransaction() throws IOException {
        FlushablePositionAwareChecksumChannel channel = this.logFile.getWriter();
        TransactionLogWriter writer = new TransactionLogWriter((LogEntryWriter)new CorruptedLogEntryWriter((FlushableChecksumChannel)channel));
        writer.append(this.tx(this.random.intBetween(100, 1000)), ++this.txId, -559063315);
    }

    private TransactionRepresentation tx(int size) {
        ArrayList<TestCommand> commands = new ArrayList<TestCommand>();
        for (int i = 0; i < size; ++i) {
            commands.add(new TestCommand());
        }
        PhysicalTransactionRepresentation tx = new PhysicalTransactionRepresentation(commands);
        tx.setHeader(new byte[0], 0L, 0L, 0L, 0);
        return tx;
    }

    private static class CorruptedLogEntryWriter
    extends LogEntryWriter {
        CorruptedLogEntryWriter(FlushableChecksumChannel channel) {
            super((WritableChecksumChannel)channel);
        }

        public void writeStartEntry(long timeWritten, long latestCommittedTxWhenStarted, int previousChecksum, byte[] additionalHeaderData) throws IOException {
            CorruptedLogEntryWriter.writeLogEntryHeader((byte)1, (WritableChannel)this.channel);
            for (int i = 0; i < 100; ++i) {
                this.channel.put((byte)-1);
            }
        }
    }
}

