/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.function.Suppliers;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.TestLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Runner;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;

@Neo4jLayoutExtension
public class TransactionAppenderStressTest {
    @Inject
    private DatabaseLayout databaseLayout;

    @Test
    void concurrentTransactionAppendingTest() throws Exception {
        int threads = 10;
        Callable<Long> runner = new Builder().with(Suppliers.untilTimeExpired((long)10L, (TimeUnit)TimeUnit.SECONDS)).withWorkingDirectory(this.databaseLayout).withNumThreads(threads).build();
        long appendedTxs = runner.call();
        Assertions.assertEquals((long)new TransactionIdChecker(this.databaseLayout.getTransactionLogsDirectory()).parseAllTxLogs(), (long)appendedTxs);
    }

    public static class TransactionIdChecker {
        private final File workingDirectory;

        public TransactionIdChecker(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public long parseAllTxLogs() throws IOException {
            long txId = 1L;
            try (DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
                 ReadableLogChannel channel = this.openLogFile((FileSystemAbstraction)fs, 0);){
                LogEntryReader reader = TestLogEntryReader.logEntryReader();
                LogEntry logEntry = reader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
                while (logEntry != null) {
                    if (logEntry instanceof LogEntryCommit) {
                        txId = ((LogEntryCommit)logEntry).getTxId();
                    }
                    logEntry = reader.readLogEntry((ReadableClosablePositionAwareChecksumChannel)channel);
                }
            }
            return txId;
        }

        private ReadableLogChannel openLogFile(FileSystemAbstraction fs, int version) throws IOException {
            LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.workingDirectory, (FileSystemAbstraction)fs).withLogEntryReader(TestLogEntryReader.logEntryReader()).build();
            PhysicalLogVersionedStoreChannel channel = logFiles.openForVersion((long)version);
            return new ReadAheadLogChannel((LogVersionedStoreChannel)channel, (LogVersionBridge)new ReaderLogVersionBridge(logFiles));
        }
    }

    public static class Builder {
        private BooleanSupplier condition;
        private DatabaseLayout databaseLayout;
        private int threads;

        public Builder with(BooleanSupplier condition) {
            this.condition = condition;
            return this;
        }

        public Builder withWorkingDirectory(DatabaseLayout databaseLayout) {
            this.databaseLayout = databaseLayout;
            return this;
        }

        public Builder withNumThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public Callable<Long> build() {
            return new Runner(this.databaseLayout, this.condition, this.threads);
        }
    }
}

