/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.util.collection.CachingOffHeapBlockAllocator;
import org.neo4j.kernel.impl.util.collection.OffHeapBlockAllocator;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;

class CachingOffHeapBlockAllocatorTest {
    private static final int CACHE_SIZE = 4;
    private static final int MAX_CACHEABLE_BLOCK_SIZE = 128;
    private final MemoryAllocationTracker memoryTracker = new LocalMemoryTracker();
    private final CachingOffHeapBlockAllocator allocator = (CachingOffHeapBlockAllocator)Mockito.spy((Object)new CachingOffHeapBlockAllocator(128L, 4));

    CachingOffHeapBlockAllocatorTest() {
    }

    @AfterEach
    void afterEach() {
        this.allocator.release();
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory(), (String)"Native memory is leaking");
    }

    @Test
    void allocateAfterRelease() {
        this.allocator.release();
        Assertions.assertThrows(IllegalStateException.class, () -> this.allocator.allocate(128L, this.memoryTracker));
    }

    @Test
    void freeAfterRelease() {
        OffHeapBlockAllocator.MemoryBlock block = this.allocator.allocate(128L, this.memoryTracker);
        this.allocator.release();
        this.allocator.free(block, this.memoryTracker);
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator)).doFree((OffHeapBlockAllocator.MemoryBlock)ArgumentMatchers.eq((Object)block), (MemoryAllocationTracker)ArgumentMatchers.any());
    }

    @Test
    void allocateAndFree() {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(128L, this.memoryTracker);
        Assertions.assertEquals((long)block1.size, (long)128L);
        Assertions.assertEquals((long)135L, (long)block1.unalignedSize);
        Assertions.assertEquals((long)block1.unalignedSize, (long)this.memoryTracker.usedDirectMemory());
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(256L, this.memoryTracker);
        Assertions.assertEquals((long)block2.size, (long)256L);
        Assertions.assertEquals((long)263L, (long)block2.unalignedSize);
        Assertions.assertEquals((long)(block1.unalignedSize + block2.unalignedSize), (long)this.memoryTracker.usedDirectMemory());
        this.allocator.free(block1, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
    }

    @ParameterizedTest
    @ValueSource(longs={10L, 100L, 256L})
    void allocateNonCacheableSize(long bytes) {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block1, this.memoryTracker);
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator, (VerificationMode)Mockito.times((int)2))).allocateNew(ArgumentMatchers.eq((long)bytes), (MemoryAllocationTracker)ArgumentMatchers.any());
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator)).doFree((OffHeapBlockAllocator.MemoryBlock)ArgumentMatchers.eq((Object)block1), (MemoryAllocationTracker)ArgumentMatchers.any());
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator)).doFree((OffHeapBlockAllocator.MemoryBlock)ArgumentMatchers.eq((Object)block2), (MemoryAllocationTracker)ArgumentMatchers.any());
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
    }

    @ParameterizedTest
    @ValueSource(longs={8L, 64L, 128L})
    void allocateCacheableSize(long bytes) {
        OffHeapBlockAllocator.MemoryBlock block1 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block1, this.memoryTracker);
        OffHeapBlockAllocator.MemoryBlock block2 = this.allocator.allocate(bytes, this.memoryTracker);
        this.allocator.free(block2, this.memoryTracker);
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator)).allocateNew(ArgumentMatchers.eq((long)bytes), (MemoryAllocationTracker)ArgumentMatchers.any());
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator, (VerificationMode)Mockito.never())).doFree((OffHeapBlockAllocator.MemoryBlock)ArgumentMatchers.any(), (MemoryAllocationTracker)ArgumentMatchers.any());
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
    }

    @Test
    void cacheCapacityPerBlockSize() {
        int EXTRA = 3;
        ArrayList<OffHeapBlockAllocator.MemoryBlock> blocks64 = new ArrayList<OffHeapBlockAllocator.MemoryBlock>();
        ArrayList<OffHeapBlockAllocator.MemoryBlock> blocks128 = new ArrayList<OffHeapBlockAllocator.MemoryBlock>();
        for (int i = 0; i < 7; ++i) {
            blocks64.add(this.allocator.allocate(64L, this.memoryTracker));
            blocks128.add(this.allocator.allocate(128L, this.memoryTracker));
        }
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator, (VerificationMode)Mockito.times((int)7))).allocateNew(ArgumentMatchers.eq((long)64L), (MemoryAllocationTracker)ArgumentMatchers.any());
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator, (VerificationMode)Mockito.times((int)7))).allocateNew(ArgumentMatchers.eq((long)128L), (MemoryAllocationTracker)ArgumentMatchers.any());
        Assertions.assertEquals((long)1442L, (long)this.memoryTracker.usedDirectMemory());
        blocks64.forEach(it -> this.allocator.free(it, this.memoryTracker));
        Assertions.assertEquals((long)945L, (long)this.memoryTracker.usedDirectMemory());
        blocks128.forEach(it -> this.allocator.free(it, this.memoryTracker));
        Assertions.assertEquals((long)0L, (long)this.memoryTracker.usedDirectMemory());
        ((CachingOffHeapBlockAllocator)Mockito.verify((Object)this.allocator, (VerificationMode)Mockito.times((int)6))).doFree((OffHeapBlockAllocator.MemoryBlock)ArgumentMatchers.any(), (MemoryAllocationTracker)ArgumentMatchers.any());
    }
}

