/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.kernel.impl.util.diffsets.DiffApplyingPrimitiveLongIterator;

class DiffApplyingPrimitiveLongIteratorTest {
    DiffApplyingPrimitiveLongIteratorTest() {
    }

    @Test
    void iterateOnlyOverAddedElementsWhenSourceIsEmpty() {
        ImmutableEmptyLongIterator emptySource = ImmutableEmptyLongIterator.INSTANCE;
        LongHashSet added = LongHashSet.newSetWith((long[])new long[]{1L, 2L});
        LongHashSet removed = LongHashSet.newSetWith((long[])new long[]{3L});
        LongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((LongIterator)emptySource, (LongSet)added, (LongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((LongIterator)iterator);
        MatcherAssert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 2L}));
    }

    @Test
    void appendSourceElementsDuringIteration() {
        LongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{4L, 5L});
        LongHashSet added = LongHashSet.newSetWith((long[])new long[]{1L, 2L});
        LongHashSet removed = LongHashSet.newSetWith((long[])new long[]{3L});
        LongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((LongIterator)source, (LongSet)added, (LongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((LongIterator)iterator);
        MatcherAssert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 2L, 4L, 5L}));
    }

    @Test
    void doNotIterateTwiceOverSameElementsWhenItsPartOfSourceAndAdded() {
        LongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{4L, 5L});
        LongHashSet added = LongHashSet.newSetWith((long[])new long[]{1L, 4L});
        LongHashSet removed = LongHashSet.newSetWith((long[])new long[]{3L});
        LongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((LongIterator)source, (LongSet)added, (LongSet)removed);
        Long[] values = ArrayUtils.toObject((long[])PrimitiveLongCollections.asArray((LongIterator)iterator));
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.arrayContainingInAnyOrder((Object[])new Long[]{1L, 4L, 5L}));
        MatcherAssert.assertThat((Object)values, (Matcher)Matchers.arrayWithSize((int)3));
    }

    @Test
    void doNotIterateOverDeletedElement() {
        LongIterator source = PrimitiveLongCollections.iterator((long[])new long[]{3L, 5L});
        LongHashSet added = LongHashSet.newSetWith((long[])new long[]{1L});
        LongHashSet removed = LongHashSet.newSetWith((long[])new long[]{3L});
        LongIterator iterator = DiffApplyingPrimitiveLongIterator.augment((LongIterator)source, (LongSet)added, (LongSet)removed);
        Set resultSet = PrimitiveLongCollections.toSet((LongIterator)iterator);
        MatcherAssert.assertThat((Object)resultSet, (Matcher)Matchers.containsInAnyOrder((Object[])new Long[]{1L, 5L}));
    }

    @Test
    void closeResource() {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        PrimitiveLongResourceIterator source = PrimitiveLongCollections.resourceIterator((LongIterator)ImmutableEmptyLongIterator.INSTANCE, (Resource)resource);
        PrimitiveLongResourceIterator iterator = DiffApplyingPrimitiveLongIterator.augment((PrimitiveLongResourceIterator)source, (LongSet)LongSets.immutable.empty(), (LongSet)LongSets.immutable.empty());
        iterator.close();
        ((Resource)Mockito.verify((Object)resource)).close();
    }
}

