/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.diffsets;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;

class MutableLongDiffSetsImplTest {
    MutableLongDiffSetsImplTest() {
    }

    @Test
    void newDiffSetIsEmpty() {
        Assertions.assertTrue((boolean)MutableLongDiffSetsImplTest.createDiffSet().isEmpty());
    }

    @Test
    void addElementsToDiffSets() {
        MutableLongDiffSetsImpl diffSets = MutableLongDiffSetsImplTest.createDiffSet();
        diffSets.add(1L);
        diffSets.add(2L);
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSets.getAdded()));
        Assertions.assertTrue((boolean)diffSets.getRemoved().isEmpty());
        Assertions.assertFalse((boolean)diffSets.isEmpty());
    }

    @Test
    void removeElementsInDiffSets() {
        MutableLongDiffSetsImpl diffSets = MutableLongDiffSetsImplTest.createDiffSet();
        diffSets.remove(1L);
        diffSets.remove(2L);
        Assertions.assertFalse((boolean)diffSets.isEmpty());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{1L, 2L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSets.getRemoved()));
    }

    @Test
    void removeAndAddElementsToDiffSets() {
        MutableLongDiffSetsImpl diffSets = MutableLongDiffSetsImplTest.createDiffSet();
        diffSets.remove(1L);
        diffSets.remove(2L);
        diffSets.add(1L);
        diffSets.add(2L);
        diffSets.add(3L);
        diffSets.remove(4L);
        Assertions.assertFalse((boolean)diffSets.isEmpty());
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{4L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSets.getRemoved()));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{3L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSets.getAdded()));
    }

    @Test
    void checkIsElementsAddedOrRemoved() {
        MutableLongDiffSetsImpl diffSet = MutableLongDiffSetsImplTest.createDiffSet();
        diffSet.add(1L);
        Assertions.assertTrue((boolean)diffSet.isAdded(1L));
        Assertions.assertFalse((boolean)diffSet.isRemoved(1L));
        diffSet.remove(2L);
        Assertions.assertFalse((boolean)diffSet.isAdded(2L));
        Assertions.assertTrue((boolean)diffSet.isRemoved(2L));
        Assertions.assertFalse((boolean)diffSet.isAdded(3L));
        Assertions.assertFalse((boolean)diffSet.isRemoved(3L));
    }

    @Test
    void addAllElements() {
        MutableLongDiffSetsImpl diffSet = MutableLongDiffSetsImplTest.createDiffSet();
        diffSet.addAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{7L, 8L}));
        diffSet.addAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{9L, 10L}));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{7L, 8L, 9L, 10L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSet.getAdded()));
    }

    @Test
    void removeAllElements() {
        MutableLongDiffSetsImpl diffSet = MutableLongDiffSetsImplTest.createDiffSet();
        diffSet.removeAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{7L, 8L}));
        diffSet.removeAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{9L, 10L}));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{7L, 8L, 9L, 10L}), (Object)PrimitiveLongCollections.toSet((LongSet)diffSet.getRemoved()));
    }

    @Test
    void addedAndRemovedElementsDelta() {
        MutableLongDiffSetsImpl diffSet = MutableLongDiffSetsImplTest.createDiffSet();
        Assertions.assertEquals((int)0, (int)diffSet.delta());
        diffSet.addAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{7L, 8L}));
        diffSet.addAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{9L, 10L}));
        Assertions.assertEquals((int)4, (int)diffSet.delta());
        diffSet.removeAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{8L, 9L}));
        Assertions.assertEquals((int)2, (int)diffSet.delta());
    }

    @Test
    void augmentDiffSetWithExternalElements() {
        MutableLongDiffSetsImpl diffSet = MutableLongDiffSetsImplTest.createDiffSet();
        diffSet.addAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{9L, 10L, 11L}));
        diffSet.removeAll((LongIterable)LongHashSet.newSetWith((long[])new long[]{1L, 2L}));
        LongIterator augmentedIterator = diffSet.augment(PrimitiveLongCollections.iterator((long[])new long[]{5L, 6L}));
        Assertions.assertEquals((Object)Iterators.asSet((Object[])new Long[]{5L, 6L, 9L, 10L, 11L}), (Object)PrimitiveLongCollections.toSet((LongIterator)augmentedIterator));
    }

    @Test
    void useCollectionsFactory() {
        LongHashSet set1 = new LongHashSet();
        LongHashSet set2 = new LongHashSet();
        CollectionsFactory collectionsFactory = (CollectionsFactory)Mockito.mock(CollectionsFactory.class);
        ((CollectionsFactory)Mockito.doReturn((Object)set1, (Object[])new Object[]{set2}).when((Object)collectionsFactory)).newLongSet();
        MutableLongDiffSetsImpl diffSets = new MutableLongDiffSetsImpl(collectionsFactory);
        diffSets.add(1L);
        diffSets.remove(2L);
        Assertions.assertSame((Object)set1, (Object)diffSets.getAdded());
        Assertions.assertSame((Object)set2, (Object)diffSets.getRemoved());
        ((CollectionsFactory)Mockito.verify((Object)collectionsFactory, (VerificationMode)Mockito.times((int)2))).newLongSet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{collectionsFactory});
    }

    private static MutableLongDiffSetsImpl createDiffSet() {
        return new MutableLongDiffSetsImpl(OnHeapCollectionsFactory.INSTANCE);
    }
}

