/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.test.BatchTransaction;

class BatchTransactionTest {
    BatchTransactionTest() {
    }

    @Test
    void shouldUseProgressListener() {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        GraphDatabaseService db = (GraphDatabaseService)Mockito.mock(GraphDatabaseService.class);
        Mockito.when((Object)db.beginTx()).thenReturn((Object)transaction);
        ProgressListener progress = (ProgressListener)Mockito.mock(ProgressListener.class);
        BatchTransaction tx = BatchTransaction.beginBatchTx(db).withIntermediarySize(10).withProgress(progress);
        tx.increment();
        tx.increment(9);
        ((GraphDatabaseService)Mockito.verify((Object)db, (VerificationMode)Mockito.times((int)2))).beginTx();
        ((Transaction)Mockito.verify((Object)transaction)).commit();
        ((ProgressListener)Mockito.verify((Object)progress)).add(1L);
        ((ProgressListener)Mockito.verify((Object)progress)).add(9L);
    }
}

