/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.string.UTF8;

public class AuthTokenUtil {
    public static boolean matches(Map<String, Object> expected, Object actualObject) {
        if (expected == null || actualObject == null) {
            return expected == actualObject;
        }
        if (!(actualObject instanceof Map)) {
            return false;
        }
        Map actual = (Map)actualObject;
        if (expected.size() != actual.size()) {
            return false;
        }
        for (Map.Entry<String, Object> expectedEntry : expected.entrySet()) {
            String key = expectedEntry.getKey();
            Object expectedValue = expectedEntry.getValue();
            Object actualValue = actual.get(key);
            if (AuthToken.containsSensitiveInformation((String)key)) {
                byte[] expectedByteArray = expectedValue instanceof byte[] ? (byte[])expectedValue : (byte[])(expectedValue != null ? UTF8.encode((String)((String)expectedValue)) : null);
                if (Arrays.equals(expectedByteArray, (byte[])actualValue)) continue;
                return false;
            }
            if (expectedValue == null || actualValue == null) {
                return expectedValue == actualValue;
            }
            if (expectedValue.equals(actualValue)) continue;
            return false;
        }
        return true;
    }

    public static void assertAuthTokenMatches(Map<String, Object> expected, Map<String, Object> actual) {
        Assertions.assertFalse((boolean)(expected == null ^ actual == null));
        Assertions.assertEquals(expected.keySet(), actual.keySet());
        expected.forEach((key, expectedValue) -> {
            Object actualValue = actual.get(key);
            if (AuthToken.containsSensitiveInformation((String)key)) {
                byte[] expectedByteArray = expectedValue != null ? UTF8.encode((String)((String)expectedValue)) : null;
                Assertions.assertTrue((boolean)Arrays.equals(expectedByteArray, (byte[])actualValue));
            } else {
                Assertions.assertEquals((Object)expectedValue, actualValue);
            }
        });
    }

    public static AuthTokenMatcher authTokenMatcher(Map<String, Object> authToken) {
        return new AuthTokenMatcher(authToken);
    }

    public static Map<String, Object> authTokenArgumentMatcher(Map<String, Object> authToken) {
        ThreadSafeMockingProgress.mockingProgress().getArgumentMatcherStorage().reportMatcher((ArgumentMatcher)new AuthTokenArgumentMatcher(authToken));
        return null;
    }

    public static class AuthTokenArgumentMatcher
    implements ArgumentMatcher<Map<String, Object>>,
    Serializable {
        private Map<String, Object> wanted;

        public AuthTokenArgumentMatcher(Map<String, Object> authToken) {
            this.wanted = authToken;
        }

        public boolean matches(Map<String, Object> actual) {
            return AuthTokenUtil.matches(this.wanted, actual);
        }

        public String toString() {
            return "authTokenArgumentMatcher(" + this.wanted + ")";
        }
    }

    public static class AuthTokenMatcher
    extends BaseMatcher<Map<String, Object>> {
        private final Map<String, Object> expectedValue;

        public AuthTokenMatcher(Map<String, Object> expectedValue) {
            this.expectedValue = expectedValue;
        }

        public boolean matches(Object o) {
            return AuthTokenUtil.matches(this.expectedValue, o);
        }

        public void describeTo(Description description) {
            description.appendValue(this.expectedValue);
        }
    }
}

