/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.DuplicatingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class DuplicatingLogTest {
    @Test
    public void shouldOutputToMultipleLogs() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log1 = logProvider.getLog("log 1");
        Log log2 = logProvider.getLog("log 2");
        DuplicatingLog log = new DuplicatingLog(new Log[]{log1, log2});
        log.info("When the going gets weird");
        logProvider.assertExactly(AssertableLogProvider.inLog("log 1").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("When the going gets weird"));
    }

    @Test
    public void shouldBulkOutputToMultipleLogs() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log1 = logProvider.getLog("log 1");
        Log log2 = logProvider.getLog("log 2");
        DuplicatingLog log = new DuplicatingLog(new Log[]{log1, log2});
        log.bulk(bulkLog -> bulkLog.info("When the going gets weird"));
        logProvider.assertExactly(AssertableLogProvider.inLog("log 1").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("When the going gets weird"));
    }

    @Test
    public void shouldRemoveLogFromDuplication() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log1 = logProvider.getLog("log 1");
        Log log2 = logProvider.getLog("log 2");
        DuplicatingLog log = new DuplicatingLog(new Log[]{log1, log2});
        log.info("When the going gets weird");
        log.remove(log1);
        log.info("The weird turn pro");
        logProvider.assertExactly(AssertableLogProvider.inLog("log 1").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("The weird turn pro"));
    }

    @Test
    public void shouldRemoveLoggersFromDuplication() {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log1 = logProvider.getLog("log 1");
        Log log2 = logProvider.getLog("log 2");
        DuplicatingLog log = new DuplicatingLog(new Log[]{log1, log2});
        Logger logger = log.infoLogger();
        logger.log("When the going gets weird");
        log.remove(log1);
        logger.log("The weird turn pro");
        logProvider.assertExactly(AssertableLogProvider.inLog("log 1").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("When the going gets weird"), AssertableLogProvider.inLog("log 2").info("The weird turn pro"));
    }
}

