/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Level;

public class FormattedLogProviderTest {
    private static final Date FIXED_DATE = new Date(467612604343L);

    @Test
    public void shouldReturnSameLoggerForSameClass() {
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)new ByteArrayOutputStream());
        FormattedLog log = (FormattedLog)logProvider.getLog(this.getClass());
        MatcherAssert.assertThat((Object)logProvider.getLog(FormattedLogProviderTest.class), (Matcher)CoreMatchers.sameInstance((Object)log));
    }

    @Test
    public void shouldReturnSameLoggerForSameContext() {
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)new ByteArrayOutputStream());
        FormattedLog log = (FormattedLog)logProvider.getLog("test context");
        MatcherAssert.assertThat((Object)logProvider.getLog("test context"), (Matcher)CoreMatchers.sameInstance((Object)log));
    }

    @Test
    public void shouldLogWithAbbreviatedClassNameAsContext() throws Exception {
        StringWriter writer = new StringWriter();
        FormattedLogProvider logProvider = FormattedLogProviderTest.newFormattedLogProvider(writer);
        FormattedLog log = (FormattedLog)logProvider.getLog(StringWriter.class);
        log.info("Terminator 2");
        MatcherAssert.assertThat((Object)writer.toString(), (Matcher)CoreMatchers.equalTo((Object)String.format("1984-10-26 04:23:24.343+0000 INFO  [j.i.StringWriter] Terminator 2%n", new Object[0])));
    }

    @Test
    public void shouldSetLevelForLogWithMatchingContext() throws Exception {
        StringWriter writer = new StringWriter();
        FormattedLogProvider logProvider = FormattedLogProviderTest.newFormattedLogProvider(writer, "java.io.StringWriter", Level.DEBUG);
        FormattedLog stringWriterLog = (FormattedLog)logProvider.getLog(StringWriter.class);
        FormattedLog otherClassLog = (FormattedLog)logProvider.getLog(PrintWriter.class);
        FormattedLog matchingNamedLog = (FormattedLog)logProvider.getLog("java.io.StringWriter");
        FormattedLog nonMatchingNamedLog = (FormattedLog)logProvider.getLog("java.io.Foo");
        MatcherAssert.assertThat((Object)stringWriterLog.isDebugEnabled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)otherClassLog.isDebugEnabled(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)matchingNamedLog.isDebugEnabled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)nonMatchingNamedLog.isDebugEnabled(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSetLevelForLogWithPartiallyMatchingContext() throws Exception {
        StringWriter writer = new StringWriter();
        FormattedLogProvider logProvider = FormattedLogProviderTest.newFormattedLogProvider(writer, "java.io", Level.DEBUG);
        FormattedLog stringWriterLog = (FormattedLog)logProvider.getLog(StringWriter.class);
        FormattedLog printWriterLog = (FormattedLog)logProvider.getLog(PrintWriter.class);
        FormattedLog otherClassLog = (FormattedLog)logProvider.getLog(Date.class);
        FormattedLog matchingNamedLog = (FormattedLog)logProvider.getLog("java.io.Foo");
        FormattedLog nonMatchingNamedLog = (FormattedLog)logProvider.getLog("java.util.Foo");
        MatcherAssert.assertThat((Object)stringWriterLog.isDebugEnabled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)printWriterLog.isDebugEnabled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)otherClassLog.isDebugEnabled(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)matchingNamedLog.isDebugEnabled(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)nonMatchingNamedLog.isDebugEnabled(), (Matcher)Is.is((Object)false));
    }

    private static FormattedLogProvider newFormattedLogProvider(StringWriter writer) {
        return FormattedLogProviderTest.newFormattedLogProvider(writer, Collections.emptyMap());
    }

    private static FormattedLogProvider newFormattedLogProvider(StringWriter writer, String context, Level level) {
        return FormattedLogProviderTest.newFormattedLogProvider(writer, Collections.singletonMap(context, level));
    }

    private static FormattedLogProvider newFormattedLogProvider(StringWriter writer, Map<String, Level> levels) {
        return new FormattedLogProvider(Suppliers.singleton((Object)FIXED_DATE), Suppliers.singleton((Object)new PrintWriter(writer)), FormattedLog.UTC, true, levels, Level.INFO, true);
    }
}

