/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.adversaries.fs.AdversarialOutputStream;
import org.neo4j.function.Suppliers;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class RotatingFileOutputStreamSupplierTest {
    private static final Executor DIRECT_EXECUTOR = Runnable::run;
    private FileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private File logFile = new File("/tmp/logfile.log");
    private File archiveLogFile1 = new File("/tmp/logfile.log.1");
    private File archiveLogFile2 = new File("/tmp/logfile.log.2");
    private File archiveLogFile3 = new File("/tmp/logfile.log.3");
    private File archiveLogFile4 = new File("/tmp/logfile.log.4");
    private File archiveLogFile5 = new File("/tmp/logfile.log.5");
    private File archiveLogFile6 = new File("/tmp/logfile.log.6");
    private File archiveLogFile7 = new File("/tmp/logfile.log.7");
    private File archiveLogFile8 = new File("/tmp/logfile.log.8");
    private File archiveLogFile9 = new File("/tmp/logfile.log.9");

    @Test
    public void createsLogOnConstruction() throws Exception {
        new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 250000L, 0L, 10, DIRECT_EXECUTOR);
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
    }

    @Test
    public void rotatesLogWhenSizeExceeded() throws Exception {
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        OutputStream outputStream = supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(outputStream, "A string longer than 10 bytes");
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)outputStream2, (Matcher)org.hamcrest.Matchers.not((Object)outputStream));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(outputStream2, "Short");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream2));
        this.write(outputStream2, "A string longer than 10 bytes");
        OutputStream outputStream3 = supplier.get();
        Assert.assertThat((Object)outputStream3, (Matcher)org.hamcrest.Matchers.not((Object)outputStream2));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
    }

    @Test
    public void limitsNumberOfArchivedLogs() throws Exception {
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 2, DIRECT_EXECUTOR);
        OutputStream outputStream = supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(outputStream, "A string longer than 10 bytes");
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(outputStream2, "A string longer than 10 bytes");
        OutputStream outputStream3 = supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
        this.write(outputStream3, "A string longer than 10 bytes");
        supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnSameStreamWhilstRotationOccurs() throws Exception {
        ManualExecutor executor = new ManualExecutor();
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, (Executor)executor);
        OutputStream outputStream = supplier.get();
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        Assert.assertThat((Object)executor.isScheduled(), (Matcher)Is.is((Object)true));
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        executor.runTask();
        Assert.assertThat((Object)supplier.get(), (Matcher)org.hamcrest.Matchers.not((Object)outputStream));
    }

    @Test
    public void shouldNotRotatesLogWhenSizeExceededByNotDelay() throws Exception {
        UpdatableLongSupplier clock = new UpdatableLongSupplier(System.currentTimeMillis());
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((LongSupplier)clock, this.fileSystem, this.logFile, 10L, TimeUnit.SECONDS.toMillis(60L), 10, DIRECT_EXECUTOR, new RotatingFileOutputStreamSupplier.RotationListener());
        OutputStream outputStream = supplier.get();
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)false));
        this.write(outputStream, "A string longer than 10 bytes");
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)outputStream2, (Matcher)org.hamcrest.Matchers.not((Object)outputStream));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)false));
        this.write(outputStream2, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream2));
        clock.setValue(clock.getAsLong() + TimeUnit.SECONDS.toMillis(59L));
        this.write(outputStream2, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream2));
        clock.setValue(clock.getAsLong() + TimeUnit.SECONDS.toMillis(1L));
        this.write(outputStream2, "A string longer than 10 bytes");
        OutputStream outputStream3 = supplier.get();
        Assert.assertThat((Object)outputStream3, (Matcher)org.hamcrest.Matchers.not((Object)outputStream2));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotifyListenerWhenNewLogIsCreated() throws Exception {
        final CountDownLatch allowRotationComplete = new CountDownLatch(1);
        final CountDownLatch rotationComplete = new CountDownLatch(1);
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.spy((Object)new RotatingFileOutputStreamSupplier.RotationListener(){

            public void outputFileCreated(OutputStream newStream, OutputStream oldStream) {
                try {
                    allowRotationComplete.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            public void rotationCompleted(OutputStream newStream, OutputStream oldStream) {
                rotationComplete.countDown();
            }
        });
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, (Executor)Executors.newSingleThreadExecutor(), rotationListener);
        OutputStream outputStream = supplier.get();
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        allowRotationComplete.countDown();
        rotationComplete.await();
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)outputStream2, (Matcher)org.hamcrest.Matchers.not((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).outputFileCreated(outputStream2, outputStream);
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationCompleted(outputStream2, outputStream);
    }

    @Test
    public void shouldNotifyListenerOnRotationErrorDuringJobExecution() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, executor, rotationListener);
        OutputStream outputStream = supplier.get();
        RejectedExecutionException exception = new RejectedExecutionException("text exception");
        ((Executor)Mockito.doThrow((Throwable)exception).when((Object)executor)).execute((Runnable)Matchers.any(Runnable.class));
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationError((Exception)exception, outputStream);
    }

    @Test
    public void shouldReattemptRotationAfterExceptionDuringJobExecution() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        Executor executor = (Executor)Mockito.mock(Executor.class);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, executor, rotationListener);
        OutputStream outputStream = supplier.get();
        RejectedExecutionException exception = new RejectedExecutionException("text exception");
        ((Executor)Mockito.doThrow((Throwable)exception).when((Object)executor)).execute((Runnable)Matchers.any(Runnable.class));
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener, (VerificationMode)Mockito.times((int)2))).rotationError((Exception)exception, outputStream);
    }

    @Test
    public void shouldNotifyListenerOnRotationErrorDuringRotationIO() throws Exception {
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.mock(RotatingFileOutputStreamSupplier.RotationListener.class);
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.spy((Object)this.fileSystem);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(fs, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR, rotationListener);
        OutputStream outputStream = supplier.get();
        IOException exception = new IOException("text exception");
        ((FileSystemAbstraction)Mockito.doThrow((Throwable)exception).when((Object)fs)).renameFile((File)Matchers.any(File.class), (File)Matchers.any(File.class));
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        ((RotatingFileOutputStreamSupplier.RotationListener)Mockito.verify((Object)rotationListener)).rotationError((Exception)exception, outputStream);
    }

    @Test
    public void shouldNotUpdateOutputStreamWhenClosedDuringRotation() throws Exception {
        final CountDownLatch allowRotationComplete = new CountDownLatch(1);
        RotatingFileOutputStreamSupplier.RotationListener rotationListener = (RotatingFileOutputStreamSupplier.RotationListener)Mockito.spy((Object)new RotatingFileOutputStreamSupplier.RotationListener(){

            public void outputFileCreated(OutputStream newStream, OutputStream oldStream) {
                try {
                    allowRotationComplete.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, (Executor)Executors.newSingleThreadExecutor(), rotationListener);
        OutputStream outputStream = supplier.get();
        this.write(outputStream, "A string longer than 10 bytes");
        Assert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)outputStream));
        allowRotationComplete.countDown();
        supplier.close();
        this.assertStreamClosed(supplier.get());
    }

    @Test
    public void shouldCloseAllOutputStreams() throws Exception {
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier(this.fileSystem, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        OutputStream outputStream = supplier.get();
        this.write(outputStream, "A string longer than 10 bytes");
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)outputStream2, (Matcher)org.hamcrest.Matchers.not((Object)outputStream));
        supplier.close();
        this.assertStreamClosed(outputStream);
        this.assertStreamClosed(outputStream2);
    }

    @Test
    public void shouldCloseAllStreamsDespiteError() throws Exception {
        final ArrayList mockStreams = new ArrayList();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fileSystem){

            public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
                OutputStream stream = (OutputStream)Mockito.spy((Object)super.openAsOutputStream(fileName, append));
                mockStreams.add(stream);
                return stream;
            }
        };
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)fs, this.logFile, 10L, 0L, 10, DIRECT_EXECUTOR);
        OutputStream outputStream = supplier.get();
        Assert.assertThat((Object)outputStream, (Matcher)CoreMatchers.sameInstance(mockStreams.get(0)));
        this.write(outputStream, "A string longer than 10 bytes");
        OutputStream outputStream2 = supplier.get();
        Assert.assertThat((Object)outputStream2, (Matcher)CoreMatchers.sameInstance(mockStreams.get(1)));
        IOException exception1 = new IOException("test exception");
        ((OutputStream)Mockito.doThrow((Throwable)exception1).when((Object)outputStream)).close();
        IOException exception2 = new IOException("test exception");
        ((OutputStream)Mockito.doThrow((Throwable)exception2).when((Object)outputStream2)).close();
        try {
            supplier.close();
        }
        catch (IOException e) {
            Assert.assertThat((Object)e, (Matcher)CoreMatchers.sameInstance((Object)exception2));
        }
        ((OutputStream)Mockito.verify((Object)outputStream)).close();
    }

    @Test
    public void shouldSurviveFilesystemErrors() throws Exception {
        RandomAdversary adversary = new RandomAdversary(0.1, 0.1, 0.0);
        adversary.setProbabilityFactor(0.0);
        SensibleAdversarialFileSystemAbstraction adversarialFileSystem = new SensibleAdversarialFileSystemAbstraction((Adversary)adversary, this.fileSystem);
        RotatingFileOutputStreamSupplier supplier = new RotatingFileOutputStreamSupplier((FileSystemAbstraction)adversarialFileSystem, this.logFile, 1000L, 0L, 9, DIRECT_EXECUTOR);
        adversary.setProbabilityFactor(1.0);
        this.writeLines((Supplier<OutputStream>)supplier, 10000);
        adversary.setProbabilityFactor(0.0);
        this.writeLines((Supplier<OutputStream>)supplier, 1000);
        Assert.assertThat((Object)this.fileSystem.fileExists(this.logFile), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile4), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile5), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile6), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile7), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile8), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.fileSystem.fileExists(this.archiveLogFile9), (Matcher)Is.is((Object)true));
    }

    private void write(OutputStream outputStream, String line) {
        PrintWriter writer = new PrintWriter(outputStream);
        writer.println(line);
        writer.flush();
    }

    private void writeLines(Supplier<OutputStream> outputStreamSupplier, int count) throws InterruptedException {
        Supplier printWriterSupplier = Suppliers.adapted(outputStreamSupplier, (Function)FormattedLog.OUTPUT_STREAM_CONVERTER);
        while (count >= 0) {
            ((PrintWriter)printWriterSupplier.get()).println("We are what we repeatedly do. Excellence, then, is not an act, but a habit.");
            Thread.yield();
            --count;
        }
    }

    private void assertStreamClosed(OutputStream stream) throws IOException {
        try {
            stream.write(0);
            Assert.fail((String)"Expected ClosedChannelException");
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static class SensibleAdversarialFileSystemAbstraction
    extends AdversarialFileSystemAbstraction {
        private final Adversary adversary;
        private final FileSystemAbstraction delegate;

        SensibleAdversarialFileSystemAbstraction(Adversary adversary, FileSystemAbstraction delegate) {
            super(adversary, delegate);
            this.adversary = adversary;
            this.delegate = delegate;
        }

        public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
            this.adversary.injectFailure(new Class[]{FileNotFoundException.class});
            final OutputStream outputStream = this.delegate.openAsOutputStream(fileName, append);
            return new AdversarialOutputStream(outputStream, this.adversary){

                public void write(byte[] b) throws IOException {
                    adversary.injectFailure(new Class[]{IOException.class});
                    outputStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    adversary.injectFailure(new Class[]{IOException.class});
                    outputStream.write(b, off, len);
                }
            };
        }

        public boolean fileExists(File fileName) {
            return this.delegate.fileExists(fileName);
        }

        public long getFileSize(File fileName) {
            return this.delegate.getFileSize(fileName);
        }
    }

    private static class UpdatableLongSupplier
    implements LongSupplier {
        private final AtomicLong longValue;

        UpdatableLongSupplier(long value) {
            this.longValue = new AtomicLong(value);
        }

        public long setValue(long value) {
            return this.longValue.getAndSet(value);
        }

        @Override
        public long getAsLong() {
            return this.longValue.get();
        }
    }

    private class ManualExecutor
    implements Executor {
        private Runnable task;

        private ManualExecutor() {
        }

        @Override
        public void execute(Runnable task) {
            if (this.isScheduled()) {
                throw new IllegalStateException("task already scheduled with Executor");
            }
            this.task = task;
        }

        public boolean isScheduled() {
            return this.task != null;
        }

        public void runTask() {
            if (!this.isScheduled()) {
                throw new IllegalStateException("task not scheduled with Executor");
            }
            this.task.run();
            this.task = null;
        }
    }
}

