/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class LuceneIndexSiteExamples {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    @BeforeClass
    public static void setUpDb() {
        String path = "target/var/examples";
        Neo4jTestCase.deleteFileOrDirectory(new File(path));
        graphDb = new EmbeddedGraphDatabase(path);
    }

    @Before
    public void beginTx() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void finishTx() {
        this.tx.success();
        this.tx.finish();
    }

    @Test
    public void addSomeThings() {
        Index persons = graphDb.index().forNodes("persons");
        Node morpheus = graphDb.createNode();
        Node trinity = graphDb.createNode();
        Node neo = graphDb.createNode();
        persons.add((PropertyContainer)morpheus, "name", (Object)"Morpheus");
        persons.add((PropertyContainer)morpheus, "rank", (Object)"Captain");
        persons.add((PropertyContainer)trinity, "name", (Object)"Trinity");
        persons.add((PropertyContainer)neo, "name", (Object)"Neo");
        persons.add((PropertyContainer)neo, "title", (Object)"The One");
    }

    @Test
    public void doSomeGets() {
        Index persons = graphDb.index().forNodes("persons");
        Node morpheus = (Node)persons.get("name", (Object)"Morpheus").getSingle();
    }

    @Test
    public void doSomeQueries() {
        Index persons = graphDb.index().forNodes("persons");
        for (Node node : persons.query("name", (Object)"*e*")) {
        }
        Node neo = (Node)persons.query((Object)"name:*e* AND title:\"The One\"").getSingle();
    }
}

