/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.index.impl.lucene.Command;
import org.neo4j.index.impl.lucene.CommandState;

public class BaseWorker
extends Thread {
    protected Index<Node> index;
    protected GraphDatabaseService graphDb;
    protected Exception exception;
    protected CountDownLatch latch = new CountDownLatch(1);
    protected AtomicInteger threadState = new AtomicInteger(4);
    private static final int WAITING = 1;
    private static final int RUNNING = 2;
    private static final int DONE = 3;
    private static final int STARTING = 4;
    private Queue<Command> commands = new ConcurrentLinkedQueue<Command>();

    public BaseWorker(Index<Node> index, GraphDatabaseService graphDb) {
        this.index = index;
        this.graphDb = graphDb;
        this.start();
        this.waitForWorkerToStart();
    }

    @Override
    public void run() {
        CommandState state = new CommandState(this.index, this.graphDb);
        this.threadState.set(4);
        while (state.alive) {
            try {
                this.latch = new CountDownLatch(1);
                this.log("WORKER: Waiting for latch");
                this.latch.await();
                this.threadState.set(2);
                Command command = this.commands.poll();
                this.log("WORKER: I have a command! " + command.getClass().getSimpleName());
                command.doWork(state);
                this.threadState.set(3);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (Exception exception) {
                this.exception = exception;
                this.threadState.set(3);
            }
        }
    }

    private void log(String s) {
    }

    protected void queueCommand(Command cmd) {
        this.commands.add(cmd);
        this.log("MASTER: Queuing command, and starting worker - " + cmd.getClass().getSimpleName());
        this.latch.countDown();
        this.waitForCommandToComplete();
        this.threadState.set(1);
    }

    private void waitForCommandToComplete() {
        this.waitFor(3, 1);
    }

    private void waitForWorkerToStart() {
        this.waitFor(4, 1);
    }

    private void waitFor(int expectedState, int newState) {
        int retries = 0;
        while (!this.threadState.compareAndSet(expectedState, newState) && retries++ < 100) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (retries > 300) {
            throw new IllegalStateException("Something didn't finish in a timely manner. Aborting...");
        }
    }
}

