/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.util.Arrays;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class TestIndexNames {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    @BeforeClass
    public static void setUpStuff() {
        String storeDir = "target/var/freshindex";
        Neo4jTestCase.deleteFileOrDirectory(new File(storeDir));
        graphDb = new EmbeddedGraphDatabase(storeDir, MapUtil.stringMap((String[])new String[]{"index", "lucene"}));
    }

    @AfterClass
    public static void tearDownStuff() {
        graphDb.shutdown();
    }

    @After
    public void commitTx() {
        this.finishTx(true);
    }

    public void rollbackTx() {
        this.finishTx(false);
    }

    public void finishTx(boolean success) {
        if (this.tx != null) {
            if (success) {
                this.tx.success();
            }
            this.tx.finish();
            this.tx = null;
        }
    }

    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
    }

    void restartTx() {
        this.finishTx(true);
        this.beginTx();
    }

    @Test
    public void makeSureIndexNamesCanBeRead() {
        Assert.assertEquals((long)0L, (long)graphDb.index().nodeIndexNames().length);
        String name1 = "my-index-1";
        Index nodeIndex1 = graphDb.index().forNodes(name1);
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name1});
        String name2 = "my-index-2";
        graphDb.index().forNodes(name2);
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name1, name2});
        graphDb.index().forRelationships(name1);
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name1, name2});
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().relationshipIndexNames()), new String[]{name1});
        this.restartTx();
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name1, name2});
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().relationshipIndexNames()), new String[]{name1});
        nodeIndex1.delete();
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name1, name2});
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().relationshipIndexNames()), new String[]{name1});
        this.restartTx();
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().nodeIndexNames()), new String[]{name2});
        Neo4jTestCase.assertContains(Arrays.asList(graphDb.index().relationshipIndexNames()), new String[]{name1});
    }
}

