/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.NumericRangeQuery;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.BatchInserterIndex;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.LuceneBatchInserterIndexProvider;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.ValueContext;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;

public class TestLuceneBatchInsert {
    private static final String PATH = "target/var/batch";

    @Before
    public void cleanDirectory() {
        Neo4jTestCase.deleteFileOrDirectory(new File(PATH));
    }

    @Test
    public void testSome() throws Exception {
        int i;
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("users", LuceneIndexImplementation.EXACT_CONFIG);
        HashMap<Integer, Long> ids = new HashMap<Integer, Long>();
        for (i = 0; i < 100; ++i) {
            long id = inserter.createNode(null);
            index.add(id, MapUtil.map((Object[])new Object[]{"name", "Joe" + i, "other", "Schmoe"}));
            ids.put(i, id);
        }
        for (i = 0; i < 100; ++i) {
            Neo4jTestCase.assertContains(index.get("name", (Object)("Joe" + i)), new Long[]{(Long)ids.get(i)});
        }
        Neo4jTestCase.assertContains(index.query((Object)"name:Joe0 AND other:Schmoe"), new Long[]{(Long)ids.get(0)});
        Neo4jTestCase.assertContains(index.query("name", (Object)"Joe*"), ids.values().toArray(new Long[ids.size()]));
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH);
        Assert.assertTrue((boolean)db.index().existsForNodes("users"));
        Index dbIndex = db.index().forNodes("users");
        for (int i2 = 0; i2 < 100; ++i2) {
            Neo4jTestCase.assertContains(dbIndex.get("name", (Object)("Joe" + i2)), new Node[]{db.getNodeById(((Long)ids.get(i2)).longValue())});
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator i$ = ids.values().iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            nodes.add(db.getNodeById(id));
        }
        Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"Joe*"), nodes.toArray(new Node[nodes.size()]));
        Neo4jTestCase.assertContains(dbIndex.query((Object)"name:Joe0 AND other:Schmoe"), new Node[]{db.getNodeById(((Long)ids.get(0)).longValue())});
        db.shutdown();
    }

    @Test
    public void testFulltext() {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        String name = "users";
        BatchInserterIndex index = provider.nodeIndex(name, MapUtil.stringMap((String[])new String[]{"type", "fulltext"}));
        long id1 = inserter.createNode(null);
        index.add(id1, MapUtil.map((Object[])new Object[]{"name", "Mattias Persson", "email", "something@somewhere", "something", "bad"}));
        long id2 = inserter.createNode(null);
        index.add(id2, MapUtil.map((Object[])new Object[]{"name", "Lars PerssoN"}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Mattias Persson"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"mattias"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"bla"), new Long[0]);
        Neo4jTestCase.assertContains(index.query("name", (Object)"persson"), new Long[]{id1, id2});
        Neo4jTestCase.assertContains(index.query("email", (Object)"*@*"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.get("something", (Object)"bad"), new Long[]{id1});
        long id3 = inserter.createNode(null);
        index.add(id3, MapUtil.map((Object[])new Object[]{"name", new String[]{"What Ever", "Anything"}}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"What Ever"), new Long[]{id3});
        Neo4jTestCase.assertContains(index.get("name", (Object)"Anything"), new Long[]{id3});
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH);
        Index dbIndex = db.index().forNodes(name);
        Node node1 = db.getNodeById(id1);
        Node node2 = db.getNodeById(id2);
        Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"persson"), new Node[]{node1, node2});
        db.shutdown();
    }

    @Ignore
    @Test
    public void testInsertionSpeed() {
        int i;
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("yeah", LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity("key", 1000000);
        long t = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            Map properties = MapUtil.map((Object[])new Object[]{"key", "value" + i});
            long id = inserter.createNode(properties);
            index.add(id, properties);
        }
        System.out.println("insert:" + (System.currentTimeMillis() - t));
        index.flush();
        t = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            IteratorUtil.count((Iterator)index.get("key", (Object)("value" + i)));
        }
        System.out.println("get:" + (System.currentTimeMillis() - t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindCreatedIndex() {
        String indexName = "persons";
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex persons = indexProvider.nodeIndex("persons", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
        Map properties = MapUtil.map((Object[])new Object[]{"name", "test"});
        long node = inserter.createNode(properties);
        persons.add(node, properties);
        indexProvider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(PATH);
        Transaction tx = graphDb.beginTx();
        try {
            IndexManager indexManager = graphDb.index();
            junit.framework.Assert.assertFalse((boolean)indexManager.existsForRelationships(indexName));
            junit.framework.Assert.assertTrue((boolean)indexManager.existsForNodes(indexName));
            junit.framework.Assert.assertNotNull((Object)indexManager.forNodes(indexName));
            Index nodes = graphDb.index().forNodes(indexName);
            junit.framework.Assert.assertTrue((boolean)nodes.get("name", (Object)"test").hasNext());
            tx.success();
            tx.finish();
        }
        finally {
            graphDb.shutdown();
        }
    }

    @Test
    public void testCanIndexRelationships() {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex edgesIndex = indexProvider.relationshipIndex("edgeIndex", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        long nodeId1 = inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "1"}));
        long nodeId2 = inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "2"}));
        long relationshipId = inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)EdgeType.KNOWS, null);
        edgesIndex.add(relationshipId, MapUtil.map((Object[])new Object[]{"EDGE_TYPE", EdgeType.KNOWS.name()}));
        edgesIndex.flush();
        Assert.assertEquals((String)String.format("Should return relationship id", new Object[0]), (Object)new Long(relationshipId), (Object)edgesIndex.query("EDGE_TYPE", (Object)EdgeType.KNOWS.name()).getSingle());
        indexProvider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void triggerNPEAfterFlush() {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("Neo4j::Node-exact", LuceneIndexImplementation.EXACT_CONFIG);
        Map map = MapUtil.map((Object[])new Object[]{"name", "Something"});
        long node = inserter.createNode(map);
        index.add(node, map);
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Something"), new Long[]{node});
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void testNumericValues() {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long node1 = inserter.createNode(null);
        index.add(node1, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)45)}));
        long node2 = inserter.createNode(null);
        index.add(node2, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)21)}));
        Neo4jTestCase.assertContains(index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)50, (boolean)true, (boolean)true)), new Long[]{node1, node2});
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(PATH);
        Node n1 = db.getNodeById(node1);
        Node n2 = db.getNodeById(node2);
        Index idx = db.index().forNodes("mine");
        Neo4jTestCase.assertContains(idx.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)45, (boolean)false, (boolean)true)), new Node[]{n1});
        db.shutdown();
    }

    private static enum EdgeType implements RelationshipType
    {
        KNOWS;

    }
}

