/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.Contains;
import org.neo4j.index.impl.lucene.CustomAnalyzer;
import org.neo4j.index.impl.lucene.IsEmpty;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.QueryContext;
import org.neo4j.index.impl.lucene.ValueContext;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class TestLuceneIndex {
    private static GraphDatabaseService graphDb;
    private Transaction tx;
    private static final RelationshipType TEST_TYPE;
    private static final EntityCreator<Node> NODE_CREATOR;
    private static final EntityCreator<Relationship> RELATIONSHIP_CREATOR;

    @BeforeClass
    public static void setUpStuff() {
        String storeDir = "target/var/freshindex";
        Neo4jTestCase.deleteFileOrDirectory(new File(storeDir));
        graphDb = new EmbeddedGraphDatabase(storeDir);
    }

    @AfterClass
    public static void tearDownStuff() {
        graphDb.shutdown();
    }

    @After
    public void commitTx() {
        this.finishTx(true);
    }

    private void rollbackTx() {
        this.finishTx(false);
    }

    public void finishTx(boolean success) {
        if (this.tx != null) {
            if (success) {
                this.tx.success();
            }
            this.tx.finish();
            this.tx = null;
        }
    }

    @Before
    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
    }

    void restartTx() {
        this.commitTx();
        this.beginTx();
    }

    private static void setProperties(PropertyContainer entity, Object ... properties) {
        for (Map.Entry entry : MapUtil.map((Object[])properties).entrySet()) {
            entity.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    private Index<Node> nodeIndex(String name, Map<String, String> config) {
        return graphDb.index().forNodes(name, config);
    }

    private RelationshipIndex relationshipIndex(String name, Map<String, String> config) {
        return graphDb.index().forRelationships(name, config);
    }

    private <T extends PropertyContainer> void makeSureAdditionsCanBeRead(Index<T> index, EntityCreator<T> entityCreator) {
        String key = "name";
        String value = "Mattias";
        Assert.assertThat((Object)index.get(key, (Object)value).getSingle(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)index.get(key, (Object)value), IsEmpty.isEmpty());
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        T entity1 = entityCreator.create(new Object[0]);
        T entity2 = entityCreator.create(new Object[0]);
        index.add(entity1, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1));
            Assert.assertThat((Object)index.query(key, (Object)"*"), Contains.contains(entity1));
            Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1));
            this.restartTx();
        }
        index.add(entity2, key, (Object)value);
        Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1, entity2));
        this.restartTx();
        Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1, entity2));
        index.delete();
    }

    @Test
    public void makeSureYouGetLatestTxModificationsInQueryByDefault() {
        Index<Node> index = this.nodeIndex("failing-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        Assert.assertThat((Object)index.query((Object)"key:value"), Contains.contains(node));
    }

    @Test
    public void testStartupInExistingDirectory() {
        File dir = new File("target/temp/");
        Neo4jTestCase.deleteFileOrDirectory(dir);
        dir.mkdir();
        EmbeddedGraphDatabase graphDatabase = new EmbeddedGraphDatabase(dir.getAbsolutePath());
        Index index = graphDatabase.index().forNodes("nodes");
        Assert.assertNotNull((Object)index);
    }

    @Test
    public void makeSureAdditionsCanBeReadNodeExact() {
        this.makeSureAdditionsCanBeRead(this.nodeIndex("exact", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadNodeFulltext() {
        this.makeSureAdditionsCanBeRead(this.nodeIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadRelationshipExact() {
        this.makeSureAdditionsCanBeRead((Index)this.relationshipIndex("exact", LuceneIndexImplementation.EXACT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadRelationshipFulltext() {
        this.makeSureAdditionsCanBeRead((Index)this.relationshipIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeRemovedInSameTx() {
        this.makeSureAdditionsCanBeRemoved(false);
    }

    @Test
    public void makeSureYouCanAskIfAnIndexExistsOrNot() {
        String name = "index-that-may-exist";
        Assert.assertFalse((boolean)graphDb.index().existsForNodes(name));
        graphDb.index().forNodes(name);
        Assert.assertTrue((boolean)graphDb.index().existsForNodes(name));
        Assert.assertFalse((boolean)graphDb.index().existsForRelationships(name));
        graphDb.index().forRelationships(name);
        Assert.assertTrue((boolean)graphDb.index().existsForRelationships(name));
    }

    private void makeSureAdditionsCanBeRemoved(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value = "Mattias";
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)value);
        if (restartTx) {
            this.restartTx();
        }
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
        index.remove((PropertyContainer)node, key, (Object)value);
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        this.restartTx();
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        node.delete();
        index.delete();
    }

    @Test
    public void makeSureAdditionsCanBeRemoved() {
        this.makeSureAdditionsCanBeRemoved(true);
    }

    private void makeSureSomeAdditionsCanBeRemoved(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key1 = "name";
        String key2 = "title";
        String value1 = "Mattias";
        Assert.assertNull((Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        Node node = graphDb.createNode();
        Node node2 = graphDb.createNode();
        index.add((PropertyContainer)node, key1, (Object)value1);
        index.add((PropertyContainer)node, key2, (Object)value1);
        index.add((PropertyContainer)node2, key1, (Object)value1);
        if (restartTx) {
            this.restartTx();
        }
        index.remove((PropertyContainer)node, key1, (Object)value1);
        index.remove((PropertyContainer)node, key2, (Object)value1);
        Assert.assertEquals((Object)node2, (Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        Assert.assertEquals((Object)node2, (Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        node.delete();
        index.delete();
    }

    @Test
    public void makeSureSomeAdditionsCanBeRemovedInSameTx() {
        this.makeSureSomeAdditionsCanBeRemoved(false);
    }

    @Test
    public void makeSureSomeAdditionsCanBeRemoved() {
        this.makeSureSomeAdditionsCanBeRemoved(true);
    }

    @Test
    public void makeSureThereCanBeMoreThanOneValueForAKeyAndEntity() {
        this.makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(false);
    }

    @Test
    public void makeSureThereCanBeMoreThanOneValueForAKeyAndEntitySameTx() {
        this.makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(true);
    }

    private void makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "Lucene";
        String value2 = "Index";
        String value3 = "Rules";
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)value1);
        index.add((PropertyContainer)node, key, (Object)value2);
        if (restartTx) {
            this.restartTx();
        }
        index.add((PropertyContainer)node, key, (Object)value3);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value3), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)"whatever"), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void shouldNotGetLatestTxModificationsWhenChoosingSpeedQueries() {
        Index<Node> index = this.nodeIndex("indexFooBar", LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        QueryContext queryContext = new QueryContext((Object)"value").tradeCorrectnessForSpeed();
        Assert.assertThat((Object)index.query("key", (Object)queryContext), IsEmpty.isEmpty());
        Assert.assertThat((Object)index.query("key", (Object)"value"), Contains.contains(node));
    }

    @Test
    public void makeSureArrayValuesAreSupported() {
        int i;
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "Lucene";
        String value2 = "Index";
        String value3 = "Rules";
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)new String[]{value1, value2, value3});
        for (i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value3), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)"whatever"), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.remove((PropertyContainer)node, key, (Object)new String[]{value2, value3});
        for (i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.get(key, (Object)value3), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void makeSureWildcardQueriesCanBeAsked() {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "neo4j";
        String value2 = "nescafe";
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        index.add((PropertyContainer)node1, key, (Object)value1);
        index.add((PropertyContainer)node2, key, (Object)value2);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query(key, (Object)"neo*"), Contains.contains(node1));
            Assert.assertThat((Object)index.query(key, (Object)"n?o4j"), Contains.contains(node1));
            Assert.assertThat((Object)index.query(key, (Object)"ne*"), Contains.contains(node1, node2));
            Assert.assertThat((Object)index.query((Object)(key + ":neo4j")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":neo*")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":n?o4j")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":ne*")), Contains.contains(node1, node2));
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void makeSureCompositeQueriesCanBeAsked() {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        Node neo = graphDb.createNode();
        Node trinity = graphDb.createNode();
        index.add((PropertyContainer)neo, "username", (Object)"neo@matrix");
        index.add((PropertyContainer)neo, "sex", (Object)"male");
        index.add((PropertyContainer)trinity, "username", (Object)"trinity@matrix");
        index.add((PropertyContainer)trinity, "sex", (Object)"female");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)"username:*@matrix AND sex:male"), Contains.contains(neo));
            Assert.assertThat((Object)index.query((Object)new QueryContext((Object)"username:*@matrix sex:male").defaultOperator(QueryParser.Operator.AND)), Contains.contains(neo));
            Assert.assertThat((Object)index.query((Object)"username:*@matrix OR sex:male"), Contains.contains(neo, trinity));
            Assert.assertThat((Object)index.query((Object)new QueryContext((Object)"username:*@matrix sex:male").defaultOperator(QueryParser.Operator.OR)), Contains.contains(neo, trinity));
            this.restartTx();
        }
        index.delete();
    }

    private <T extends PropertyContainer> void doSomeRandomUseCaseTestingWithExactIndex(Index<T> index, EntityCreator<T> creator) {
        String name = "name";
        String mattias = "Mattias Persson";
        String title = "title";
        String hacker = "Hacker";
        Assert.assertThat((Object)index.get(name, (Object)mattias), IsEmpty.isEmpty());
        T entity1 = creator.create(new Object[0]);
        T entity2 = creator.create(new Object[0]);
        Assert.assertNull((Object)index.get(name, (Object)mattias).getSingle());
        index.add(entity1, name, (Object)mattias);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Neo4jTestCase.assertContains(index.query(name, (Object)("\"" + mattias + "\"")), new PropertyContainer[]{entity1});
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\"")), new PropertyContainer[]{entity1});
        Assert.assertEquals(entity1, (Object)index.get(name, (Object)mattias).getSingle());
        Neo4jTestCase.assertContains(index.query("name", (Object)"Mattias*"), new PropertyContainer[]{entity1});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.query(name, (Object)("\"" + mattias + "\"")), Contains.contains(entity1));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\"")), Contains.contains(entity1));
        Assert.assertEquals(entity1, (Object)index.get(name, (Object)mattias).getSingle());
        Assert.assertThat((Object)index.query("name", (Object)"Mattias*"), Contains.contains(entity1));
        this.beginTx();
        index.add(entity2, title, (Object)hacker);
        index.add(entity1, title, (Object)hacker);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1, entity2));
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), new PropertyContainer[]{entity1, entity2});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1, entity2));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), Contains.contains(entity1, entity2));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" AND title:\"" + hacker + "\"")), Contains.contains(entity1));
        this.beginTx();
        index.remove(entity2, title, (Object)hacker);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1));
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), new PropertyContainer[]{entity1});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), Contains.contains(entity1));
        this.beginTx();
        index.remove(entity1, title, (Object)hacker);
        index.remove(entity1, name, (Object)mattias);
        index.delete();
        this.commitTx();
    }

    @Test
    public void doSomeRandomUseCaseTestingWithExactNodeIndex() {
        this.doSomeRandomUseCaseTestingWithExactIndex(this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void doSomeRandomUseCaseTestingWithExactRelationshipIndex() {
        this.doSomeRandomUseCaseTestingWithExactIndex((Index)this.relationshipIndex("index", LuceneIndexImplementation.EXACT_CONFIG), RELATIONSHIP_CREATOR);
    }

    private <T extends PropertyContainer> void doSomeRandomTestingWithFulltextIndex(Index<T> index, EntityCreator<T> creator) {
        T entity1 = creator.create(new Object[0]);
        T entity2 = creator.create(new Object[0]);
        String key = "name";
        index.add(entity1, key, (Object)"The quick brown fox");
        index.add(entity2, key, (Object)"brown fox jumped over");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)"The quick brown fox"), Contains.contains(entity1));
            Assert.assertThat((Object)index.get(key, (Object)"brown fox jumped over"), Contains.contains(entity2));
            Assert.assertThat((Object)index.query(key, (Object)"quick"), Contains.contains(entity1));
            Assert.assertThat((Object)index.query(key, (Object)"brown"), Contains.contains(entity1, entity2));
            Assert.assertThat((Object)index.query(key, (Object)"quick OR jumped"), Contains.contains(entity1, entity2));
            Assert.assertThat((Object)index.query(key, (Object)"brown AND fox"), Contains.contains(entity1, entity2));
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void doSomeRandomTestingWithNodeFulltextInde() {
        this.doSomeRandomTestingWithFulltextIndex(this.nodeIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void doSomeRandomTestingWithRelationshipFulltextInde() {
        this.doSomeRandomTestingWithFulltextIndex((Index)this.relationshipIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void testNodeLocalRelationshipIndex() {
        RelationshipIndex index = this.relationshipIndex("locality", LuceneIndexImplementation.EXACT_CONFIG);
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"YO");
        Node startNode = graphDb.createNode();
        Node endNode1 = graphDb.createNode();
        Node endNode2 = graphDb.createNode();
        Relationship rel1 = startNode.createRelationshipTo(endNode1, (RelationshipType)type);
        Relationship rel2 = startNode.createRelationshipTo(endNode2, (RelationshipType)type);
        index.add((PropertyContainer)rel1, "name", (Object)"something");
        index.add((PropertyContainer)rel2, "name", (Object)"something");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)"name:something"), Contains.contains(rel1, rel2));
            Assert.assertThat((Object)index.query((Object)"name:something", null, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.query((Object)"name:something", startNode, endNode2), Contains.contains(rel2));
            Assert.assertThat((Object)index.query(null, startNode, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.get("name", (Object)"something", null, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.get("name", (Object)"something", startNode, endNode2), Contains.contains(rel2));
            Assert.assertThat((Object)index.get(null, null, startNode, endNode1), Contains.contains(rel1));
            this.restartTx();
        }
        rel2.delete();
        rel1.delete();
        startNode.delete();
        endNode1.delete();
        endNode2.delete();
        index.delete();
    }

    @Test
    public void testSortByRelevance() {
        Index<Node> index = this.nodeIndex("relevance", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        index.add((PropertyContainer)node1, "name", (Object)"something");
        index.add((PropertyContainer)node2, "name", (Object)"something");
        index.add((PropertyContainer)node2, "foo", (Object)"yes");
        index.add((PropertyContainer)node3, "name", (Object)"something");
        index.add((PropertyContainer)node3, "foo", (Object)"yes");
        index.add((PropertyContainer)node3, "bar", (Object)"yes");
        this.restartTx();
        IndexHits hits = index.query((Object)new QueryContext((Object)"+name:something foo:yes bar:yes").sort(Sort.RELEVANCE));
        Assert.assertEquals((Object)node3, (Object)hits.next());
        Assert.assertEquals((Object)node2, (Object)hits.next());
        Assert.assertEquals((Object)node1, (Object)hits.next());
        Assert.assertFalse((boolean)hits.hasNext());
        index.delete();
        node1.delete();
        node2.delete();
        node3.delete();
    }

    @Test
    public void testSorting() {
        Index<Node> index = this.nodeIndex("sort", LuceneIndexImplementation.EXACT_CONFIG);
        String name = "name";
        String title = "title";
        String other = "other";
        String sex = "sex";
        Node adam = graphDb.createNode();
        Node adam2 = graphDb.createNode();
        Node jack = graphDb.createNode();
        Node eva = graphDb.createNode();
        index.add((PropertyContainer)adam, name, (Object)"Adam");
        index.add((PropertyContainer)adam, title, (Object)"Software developer");
        index.add((PropertyContainer)adam, sex, (Object)"male");
        index.add((PropertyContainer)adam, other, (Object)"aaa");
        index.add((PropertyContainer)adam2, name, (Object)"Adam");
        index.add((PropertyContainer)adam2, title, (Object)"Blabla");
        index.add((PropertyContainer)adam2, sex, (Object)"male");
        index.add((PropertyContainer)adam2, other, (Object)"bbb");
        index.add((PropertyContainer)jack, name, (Object)"Jack");
        index.add((PropertyContainer)jack, title, (Object)"Apple sales guy");
        index.add((PropertyContainer)jack, sex, (Object)"male");
        index.add((PropertyContainer)jack, other, (Object)"ccc");
        index.add((PropertyContainer)eva, name, (Object)"Eva");
        index.add((PropertyContainer)eva, title, (Object)"Secretary");
        index.add((PropertyContainer)eva, sex, (Object)"female");
        index.add((PropertyContainer)eva, other, (Object)"ddd");
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{title})), new Node[]{adam2, adam, eva, jack});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{other})), new Node[]{adam, adam2, eva, jack});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(sex, new String[]{title})), new Node[]{eva, jack, adam2, adam});
            Neo4jTestCase.assertContainsInOrder(index.query(name, (Object)new QueryContext((Object)"*").sort(sex, new String[]{title})), new Node[]{eva, jack, adam2, adam});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{title}).top(2)), new Node[]{adam2, adam});
            this.restartTx();
        }
    }

    @Test
    public void testNumericValues() {
        Index<Node> index = this.nodeIndex("numeric", LuceneIndexImplementation.EXACT_CONFIG);
        Node node10 = graphDb.createNode();
        Node node6 = graphDb.createNode();
        Node node31 = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)node10, key, (Object)ValueContext.numeric((Number)10));
        index.add((PropertyContainer)node6, key, (Object)ValueContext.numeric((Number)6));
        index.add((PropertyContainer)node31, key, (Object)ValueContext.numeric((Number)31));
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)4, (Integer)40, (boolean)true, (boolean)true)), Contains.contains(node10, node6, node31));
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)6, (Integer)15, (boolean)true, (boolean)true)), Contains.contains(node10, node6));
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)6, (Integer)15, (boolean)false, (boolean)true)), Contains.contains(node10));
            this.restartTx();
        }
    }

    @Test
    public void testRemoveNumericValues() {
        Index<Node> index = this.nodeIndex("numeric2", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        index.add((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        index.remove((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
        index.remove((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), IsEmpty.isEmpty());
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), IsEmpty.isEmpty());
        index.add((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        index.add((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node1, node2));
        index.remove((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
    }

    @Test
    public void testIndexNumberAsString() {
        Index<Node> index = this.nodeIndex("nums", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        index.add((PropertyContainer)node1, "key", (Object)10);
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)node1, (Object)index.get("key", (Object)10).getSingle());
            Assert.assertEquals((Object)node1, (Object)index.get("key", (Object)"10").getSingle());
            Assert.assertEquals((Object)node1, (Object)index.query("key", (Object)10).getSingle());
            Assert.assertEquals((Object)node1, (Object)index.query("key", (Object)"10").getSingle());
            this.restartTx();
        }
    }

    private <T extends PropertyContainer> void testInsertionSpeed(Index<T> index, EntityCreator<T> creator) {
        int i;
        long t = System.currentTimeMillis();
        for (int i2 = 0; i2 < 300000; ++i2) {
            T entity = creator.create(new Object[0]);
            if (i2 % 5000 == 5) {
                index.query((Object)new TermQuery(new Term("name", "The name " + i2)));
            }
            IteratorUtil.lastOrNull((Iterable)index.query((Object)new QueryContext((Object)new TermQuery(new Term("name", "The name " + i2))).tradeCorrectnessForSpeed()));
            IteratorUtil.lastOrNull((Iterable)index.get("name", (Object)("The name " + i2)));
            index.add(entity, "name", (Object)("The name " + i2));
            index.add(entity, "title", (Object)("Some title " + i2));
            index.add(entity, "something", (Object)(i2 + "Nothing"));
            index.add(entity, "else", (Object)(i2 + "kdfjkdjf" + i2));
            if (i2 % 10000 != 0) continue;
            this.restartTx();
            System.out.println(i2);
        }
        System.out.println("insert:" + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        int count = 1000;
        int resultCount = 0;
        for (i = 0; i < count; ++i) {
            for (PropertyContainer entity : index.get("name", (Object)("The name " + i * 900))) {
                ++resultCount;
            }
        }
        System.out.println("get(" + resultCount + "):" + (double)(System.currentTimeMillis() - t) / (double)count);
        t = System.currentTimeMillis();
        resultCount = 0;
        for (i = 0; i < count; ++i) {
            for (PropertyContainer entity : index.get("something", (Object)(i * 900 + "Nothing"))) {
                ++resultCount;
            }
        }
        System.out.println("get(" + resultCount + "):" + (double)(System.currentTimeMillis() - t) / (double)count);
    }

    @Ignore
    @Test
    public void testNodeInsertionSpeed() {
        this.testInsertionSpeed(this.nodeIndex("insertion-speed", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Ignore
    @Test
    public void testNodeFulltextInsertionSpeed() {
        this.testInsertionSpeed(this.nodeIndex("insertion-speed-full", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Ignore
    @Test
    public void testRelationshipInsertionSpeed() {
        this.testInsertionSpeed((Index)this.relationshipIndex("insertion-speed", LuceneIndexImplementation.EXACT_CONFIG), new FastRelationshipCreator());
    }

    @Test(expected=IllegalArgumentException.class)
    public void makeSureIndexGetsCreatedImmediately() {
        this.nodeIndex("immediate-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Assert.assertTrue((boolean)graphDb.index().existsForNodes("immediate-index"));
        this.rollbackTx();
        Assert.assertTrue((boolean)graphDb.index().existsForNodes("immediate-index"));
        this.nodeIndex("immediate-index", LuceneIndexImplementation.EXACT_CONFIG);
    }

    @Test
    public void makeSureFulltextConfigIsCaseInsensitiveByDefault() {
        Index<Node> index = this.nodeIndex("ft-case-sensitive", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        String key = "name";
        String value = "Mattias Persson";
        index.add((PropertyContainer)node, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query("name", (Object)"[A TO Z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"[a TO z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"Mattias"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"mattias"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"Matt*"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"matt*"), Contains.contains(node));
            this.restartTx();
        }
    }

    @Test
    public void makeSureFulltextIndexCanBeCaseSensitive() {
        Index<Node> index = this.nodeIndex("ft-case-insensitive", MapUtil.stringMap(new HashMap(LuceneIndexImplementation.FULLTEXT_CONFIG), (String[])new String[]{"to_lower_case", "false"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "Mattias Persson";
        index.add((PropertyContainer)node, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query("name", (Object)"[A TO Z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"[a TO z]"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.query("name", (Object)"Matt*"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"matt*"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.query("name", (Object)"Persson"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"persson"), IsEmpty.isEmpty());
            this.restartTx();
        }
    }

    @Test
    public void makeSureCustomAnalyzerCanBeUsed() {
        CustomAnalyzer.called = false;
        Index<Node> index = this.nodeIndex("w-custom-analyzer", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "analyzer", CustomAnalyzer.class.getName(), "to_lower_case", "true"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "The value";
        index.add((PropertyContainer)node, key, (Object)value);
        this.restartTx();
        Assert.assertTrue((boolean)CustomAnalyzer.called);
        Assert.assertThat((Object)index.query(key, (Object)"[A TO Z]"), Contains.contains(node));
    }

    @Test
    public void makeSureCustomAnalyzerCanBeUsed2() {
        CustomAnalyzer.called = false;
        Index<Node> index = this.nodeIndex("w-custom-analyzer-2", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "analyzer", CustomAnalyzer.class.getName(), "to_lower_case", "true", "type", "fulltext"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "The value";
        index.add((PropertyContainer)node, key, (Object)value);
        this.restartTx();
        Assert.assertTrue((boolean)CustomAnalyzer.called);
        Assert.assertThat((Object)index.query(key, (Object)"[A TO Z]"), Contains.contains(node));
    }

    @Ignore
    @Test
    public void makeSureFilesAreClosedProperly() throws Exception {
        this.commitTx();
        final Index<Node> index = this.nodeIndex("open-files", LuceneIndexImplementation.EXACT_CONFIG);
        final long time = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(30);
        int t = 0;
        while ((long)t < latch.getCount()) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int i = 0;
                    while (System.currentTimeMillis() - time < 100000L) {
                        if (i % 10 == 0) {
                            int size;
                            if (i % 100 == 0) {
                                IndexHits itr;
                                int type = (int)(System.currentTimeMillis() % 3L);
                                if (type == 0) {
                                    itr = index.get("key", (Object)"value5");
                                    try {
                                        itr.getSingle();
                                    }
                                    catch (NoSuchElementException e) {
                                        // empty catch block
                                    }
                                    size = 99;
                                } else if (type == 1) {
                                    itr = index.get("key", (Object)"value5");
                                    for (size = 0; itr.hasNext() && size < 5; ++size) {
                                        itr.next();
                                    }
                                    itr.close();
                                } else {
                                    itr = index.get("key", (Object)"crap value");
                                    if (System.currentTimeMillis() % 10L > 5L) {
                                        IteratorUtil.count((Iterator)itr);
                                    }
                                }
                                System.out.println("C iterated " + size + " only");
                            } else {
                                size = IteratorUtil.count((Iterator)index.get("key", (Object)"value5"));
                                System.out.println("hit size:" + size);
                            }
                        } else {
                            Transaction tx = graphDb.beginTx();
                            try {
                                for (int ii = 0; ii < 20; ++ii) {
                                    Node node = graphDb.createNode();
                                    index.add((PropertyContainer)node, "key", (Object)("value" + ii));
                                }
                                tx.success();
                            }
                            finally {
                                tx.finish();
                            }
                        }
                        ++i;
                    }
                    latch.countDown();
                }
            }.start();
            ++t;
        }
        latch.await();
    }

    @Test
    public void makeSureIndexNameAndConfigCanBeReachedFromIndex() {
        String indexName = "my-index-1";
        Index<Node> nodeIndex = this.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        Assert.assertEquals((Object)indexName, (Object)nodeIndex.getName());
        Assert.assertEquals((Object)LuceneIndexImplementation.EXACT_CONFIG, (Object)graphDb.index().getConfiguration(nodeIndex));
        String indexName2 = "my-index-2";
        RelationshipIndex relIndex = this.relationshipIndex(indexName2, LuceneIndexImplementation.FULLTEXT_CONFIG);
        Assert.assertEquals((Object)indexName2, (Object)relIndex.getName());
        Assert.assertEquals((Object)LuceneIndexImplementation.FULLTEXT_CONFIG, (Object)graphDb.index().getConfiguration((Index)relIndex));
    }

    @Test
    public void testStringQueryVsQueryObject() throws IOException {
        Index<Node> index = this.nodeIndex("query-diff", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "name", (Object)"Mattias Persson");
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query((Object)"name:Mattias AND name:Per*"), new Node[]{node});
            Neo4jTestCase.assertContains(index.query((Object)"name:mattias"), new Node[]{node});
            Neo4jTestCase.assertContains(index.query((Object)new TermQuery(new Term("name", "mattias"))), new Node[]{node});
            this.restartTx();
        }
        Assert.assertNull((Object)index.query((Object)new TermQuery(new Term("name", "Mattias"))).getSingle());
    }

    private <T extends PropertyContainer> void testAbandonedIds(EntityCreator<T> creator, Index<T> index) {
        T a = creator.create(new Object[0]);
        T b = creator.create(new Object[0]);
        T c = creator.create(new Object[0]);
        String key = "name";
        String value = "value";
        index.add(a, key, (Object)value);
        index.add(b, key, (Object)value);
        index.add(c, key, (Object)value);
        this.restartTx();
        creator.delete(b);
        this.restartTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
        this.rollbackTx();
        this.beginTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
        index.add(c, "something", (Object)"whatever");
        this.restartTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
    }

    @Test
    public void testAbandonedNodeIds() {
        this.testAbandonedIds(NODE_CREATOR, this.nodeIndex("abandoned", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testAbandonedNodeIdsFulltext() {
        this.testAbandonedIds(NODE_CREATOR, this.nodeIndex("abandonedf", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testAbandonedRelIds() {
        this.testAbandonedIds(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("abandoned", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testAbandonedRelIdsFulltext() {
        this.testAbandonedIds(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("abandonedf", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void makeSureYouCanRemoveFromRelationshipIndex() {
        Node n1 = graphDb.createNode();
        Node n2 = graphDb.createNode();
        Relationship r = n1.createRelationshipTo(n2, (RelationshipType)DynamicRelationshipType.withName((String)"foo"));
        RelationshipIndex index = graphDb.index().forRelationships("rel-index");
        String key = "bar";
        index.remove((PropertyContainer)r, key, (Object)"value");
        index.add((PropertyContainer)r, key, (Object)"otherValue");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)"value"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.get(key, (Object)"otherValue"), Contains.contains(r));
            this.restartTx();
        }
    }

    @Test
    public void makeSureYouCanGetEntityTypeFromIndex() {
        Index<Node> nodeIndex = this.nodeIndex("type-test", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        RelationshipIndex relIndex = this.relationshipIndex("type-test", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        Assert.assertEquals(Node.class, (Object)nodeIndex.getEntityType());
        Assert.assertEquals(Relationship.class, (Object)relIndex.getEntityType());
    }

    @Test
    public void makeSureConfigurationCanBeModified() {
        Index<Node> index = this.nodeIndex("conf-index", LuceneIndexImplementation.EXACT_CONFIG);
        try {
            graphDb.index().setConfiguration(index, "provider", "something");
            Assert.fail((String)"Shouldn't be able to modify provider");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            graphDb.index().removeConfiguration(index, "provider");
            Assert.fail((String)"Shouldn't be able to modify provider");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String key = "my-key";
        String value = "my-value";
        String newValue = "my-new-value";
        Assert.assertNull((Object)graphDb.index().setConfiguration(index, key, value));
        Assert.assertEquals((Object)value, graphDb.index().getConfiguration(index).get(key));
        Assert.assertEquals((Object)value, (Object)graphDb.index().setConfiguration(index, key, newValue));
        Assert.assertEquals((Object)newValue, graphDb.index().getConfiguration(index).get(key));
        Assert.assertEquals((Object)newValue, (Object)graphDb.index().removeConfiguration(index, key));
        Assert.assertNull(graphDb.index().getConfiguration(index).get(key));
    }

    @Test
    public void makeSureSlightDifferencesInIndexConfigCanBeSupplied() {
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"});
        String name = "the-name";
        this.nodeIndex(name, config);
        this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"to_lower_case", "true"}));
        try {
            this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"to_lower_case", "false"}));
            Assert.fail((String)"Shouldn't be able to get index with these kinds of differences in config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"whatever", "something"}));
    }

    @Test
    public void testScoring() {
        Index<Node> index = this.nodeIndex("score-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        String key = "text";
        index.add((PropertyContainer)node1, key, (Object)"a time where no one was really awake");
        index.add((PropertyContainer)node2, key, (Object)"once upon a time there was");
        this.restartTx();
        IndexHits hits = index.query(key, (Object)new QueryContext((Object)"once upon a time was").sort(Sort.RELEVANCE));
        Node hit1 = (Node)hits.next();
        float score1 = hits.currentScore();
        Node hit2 = (Node)hits.next();
        float score2 = hits.currentScore();
        Assert.assertEquals((Object)node2, (Object)hit1);
        Assert.assertEquals((Object)node1, (Object)hit2);
        Assert.assertTrue((score1 > score2 ? 1 : 0) != 0);
    }

    @Test
    public void testTopHits() {
        RelationshipIndex index = this.relationshipIndex("topdocs", LuceneIndexImplementation.FULLTEXT_CONFIG);
        EntityCreator<Relationship> creator = RELATIONSHIP_CREATOR;
        String key = "text";
        Relationship rel1 = creator.create(key, "one two three four five six seven eight nine ten");
        Relationship rel2 = creator.create(key, "one two three four five six seven eight other things");
        Relationship rel3 = creator.create(key, "one two three four five six some thing else");
        Relationship rel4 = creator.create(key, "one two three four five what ever");
        Relationship rel5 = creator.create(key, "one two three four all that is good and bad");
        Relationship rel6 = creator.create(key, "one two three hill or something");
        Relationship rel7 = creator.create(key, "one two other time than this");
        index.add((PropertyContainer)rel2, key, rel2.getProperty(key));
        index.add((PropertyContainer)rel1, key, rel1.getProperty(key));
        index.add((PropertyContainer)rel3, key, rel3.getProperty(key));
        index.add((PropertyContainer)rel7, key, rel7.getProperty(key));
        index.add((PropertyContainer)rel5, key, rel5.getProperty(key));
        index.add((PropertyContainer)rel4, key, rel4.getProperty(key));
        index.add((PropertyContainer)rel6, key, rel6.getProperty(key));
        String query = "one two three four five six seven";
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)query).top(3).sort(Sort.RELEVANCE)), new Relationship[]{rel1, rel2, rel3});
            this.restartTx();
        }
    }

    @Test
    public void testSimilarity() {
        Index<Node> index = this.nodeIndex("similarity", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext", "similarity", DefaultSimilarity.class.getName()}));
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        Neo4jTestCase.assertContains(index.get("key", (Object)"value"), new Node[]{node});
    }

    @Test
    public void testCombinedHitsSizeProblem() {
        Index<Node> index = this.nodeIndex("size-npe", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        String key = "key";
        String value = "value";
        index.add((PropertyContainer)node1, key, (Object)value);
        index.add((PropertyContainer)node2, key, (Object)value);
        this.restartTx();
        index.add((PropertyContainer)node3, key, (Object)value);
        IndexHits hits = index.get(key, (Object)value);
        Assert.assertEquals((long)3L, (long)hits.size());
    }

    private <T extends PropertyContainer> void testRemoveWithoutKey(EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String key2 = "key2";
        String value = "value";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value);
        index.add(entity1, key2, (Object)value);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value);
        index.add(entity2, key2, (Object)value);
        this.restartTx();
        Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1, key2);
        Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key2, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyNodes() throws Exception {
        this.testRemoveWithoutKey(NODE_CREATOR, this.nodeIndex("remove-wo-k", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyRelationships() throws Exception {
        this.testRemoveWithoutKey(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-k", LuceneIndexImplementation.EXACT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyValue(EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String value1 = "value1";
        String key2 = "key2";
        String value2 = "value2";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1);
        Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity2});
        index.add(entity1, key1, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyValueNodes() throws Exception {
        this.testRemoveWithoutKeyValue(NODE_CREATOR, this.nodeIndex("remove-wo-kv", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyValueRelationships() throws Exception {
        this.testRemoveWithoutKeyValue(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-kv", LuceneIndexImplementation.EXACT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyFulltext(EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String key2 = "key2";
        String value1 = "value one";
        String value2 = "other value";
        String value = "value";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1, key2);
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key2, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyFulltextNode() throws Exception {
        this.testRemoveWithoutKeyFulltext(NODE_CREATOR, this.nodeIndex("remove-wo-k-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyFulltextRelationship() throws Exception {
        this.testRemoveWithoutKeyFulltext(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-k-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyValueFulltext(EntityCreator<T> creator, Index<T> index) throws Exception {
        String value = "value";
        String key1 = "key1";
        String value1 = value + " one";
        String key2 = "key2";
        String value2 = value + " two";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1);
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key1, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyValueFulltextNode() throws Exception {
        this.testRemoveWithoutKeyValueFulltext(NODE_CREATOR, this.nodeIndex("remove-wo-kv-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyValueFulltextRelationship() throws Exception {
        this.testRemoveWithoutKeyValueFulltext(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-kv-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testSortingWithTopHitsInPartCommittedPartLocal() {
        Index<Node> index = this.nodeIndex("mix", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node first = graphDb.createNode();
        Node second = graphDb.createNode();
        Node third = graphDb.createNode();
        Node fourth = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)third, key, (Object)"ccc");
        index.add((PropertyContainer)second, key, (Object)"bbb");
        this.restartTx();
        index.add((PropertyContainer)fourth, key, (Object)"ddd");
        index.add((PropertyContainer)first, key, (Object)"aaa");
        Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)"*").sort(key, new String[0])), new Node[]{first, second, third, fourth});
        Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)"*").sort(key, new String[0]).top(2)), new Node[]{first, second});
    }

    static {
        TEST_TYPE = DynamicRelationshipType.withName((String)"TEST_TYPE");
        NODE_CREATOR = new EntityCreator<Node>(){

            @Override
            public Node create(Object ... properties) {
                Node node = graphDb.createNode();
                TestLuceneIndex.setProperties((PropertyContainer)node, properties);
                return node;
            }

            @Override
            public void delete(Node entity) {
                entity.delete();
            }
        };
        RELATIONSHIP_CREATOR = new EntityCreator<Relationship>(){

            @Override
            public Relationship create(Object ... properties) {
                Relationship rel = graphDb.createNode().createRelationshipTo(graphDb.createNode(), TEST_TYPE);
                TestLuceneIndex.setProperties((PropertyContainer)rel, properties);
                return rel;
            }

            @Override
            public void delete(Relationship entity) {
                entity.delete();
            }
        };
    }

    static class FastRelationshipCreator
    implements EntityCreator<Relationship> {
        private Node node;
        private Node otherNode;

        FastRelationshipCreator() {
        }

        @Override
        public Relationship create(Object ... properties) {
            if (this.node == null) {
                this.node = graphDb.createNode();
                this.otherNode = graphDb.createNode();
            }
            Relationship rel = this.node.createRelationshipTo(this.otherNode, TEST_TYPE);
            TestLuceneIndex.setProperties((PropertyContainer)rel, properties);
            return rel;
        }

        @Override
        public void delete(Relationship entity) {
            entity.delete();
        }
    }

    private static interface EntityCreator<T extends PropertyContainer> {
        public T create(Object ... var1);

        public void delete(T var1);
    }
}

