/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.BaseWorker;
import org.neo4j.index.impl.lucene.BeginTransactionCommand;
import org.neo4j.index.impl.lucene.CommitCommand;
import org.neo4j.index.impl.lucene.CreateNodeAndIndexByCommand;
import org.neo4j.index.impl.lucene.DeleteIndexCommand;
import org.neo4j.index.impl.lucene.DieCommand;
import org.neo4j.index.impl.lucene.QueryIndexCommand;
import org.neo4j.index.impl.lucene.RemoveFromIndexCommand;
import org.neo4j.index.impl.lucene.RollbackCommand;

public class WorkThread
extends BaseWorker {
    public WorkThread(Index<Node> index, GraphDatabaseService graphDb) {
        super(index, graphDb);
    }

    public void createNodeAndIndexBy(String key, String value) {
        this.queueCommand(new CreateNodeAndIndexByCommand(key, value));
    }

    public void deleteIndex() {
        this.queueCommand(new DeleteIndexCommand());
    }

    public IndexHits<Node> queryIndex(String key, Object value) {
        QueryIndexCommand cmd = new QueryIndexCommand(key, value);
        this.queueCommand(cmd);
        return cmd.getResult();
    }

    public void commit() {
        this.queueCommand(new CommitCommand());
    }

    public void beginTransaction() {
        this.queueCommand(new BeginTransactionCommand());
    }

    public void removeFromIndex(String key, String value) {
        this.queueCommand(new RemoveFromIndexCommand(key, value));
    }

    public void rollback() {
        this.queueCommand(new RollbackCommand());
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public void die() {
        this.queueCommand(new DieCommand());
    }
}

