/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.AutoIndexer;
import org.neo4j.graphdb.index.ReadableIndex;
import org.neo4j.graphdb.index.ReadableRelationshipIndex;
import org.neo4j.graphdb.index.RelationshipAutoIndexer;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestData;

public class AutoIndexerExampleTests
implements GraphHolder {
    private static final TargetDirectory target = TargetDirectory.forTest(AutoIndexerExampleTests.class);
    private static EmbeddedGraphDatabase graphdb;
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough((TestData.Producer)GraphDescription.createGraphFor((GraphHolder)this, (boolean)true));

    private String getStoreDir(String testName) throws IOException {
        File base = new File("target", "example-auto-index");
        FileUtils.deleteRecursively((File)base);
        return new File(base.getAbsolutePath(), testName).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfig() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("node_keys_indexable", "nodeProp1, nodeProp2");
        config.put("relationship_keys_indexable", "relProp1, relProp2");
        config.put("node_auto_indexing", "true");
        config.put("relationship_auto_indexing", "true");
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(this.getStoreDir("testConfig"), config);
        Transaction tx = graphDb.beginTx();
        Node node1 = null;
        Node node2 = null;
        Relationship rel = null;
        try {
            node1 = graphDb.createNode();
            node2 = graphDb.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"DYNAMIC"));
            node1.setProperty("nodeProp1", (Object)"nodeProp1Value");
            node2.setProperty("nodeProp2", (Object)"nodeProp2Value");
            node1.setProperty("nonIndexed", (Object)"nodeProp2NonIndexedValue");
            rel.setProperty("relProp1", (Object)"relProp1Value");
            rel.setProperty("relPropNonIndexed", (Object)"relPropValueNonIndexed");
            tx.success();
        }
        catch (Exception e) {
            tx.failure();
        }
        finally {
            tx.finish();
        }
        ReadableIndex autoNodeIndex = graphDb.index().getNodeAutoIndexer().getAutoIndex();
        Assert.assertEquals((Object)node1, (Object)autoNodeIndex.get("nodeProp1", (Object)"nodeProp1Value").getSingle());
        Assert.assertEquals((Object)node2, (Object)autoNodeIndex.get("nodeProp2", (Object)"nodeProp2Value").getSingle());
        Assert.assertFalse((boolean)autoNodeIndex.get("nonIndexed", (Object)"nodeProp2NonIndexedValue").hasNext());
        ReadableRelationshipIndex autoRelIndex = graphDb.index().getRelationshipAutoIndexer().getAutoIndex();
        Assert.assertEquals((Object)rel, (Object)autoRelIndex.get("relProp1", (Object)"relProp1Value").getSingle());
        Assert.assertFalse((boolean)autoRelIndex.get("relPropNonIndexed", (Object)"relPropValueNonIndexed").hasNext());
        graphDb.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAPI() throws Exception {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(this.getStoreDir("testAPI"));
        AutoIndexer nodeAutoIndexer = graphDb.index().getNodeAutoIndexer();
        nodeAutoIndexer.startAutoIndexingProperty("nodeProp1");
        nodeAutoIndexer.startAutoIndexingProperty("nodeProp2");
        RelationshipAutoIndexer relAutoIndexer = graphDb.index().getRelationshipAutoIndexer();
        relAutoIndexer.startAutoIndexingProperty("relProp1");
        nodeAutoIndexer.setEnabled(true);
        relAutoIndexer.setEnabled(true);
        Transaction tx = graphDb.beginTx();
        Node node1 = null;
        Node node2 = null;
        Relationship rel = null;
        try {
            node1 = graphDb.createNode();
            node2 = graphDb.createNode();
            rel = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"DYNAMIC"));
            node1.setProperty("nodeProp1", (Object)"nodeProp1Value");
            node2.setProperty("nodeProp2", (Object)"nodeProp2Value");
            node1.setProperty("nonIndexed", (Object)"nodeProp2NonIndexedValue");
            rel.setProperty("relProp1", (Object)"relProp1Value1");
            rel.setProperty("relPropNonIndexed", (Object)"relProp1Value2");
            tx.success();
        }
        catch (Exception e) {
            tx.failure();
        }
        finally {
            tx.finish();
        }
        ReadableIndex autoNodeIndex = nodeAutoIndexer.getAutoIndex();
        Assert.assertEquals((Object)node1, (Object)autoNodeIndex.get("nodeProp1", (Object)"nodeProp1Value").getSingle());
        Assert.assertEquals((Object)node2, (Object)autoNodeIndex.get("nodeProp2", (Object)"nodeProp2Value").getSingle());
        Assert.assertFalse((boolean)autoNodeIndex.get("nonIndexed", (Object)"nodeProp2NonIndexedValue").hasNext());
        ReadableIndex autoRelIndex = relAutoIndexer.getAutoIndex();
        Assert.assertEquals((Object)rel, (Object)autoRelIndex.get("relProp1", (Object)"relProp1Value1").getSingle());
        Assert.assertFalse((boolean)autoRelIndex.get("relPropNonIndexed", (Object)"relProp1Value2").hasNext());
        graphDb.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMutations() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("node_keys_indexable", "nodeProp1, nodeProp2");
        config.put("node_auto_indexing", "true");
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(this.getStoreDir("mutations"), config);
        Transaction tx = graphDb.beginTx();
        Node node1 = null;
        Node node2 = null;
        Node node3 = null;
        Node node4 = null;
        try {
            node1 = graphDb.createNode();
            node2 = graphDb.createNode();
            node3 = graphDb.createNode();
            node4 = graphDb.createNode();
            node1.setProperty("nodeProp1", (Object)"nodeProp1Value");
            node2.setProperty("nodeProp2", (Object)"nodeProp2Value");
            node3.setProperty("nodeProp1", (Object)"nodeProp3Value");
            node4.setProperty("nodeProp2", (Object)"nodeProp4Value");
            tx.success();
        }
        catch (Exception e) {
            tx.failure();
        }
        finally {
            tx.finish();
        }
        AutoIndexer nodeAutoIndexer = graphDb.index().getNodeAutoIndexer();
        nodeAutoIndexer.stopAutoIndexingProperty("nodeProp1");
        tx = graphDb.beginTx();
        try {
            node1.setProperty("nodeProp1", (Object)"nodeProp1Value2");
            node2.setProperty("nodeProp2", (Object)"nodeProp2Value2");
            node4.removeProperty("nodeProp2");
            tx.success();
        }
        catch (Exception e) {
            tx.failure();
        }
        finally {
            tx.finish();
        }
        ReadableIndex nodeAutoIndex = nodeAutoIndexer.getAutoIndex();
        Assert.assertFalse((boolean)nodeAutoIndex.get("nodeProp1", (Object)"nodeProp1Value").hasNext());
        Assert.assertFalse((boolean)nodeAutoIndex.get("nodeProp1", (Object)"nodeProp1Value2").hasNext());
        Assert.assertFalse((boolean)nodeAutoIndex.get("nodeProp2", (Object)"nodeProp2Value").hasNext());
        Assert.assertEquals((Object)node2, (Object)nodeAutoIndex.get("nodeProp2", (Object)"nodeProp2Value2").getSingle());
        Assert.assertEquals((Object)node3, (Object)nodeAutoIndex.get("nodeProp1", (Object)"nodeProp3Value").getSingle());
        Assert.assertFalse((boolean)nodeAutoIndex.get("nodeProp2", (Object)"nodeProp4Value").hasNext());
    }

    @Test
    @GraphDescription.Graph(autoIndexNodes=true, autoIndexRelationships=true, value={"I know you"})
    public void canCreateMoreInvolvedGraphWithPropertiesAndAutoIndex() throws Exception {
        GraphDatabaseService graphDatabase = ((Node)((Map)this.data.get()).values().iterator().next()).getGraphDatabase();
        Assert.assertTrue((String)"node autoindex Nodes not enabled.", (boolean)graphDatabase.index().getNodeAutoIndexer().isEnabled());
        Assert.assertTrue((String)"node autoindex Rels not enabled.", (boolean)graphDatabase.index().getRelationshipAutoIndexer().isEnabled());
    }

    @BeforeClass
    public static void startDatabase() {
        graphdb = new EmbeddedGraphDatabase(target.graphDbDir(true).getAbsolutePath());
    }

    @AfterClass
    public static void stopDatabase() {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    public GraphDatabaseService graphdb() {
        return graphdb;
    }
}

