/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.BatchInserterIndex;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.LuceneBatchInserterIndexProvider;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;

public class ImdbExampleTest {
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void setUpDb() {
        Neo4jTestCase.deleteFileOrDirectory(new File("target/graphdb"));
        graphDb = new EmbeddedGraphDatabase("target/graphdb");
        Transaction transaction = graphDb.beginTx();
        try {
            IndexManager index = graphDb.index();
            Index actors = index.forNodes("actors");
            Index movies = index.forNodes("movies");
            RelationshipIndex roles = index.forRelationships("roles");
            Node reeves = graphDb.createNode();
            actors.add((PropertyContainer)reeves, "name", (Object)"Keanu Reeves");
            Node bellucci = graphDb.createNode();
            actors.add((PropertyContainer)bellucci, "name", (Object)"Monica Bellucci");
            actors.add((PropertyContainer)bellucci, "name", (Object)"La Bellucci");
            Node theMatrix = graphDb.createNode();
            movies.add((PropertyContainer)theMatrix, "title", (Object)"The Matrix");
            movies.add((PropertyContainer)theMatrix, "year", (Object)1999);
            Node theMatrixReloaded = graphDb.createNode();
            movies.add((PropertyContainer)theMatrixReloaded, "title", (Object)"The Matrix Reloaded");
            movies.add((PropertyContainer)theMatrixReloaded, "year", (Object)2003);
            Node malena = graphDb.createNode();
            movies.add((PropertyContainer)malena, "title", (Object)"Mal\u00e8na");
            movies.add((PropertyContainer)malena, "year", (Object)2000);
            reeves.setProperty("name", (Object)"Keanu Reeves");
            bellucci.setProperty("name", (Object)"Monica Bellucci");
            theMatrix.setProperty("title", (Object)"The Matrix");
            theMatrix.setProperty("year", (Object)1999);
            theMatrixReloaded.setProperty("title", (Object)"The Matrix Reloaded");
            theMatrixReloaded.setProperty("year", (Object)2003);
            malena.setProperty("title", (Object)"Mal\u00e8na");
            malena.setProperty("year", (Object)2000);
            DynamicRelationshipType ACTS_IN = DynamicRelationshipType.withName((String)"ACTS_IN");
            Relationship role1 = reeves.createRelationshipTo(theMatrix, (RelationshipType)ACTS_IN);
            roles.add((PropertyContainer)role1, "name", (Object)"Neo");
            Relationship role2 = reeves.createRelationshipTo(theMatrixReloaded, (RelationshipType)ACTS_IN);
            roles.add((PropertyContainer)role2, "name", (Object)"Neo");
            Relationship role3 = bellucci.createRelationshipTo(theMatrixReloaded, (RelationshipType)ACTS_IN);
            roles.add((PropertyContainer)role3, "name", (Object)"Persephone");
            Relationship role4 = bellucci.createRelationshipTo(malena, (RelationshipType)ACTS_IN);
            roles.add((PropertyContainer)role4, "name", (Object)"Mal\u00e8na Scordia");
            role1.setProperty("name", (Object)"Neo");
            role2.setProperty("name", (Object)"Neo");
            role3.setProperty("name", (Object)"Persephone");
            role4.setProperty("name", (Object)"Mal\u00e8na Scordia");
            transaction.success();
        }
        finally {
            transaction.finish();
        }
    }

    @AfterClass
    public static void tearDownDb() {
        graphDb.shutdown();
    }

    @Before
    public void beginTx() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void finishTx() {
        this.tx.finish();
    }

    private void rollbackTx() {
        this.finishTx();
        this.beginTx();
    }

    @Test
    public void checkIfIndexExists() {
        IndexManager index = graphDb.index();
        boolean indexExists = index.existsForNodes("actors");
        Assert.assertTrue((boolean)indexExists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void deleteIndex() {
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase("target/graphdb-delete");
        Transaction transaction = graphDb.beginTx();
        try {
            IndexManager index = graphDb.index();
            Index actors = index.forNodes("actors");
            actors.delete();
            transaction.success();
        }
        finally {
            transaction.finish();
        }
        Assert.assertFalse((boolean)graphDb.index().existsForNodes("actors"));
        graphDb.shutdown();
    }

    @Test
    public void removeFromIndex() {
        IndexManager index = graphDb.index();
        Index actors = index.forNodes("actors");
        Node bellucci = (Node)actors.get("name", (Object)"Monica Bellucci").getSingle();
        Assert.assertNotNull((Object)bellucci);
        actors.remove((PropertyContainer)bellucci);
        Node node = (Node)actors.get("name", (Object)"Monica Bellucci").getSingle();
        Assert.assertEquals(null, (Object)node);
        node = (Node)actors.get("name", (Object)"La Bellucci").getSingle();
        Assert.assertEquals(null, (Object)node);
        this.rollbackTx();
        actors.remove((PropertyContainer)bellucci, "name");
        node = (Node)actors.get("name", (Object)"Monica Bellucci").getSingle();
        Assert.assertEquals(null, (Object)node);
        node = (Node)actors.get("name", (Object)"La Bellucci").getSingle();
        Assert.assertEquals(null, (Object)node);
        this.rollbackTx();
        actors.remove((PropertyContainer)bellucci, "name", (Object)"La Bellucci");
        node = (Node)actors.get("name", (Object)"La Bellucci").getSingle();
        Assert.assertEquals(null, (Object)node);
        node = (Node)actors.get("name", (Object)"Monica Bellucci").getSingle();
        Assert.assertEquals((Object)bellucci, (Object)node);
    }

    @Test
    public void update() {
        IndexManager index = graphDb.index();
        Index actors = index.forNodes("actors");
        Node fishburn = graphDb.createNode();
        fishburn.setProperty("name", (Object)"Fishburn");
        actors.add((PropertyContainer)fishburn, "name", fishburn.getProperty("name"));
        Node node = (Node)actors.get("name", (Object)"Fishburn").getSingle();
        Assert.assertEquals((Object)fishburn, (Object)node);
        actors.remove((PropertyContainer)fishburn, "name", fishburn.getProperty("name"));
        fishburn.setProperty("name", (Object)"Laurence Fishburn");
        actors.add((PropertyContainer)fishburn, "name", fishburn.getProperty("name"));
        node = (Node)actors.get("name", (Object)"Fishburn").getSingle();
        Assert.assertEquals(null, (Object)node);
        node = (Node)actors.get("name", (Object)"Laurence Fishburn").getSingle();
        Assert.assertEquals((Object)fishburn, (Object)node);
    }

    @Test
    public void doGetForNodes() {
        Index actors = graphDb.index().forNodes("actors");
        IndexHits hits = actors.get("name", (Object)"Keanu Reeves");
        Node reeves = (Node)hits.getSingle();
        Assert.assertEquals((Object)"Keanu Reeves", (Object)reeves.getProperty("name"));
    }

    @Test
    public void doGetForRelationships() {
        RelationshipIndex roles = graphDb.index().forRelationships("roles");
        Relationship persephone = (Relationship)roles.get("name", (Object)"Persephone").getSingle();
        Node actor = persephone.getStartNode();
        Node movie = persephone.getEndNode();
        Assert.assertEquals((Object)"Monica Bellucci", (Object)actor.getProperty("name"));
        Assert.assertEquals((Object)"The Matrix Reloaded", (Object)movie.getProperty("title"));
        ArrayList<String> expectedActors = new ArrayList<String>(){
            {
                this.add("Keanu Reeves");
                this.add("Keanu Reeves");
            }
        };
        ArrayList<String> foundActors = new ArrayList<String>();
        for (Relationship role : roles.get("name", (Object)"Neo")) {
            Node reeves = role.getStartNode();
            foundActors.add((String)reeves.getProperty("name"));
        }
        Assert.assertEquals((Object)expectedActors, foundActors);
    }

    @Test
    public void doQueriesForNodes() {
        IndexManager index = graphDb.index();
        Index actors = index.forNodes("actors");
        Index movies = index.forNodes("movies");
        HashSet<String> found = new HashSet<String>();
        HashSet<String> expectedActors = new HashSet<String>(){
            {
                this.add("Monica Bellucci");
                this.add("Keanu Reeves");
            }
        };
        HashSet<String> expectedMovies = new HashSet<String>(){
            {
                this.add("The Matrix");
            }
        };
        for (Node actor : actors.query("name", (Object)"*e*")) {
            found.add((String)actor.getProperty("name"));
        }
        Assert.assertEquals((Object)expectedActors, found);
        found.clear();
        for (Node movie : movies.query((Object)"title:*Matrix* AND year:1999")) {
            found.add((String)movie.getProperty("title"));
        }
        Assert.assertEquals((Object)expectedMovies, found);
        Node matrix = (Node)movies.query((Object)"title:*Matrix* AND year:2003").getSingle();
        Assert.assertEquals((Object)"The Matrix Reloaded", (Object)matrix.getProperty("title"));
        IndexHits hits = movies.query("title", (Object)"The*");
        for (Node movie : hits) {
            System.out.println(movie.getProperty("title") + " " + hits.currentScore());
            Assert.assertTrue((boolean)((String)movie.getProperty("title")).startsWith("The"));
        }
        Assert.assertEquals((long)2L, (long)hits.size());
        hits = movies.query("title", (Object)new QueryContext((Object)"The*").sortByScore());
        float previous = Float.MAX_VALUE;
        for (Node movie : hits) {
            Assert.assertTrue((hits.currentScore() <= previous ? 1 : 0) != 0);
            previous = hits.currentScore();
        }
        Assert.assertEquals((long)2L, (long)hits.size());
        Node actor = (Node)actors.query((Object)new TermQuery(new Term("name", "Keanu Reeves"))).getSingle();
        Assert.assertEquals((Object)"Keanu Reeves", (Object)actor.getProperty("name"));
        Node theMatrix = (Node)movies.get("title", (Object)"The Matrix").getSingle();
        Node theMatrixReloaded = (Node)movies.get("title", (Object)"The Matrix Reloaded").getSingle();
        Node malena = (Node)movies.get("title", (Object)"Mal\u00e8na").getSingle();
        hits = movies.query((Object)new WildcardQuery(new Term("title", "The Matrix*")));
        for (Node movie : hits) {
            System.out.println(movie.getProperty("title"));
            Assert.assertTrue((boolean)((String)movie.getProperty("title")).startsWith("The Matrix"));
        }
        Assert.assertEquals((long)2L, (long)hits.size());
        movies.add((PropertyContainer)theMatrix, "year-numeric", (Object)new ValueContext((Object)1999).indexNumeric());
        movies.add((PropertyContainer)theMatrixReloaded, "year-numeric", (Object)new ValueContext((Object)2003).indexNumeric());
        movies.add((PropertyContainer)malena, "year-numeric", (Object)new ValueContext((Object)2000).indexNumeric());
        int from = 1997;
        int to = 1999;
        hits = movies.query((Object)QueryContext.numericRange((String)"year-numeric", (Number)from, (Number)to));
        Assert.assertEquals((Object)theMatrix, (Object)hits.getSingle());
        hits = movies.query((Object)QueryContext.numericRange((String)"year-numeric", (Number)from, null).sortNumeric("year-numeric", false));
        ArrayList<String> sortedMovies = new ArrayList<String>();
        ArrayList<String> expectedSortedMovies = new ArrayList<String>(){
            {
                this.add("The Matrix");
                this.add("Mal\u00e8na");
                this.add("The Matrix Reloaded");
            }
        };
        for (Node hit : hits) {
            sortedMovies.add((String)hit.getProperty("title"));
        }
        Assert.assertEquals((Object)expectedSortedMovies, sortedMovies);
        movies.add((PropertyContainer)theMatrix, "score", (Object)new ValueContext((Object)8.7).indexNumeric());
        movies.add((PropertyContainer)theMatrixReloaded, "score", (Object)new ValueContext((Object)7.1).indexNumeric());
        movies.add((PropertyContainer)malena, "score", (Object)new ValueContext((Object)7.4).indexNumeric());
        hits = movies.query((Object)QueryContext.numericRange((String)"score", (Number)8.0, (Number)9.0, (boolean)true, (boolean)false));
        found.clear();
        for (Node hit : hits) {
            found.add((String)hit.getProperty("title"));
        }
        Assert.assertEquals((Object)expectedMovies, found);
        hits = movies.query((Object)"title:*Matrix* AND year:1999");
        Assert.assertEquals((Object)theMatrix, (Object)hits.getSingle());
        QueryContext query = new QueryContext((Object)"title:*Matrix* year:1999").defaultOperator(QueryParser.Operator.AND);
        hits = movies.query((Object)query);
        Assert.assertEquals((long)1L, (long)hits.size());
        hits = movies.query("title", (Object)new QueryContext((Object)"*").sort("title", new String[0]));
        for (Node hit : hits) {
        }
        Assert.assertEquals((long)3L, (long)hits.size());
        hits = movies.query((Object)new QueryContext((Object)"title:*").sort("year", new String[]{"title"}));
        for (Node hit : hits) {
        }
        Assert.assertEquals((long)3L, (long)hits.size());
    }

    @Test
    public void doQueriesForRelationships() {
        IndexManager index = graphDb.index();
        RelationshipIndex roles = index.forRelationships("roles");
        Index actors = graphDb.index().forNodes("actors");
        Index movies = index.forNodes("movies");
        Node reeves = (Node)actors.get("name", (Object)"Keanu Reeves").getSingle();
        Node theMatrix = (Node)movies.get("title", (Object)"The Matrix").getSingle();
        IndexHits reevesAsNeoHits = roles.get("name", (Object)"Neo", reeves, null);
        Relationship reevesAsNeo = (Relationship)reevesAsNeoHits.iterator().next();
        reevesAsNeoHits.close();
        Assert.assertEquals((Object)"Neo", (Object)reevesAsNeo.getProperty("name"));
        Node actor = reevesAsNeo.getStartNode();
        Assert.assertEquals((Object)reeves, (Object)actor);
        IndexHits matrixNeoHits = roles.query("name", (Object)"*eo", null, theMatrix);
        Relationship matrixNeo = (Relationship)matrixNeoHits.iterator().next();
        matrixNeoHits.close();
        Assert.assertEquals((Object)"Neo", (Object)matrixNeo.getProperty("name"));
        actor = matrixNeo.getStartNode();
        Assert.assertEquals((Object)reeves, (Object)actor);
        roles.add((PropertyContainer)reevesAsNeo, "type", (Object)reevesAsNeo.getType().name());
        this.tx.success();
        this.tx.finish();
        IndexHits typeHits = roles.query((Object)"type:ACTS_IN AND name:Neo", null, theMatrix);
        Relationship typeNeo = (Relationship)typeHits.iterator().next();
        typeHits.close();
        Assert.assertEquals((Object)"Neo", (Object)typeNeo.getProperty("name"));
        actor = matrixNeo.getStartNode();
        Assert.assertEquals((Object)reeves, (Object)actor);
    }

    @Test
    public void fulltext() {
        IndexManager index = graphDb.index();
        Index fulltextMovies = index.forNodes("movies-fulltext", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
        Index movies = index.forNodes("movies");
        Node theMatrix = (Node)movies.get("title", (Object)"The Matrix").getSingle();
        Node theMatrixReloaded = (Node)movies.get("title", (Object)"The Matrix Reloaded").getSingle();
        fulltextMovies.add((PropertyContainer)theMatrix, "title", (Object)"The Matrix");
        fulltextMovies.add((PropertyContainer)theMatrixReloaded, "title", (Object)"The Matrix Reloaded");
        Node found = (Node)fulltextMovies.query("title", (Object)"reloAdEd").getSingle();
        Assert.assertEquals((Object)theMatrixReloaded, (Object)found);
    }

    @Test
    public void cacheSettings() {
        Index index = graphDb.index().forNodes("actors");
        ((LuceneIndex)index).setCacheCapacity("name", 300000);
    }

    @Test
    public void batchInsert() {
        Neo4jTestCase.deleteFileOrDirectory(new File("target/neo4jdb-batchinsert"));
        BatchInserterImpl inserter = new BatchInserterImpl("target/neo4jdb-batchinsert");
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex actors = indexProvider.nodeIndex("actors", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
        actors.setCacheCapacity("name", 100000);
        Map properties = MapUtil.map((Object[])new Object[]{"name", "Keanu Reeves"});
        long node = inserter.createNode(properties);
        actors.add(node, properties);
        actors.flush();
        indexProvider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase("target/neo4jdb-batchinsert");
        Index index = db.index().forNodes("actors");
        Node reeves = (Node)index.get("name", (Object)"Keanu Reeves").next();
        Assert.assertEquals((long)node, (long)reeves.getId());
        db.shutdown();
    }
}

