/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.util.FileUtils;

public class IndexConstraintsTest {
    private File testNeoDir = new File("target/dbIdxConstraints");
    private GraphDatabaseService graphDb;

    @Before
    public void setup() throws IOException {
        if (this.testNeoDir.exists()) {
            FileUtils.deleteRecursively((File)this.testNeoDir);
        }
        this.graphDb = new EmbeddedGraphDatabase(this.testNeoDir.getAbsolutePath());
    }

    @After
    public void shutdown() throws IOException {
        this.graphDb.shutdown();
        FileUtils.deleteRecursively((File)this.testNeoDir);
    }

    @Test
    public void testMultipleCreate() throws InterruptedException {
        int numThreads = 25;
        final String uuid = UUID.randomUUID().toString();
        ExecutorCompletionService<Node> ecs = new ExecutorCompletionService<Node>(Executors.newFixedThreadPool(25));
        for (int i = 0; i < 25; ++i) {
            ecs.submit(new Callable<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Node call() throws Exception {
                    Transaction tx = IndexConstraintsTest.this.graphDb.beginTx();
                    try {
                        Node node = IndexConstraintsTest.this.graphDb.createNode();
                        IndexConstraintsTest.this.graphDb.getReferenceNode().removeProperty("NOT_EXISTING");
                        Index index = IndexConstraintsTest.this.graphDb.index().forNodes("uuids");
                        Node existing = (Node)index.get("uuid", (Object)uuid).getSingle();
                        if (existing != null) {
                            throw new RuntimeException("Node already exists");
                        }
                        node.setProperty("uuid", (Object)uuid);
                        index.add((PropertyContainer)node, "uuid", (Object)uuid);
                        tx.success();
                        Node node2 = node;
                        return node2;
                    }
                    finally {
                        tx.finish();
                    }
                }
            });
        }
        int numSucceeded = 0;
        for (int i = 0; i < 25; ++i) {
            try {
                ecs.take().get();
                ++numSucceeded;
                continue;
            }
            catch (ExecutionException e) {
                // empty catch block
            }
        }
        Assert.assertEquals((long)1L, (long)numSucceeded);
    }
}

