/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public abstract class Neo4jTestCase {
    private static File basePath = new File("target/var");
    private static File dbPath = new File(basePath, "neo4j-db");
    private static GraphDatabaseService graphDb;
    private Transaction tx;

    @BeforeClass
    public static void setUpDb() throws Exception {
        Neo4jTestCase.deleteFileOrDirectory(dbPath);
        graphDb = new EmbeddedGraphDatabase(dbPath.getAbsolutePath());
    }

    @Before
    public void setUpTest() {
        this.tx = graphDb.beginTx();
    }

    @After
    public void tearDownTest() {
        if (!this.manageMyOwnTxFinish()) {
            this.finishTx(true);
        }
    }

    protected boolean manageMyOwnTxFinish() {
        return false;
    }

    protected void finishTx(boolean commit) {
        if (this.tx == null) {
            return;
        }
        if (commit) {
            this.tx.success();
        }
        this.tx.finish();
        this.tx = null;
    }

    protected Transaction beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
        return this.tx;
    }

    @AfterClass
    public static void tearDownDb() throws Exception {
        graphDb.shutdown();
    }

    protected void beforeShutdown() {
    }

    protected File getBasePath() {
        return basePath;
    }

    protected File getDbPath() {
        return dbPath;
    }

    public static void deleteFileOrDirectory(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Neo4jTestCase.deleteFileOrDirectory(child);
            }
        }
        file.delete();
    }

    protected void restartTx() {
        this.restartTx(true);
    }

    protected void restartTx(boolean success) {
        if (success) {
            this.tx.success();
        } else {
            this.tx.failure();
        }
        this.tx.finish();
        this.tx = graphDb.beginTx();
    }

    protected static GraphDatabaseService graphDb() {
        return graphDb;
    }

    public static <T> void assertContains(Collection<T> collection, T ... expectedItems) {
        String collectionString = Neo4jTestCase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        for (T item : expectedItems) {
            Assert.assertTrue((boolean)collection.contains(item));
        }
    }

    public static <T> void assertContains(Iterable<T> items, T ... expectedItems) {
        Neo4jTestCase.assertContains(Neo4jTestCase.asCollection(items), expectedItems);
    }

    public static <T> void assertContainsInOrder(Collection<T> collection, T ... expectedItems) {
        String collectionString = Neo4jTestCase.join(", ", collection.toArray());
        Assert.assertEquals((String)collectionString, (long)expectedItems.length, (long)collection.size());
        Iterator<T> itr = collection.iterator();
        int i = 0;
        while (itr.hasNext()) {
            Assert.assertEquals(expectedItems[i], itr.next());
            ++i;
        }
    }

    public static <T> void assertContainsInOrder(Iterable<T> collection, T ... expectedItems) {
        Neo4jTestCase.assertContainsInOrder(Neo4jTestCase.asCollection(collection), expectedItems);
    }

    public static <T> Collection<T> asCollection(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> String join(String delimiter, T ... items) {
        StringBuffer buffer = new StringBuffer();
        for (T item : items) {
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(item.toString());
        }
        return buffer.toString();
    }

    protected <T> int countIterable(Iterable<T> iterable) {
        int counter = 0;
        Iterator<T> itr = iterable.iterator();
        while (itr.hasNext()) {
            itr.next();
            ++counter;
        }
        return counter;
    }
}

