/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.util.Map;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public abstract class AbstractLuceneIndexTest {
    protected static GraphDatabaseService graphDb;
    protected Transaction tx;
    private static final RelationshipType TEST_TYPE;
    protected static final EntityCreator<Node> NODE_CREATOR;
    protected static final EntityCreator<Relationship> RELATIONSHIP_CREATOR;

    @BeforeClass
    public static void setUpStuff() {
        String storeDir = "target/var/freshindex";
        Neo4jTestCase.deleteFileOrDirectory(new File(storeDir));
        graphDb = new EmbeddedGraphDatabase(storeDir);
    }

    @AfterClass
    public static void tearDownStuff() {
        graphDb.shutdown();
    }

    @After
    public void commitTx() {
        this.finishTx(true);
    }

    public void rollbackTx() {
        this.finishTx(false);
    }

    public void finishTx(boolean success) {
        if (this.tx != null) {
            if (success) {
                this.tx.success();
            }
            this.tx.finish();
            this.tx = null;
        }
    }

    @Before
    public void beginTx() {
        if (this.tx == null) {
            this.tx = graphDb.beginTx();
        }
    }

    void restartTx() {
        this.commitTx();
        this.beginTx();
    }

    private static void setProperties(PropertyContainer entity, Object ... properties) {
        for (Map.Entry entry : MapUtil.map((Object[])properties).entrySet()) {
            entity.setProperty((String)entry.getKey(), entry.getValue());
        }
    }

    protected Index<Node> nodeIndex(String name, Map<String, String> config) {
        return graphDb.index().forNodes(name, config);
    }

    protected RelationshipIndex relationshipIndex(String name, Map<String, String> config) {
        return graphDb.index().forRelationships(name, config);
    }

    static {
        TEST_TYPE = DynamicRelationshipType.withName((String)"TEST_TYPE");
        NODE_CREATOR = new EntityCreator<Node>(){

            @Override
            public Node create(Object ... properties) {
                Node node = graphDb.createNode();
                AbstractLuceneIndexTest.setProperties((PropertyContainer)node, properties);
                return node;
            }

            @Override
            public void delete(Node entity) {
                entity.delete();
            }
        };
        RELATIONSHIP_CREATOR = new EntityCreator<Relationship>(){

            @Override
            public Relationship create(Object ... properties) {
                Relationship rel = graphDb.createNode().createRelationshipTo(graphDb.createNode(), TEST_TYPE);
                AbstractLuceneIndexTest.setProperties((PropertyContainer)rel, properties);
                return rel;
            }

            @Override
            public void delete(Relationship entity) {
                entity.delete();
            }
        };
    }

    static class FastRelationshipCreator
    implements EntityCreator<Relationship> {
        private Node node;
        private Node otherNode;

        FastRelationshipCreator() {
        }

        @Override
        public Relationship create(Object ... properties) {
            if (this.node == null) {
                this.node = graphDb.createNode();
                this.otherNode = graphDb.createNode();
            }
            Relationship rel = this.node.createRelationshipTo(this.otherNode, TEST_TYPE);
            AbstractLuceneIndexTest.setProperties((PropertyContainer)rel, properties);
            return rel;
        }

        @Override
        public void delete(Relationship entity) {
            entity.delete();
        }
    }

    protected static interface EntityCreator<T extends PropertyContainer> {
        public T create(Object ... var1);

        public void delete(T var1);
    }
}

