/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.IteratorUtil;

public class Contains<T>
extends TypeSafeMatcher<IndexHits<T>> {
    private T[] expectedItems;
    private String message;

    public Contains(T ... expectedItems) {
        this.expectedItems = expectedItems;
    }

    public boolean matchesSafely(IndexHits<T> tIndexHits) {
        Collection collection = IteratorUtil.asCollection(tIndexHits);
        if (this.expectedItems.length != collection.size()) {
            this.message = "IndexHits with a size of " + this.expectedItems.length + ", got one with " + collection.size();
            this.message = this.message + collection.toString();
            return false;
        }
        for (T item : this.expectedItems) {
            if (collection.contains(item)) continue;
            this.message = "Item (" + item + ") not found.";
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        if (this.message != null) {
            description.appendText(this.message);
        }
    }

    @Factory
    public static <T> Contains<T> contains(T ... expectedItems) {
        return new Contains<T>(expectedItems);
    }
}

