/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.search.NumericRangeQuery;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.BatchInserterIndex;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.Contains;
import org.neo4j.index.impl.lucene.IsEmpty;
import org.neo4j.index.impl.lucene.LuceneBatchInserterIndexProvider;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.MyStandardAnalyzer;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.batchinsert.BatchInserter;
import org.neo4j.kernel.impl.batchinsert.BatchInserterImpl;
import org.neo4j.kernel.impl.cache.LruCache;

public class TestLuceneBatchInsert {
    private static final String PATH = "target/var/batch";

    @Before
    public void cleanDirectory() {
        Neo4jTestCase.deleteFileOrDirectory(new File(PATH));
    }

    @Test
    public void testStartupAndShutdown() {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("users", LuceneIndexImplementation.EXACT_CONFIG);
        long id = inserter.createNode(null);
        index.add(id, MapUtil.map((Object[])new Object[]{"name", "Joe", "other", "Schmoe"}));
        provider.shutdown();
        provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        index = provider.nodeIndex("users", LuceneIndexImplementation.EXACT_CONFIG);
        index.add(id, MapUtil.map((Object[])new Object[]{"name", "Joe", "other", "Schmoe"}));
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void testSome() throws Exception {
        int i;
        String path = new File(PATH, "1").getAbsolutePath();
        BatchInserterImpl inserter = new BatchInserterImpl(path);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("users", LuceneIndexImplementation.EXACT_CONFIG);
        HashMap<Integer, Long> ids = new HashMap<Integer, Long>();
        for (i = 0; i < 100; ++i) {
            long id = inserter.createNode(null);
            index.add(id, MapUtil.map((Object[])new Object[]{"name", "Joe" + i, "other", "Schmoe"}));
            ids.put(i, id);
        }
        for (i = 0; i < 100; ++i) {
            Neo4jTestCase.assertContains(index.get("name", (Object)("Joe" + i)), new Long[]{(Long)ids.get(i)});
        }
        Neo4jTestCase.assertContains(index.query((Object)"name:Joe0 AND other:Schmoe"), new Long[]{(Long)ids.get(0)});
        Neo4jTestCase.assertContains(index.query("name", (Object)"Joe*"), ids.values().toArray(new Long[ids.size()]));
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(path);
        Assert.assertTrue((boolean)db.index().existsForNodes("users"));
        Index dbIndex = db.index().forNodes("users");
        for (int i2 = 0; i2 < 100; ++i2) {
            Neo4jTestCase.assertContains(dbIndex.get("name", (Object)("Joe" + i2)), new Node[]{db.getNodeById(((Long)ids.get(i2)).longValue())});
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Iterator i$ = ids.values().iterator();
        while (i$.hasNext()) {
            long id = (Long)i$.next();
            nodes.add(db.getNodeById(id));
        }
        Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"Joe*"), nodes.toArray(new Node[nodes.size()]));
        Neo4jTestCase.assertContains(dbIndex.query((Object)"name:Joe0 AND other:Schmoe"), new Node[]{db.getNodeById(((Long)ids.get(0)).longValue())});
        db.shutdown();
    }

    @Test
    public void testFulltext() {
        String path = new File(PATH, "2").getAbsolutePath();
        BatchInserterImpl inserter = new BatchInserterImpl(path);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        String name = "users";
        BatchInserterIndex index = provider.nodeIndex(name, MapUtil.stringMap((String[])new String[]{"type", "fulltext"}));
        long id1 = inserter.createNode(null);
        index.add(id1, MapUtil.map((Object[])new Object[]{"name", "Mattias Persson", "email", "something@somewhere", "something", "bad"}));
        long id2 = inserter.createNode(null);
        index.add(id2, MapUtil.map((Object[])new Object[]{"name", "Lars PerssoN"}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Mattias Persson"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"mattias"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.query("name", (Object)"bla"), new Long[0]);
        Neo4jTestCase.assertContains(index.query("name", (Object)"persson"), new Long[]{id1, id2});
        Neo4jTestCase.assertContains(index.query("email", (Object)"*@*"), new Long[]{id1});
        Neo4jTestCase.assertContains(index.get("something", (Object)"bad"), new Long[]{id1});
        long id3 = inserter.createNode(null);
        index.add(id3, MapUtil.map((Object[])new Object[]{"name", new String[]{"What Ever", "Anything"}}));
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"What Ever"), new Long[]{id3});
        Neo4jTestCase.assertContains(index.get("name", (Object)"Anything"), new Long[]{id3});
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(path);
        Index dbIndex = db.index().forNodes(name);
        Node node1 = db.getNodeById(id1);
        Node node2 = db.getNodeById(id2);
        Neo4jTestCase.assertContains(dbIndex.query("name", (Object)"persson"), new Node[]{node1, node2});
        db.shutdown();
    }

    @Ignore
    @Test
    public void testInsertionSpeed() {
        int i;
        BatchInserterImpl inserter = new BatchInserterImpl(new File(PATH, "3").getAbsolutePath());
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("yeah", LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity("key", 1000000);
        long t = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            Map properties = MapUtil.map((Object[])new Object[]{"key", "value" + i});
            long id = inserter.createNode(properties);
            index.add(id, properties);
        }
        System.out.println("insert:" + (System.currentTimeMillis() - t));
        index.flush();
        t = System.currentTimeMillis();
        for (i = 0; i < 1000000; ++i) {
            IteratorUtil.count((Iterator)index.get("key", (Object)("value" + i)));
        }
        System.out.println("get:" + (System.currentTimeMillis() - t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindCreatedIndex() {
        String indexName = "persons";
        String path = new File(PATH, "4").getAbsolutePath();
        BatchInserterImpl inserter = new BatchInserterImpl(path);
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex persons = indexProvider.nodeIndex("persons", MapUtil.stringMap((String[])new String[]{"type", "exact"}));
        Map properties = MapUtil.map((Object[])new Object[]{"name", "test"});
        long node = inserter.createNode(properties);
        persons.add(node, properties);
        indexProvider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase graphDb = new EmbeddedGraphDatabase(path);
        Transaction tx = graphDb.beginTx();
        try {
            IndexManager indexManager = graphDb.index();
            junit.framework.Assert.assertFalse((boolean)indexManager.existsForRelationships(indexName));
            junit.framework.Assert.assertTrue((boolean)indexManager.existsForNodes(indexName));
            junit.framework.Assert.assertNotNull((Object)indexManager.forNodes(indexName));
            Index nodes = graphDb.index().forNodes(indexName);
            junit.framework.Assert.assertTrue((boolean)nodes.get("name", (Object)"test").hasNext());
            tx.success();
            tx.finish();
        }
        finally {
            graphDb.shutdown();
        }
    }

    @Test
    public void testCanIndexRelationships() {
        BatchInserterImpl inserter = new BatchInserterImpl(new File(PATH, "5").getAbsolutePath());
        LuceneBatchInserterIndexProvider indexProvider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex edgesIndex = indexProvider.relationshipIndex("edgeIndex", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        long nodeId1 = inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "1"}));
        long nodeId2 = inserter.createNode(MapUtil.map((Object[])new Object[]{"ID", "2"}));
        long relationshipId = inserter.createRelationship(nodeId1, nodeId2, (RelationshipType)EdgeType.KNOWS, null);
        edgesIndex.add(relationshipId, MapUtil.map((Object[])new Object[]{"EDGE_TYPE", EdgeType.KNOWS.name()}));
        edgesIndex.flush();
        Assert.assertEquals((String)String.format("Should return relationship id", new Object[0]), (Object)new Long(relationshipId), (Object)edgesIndex.query("EDGE_TYPE", (Object)EdgeType.KNOWS.name()).getSingle());
        indexProvider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void triggerNPEAfterFlush() {
        BatchInserterImpl inserter = new BatchInserterImpl(new File(PATH, "6").getAbsolutePath());
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("Node-exact", LuceneIndexImplementation.EXACT_CONFIG);
        Map map = MapUtil.map((Object[])new Object[]{"name", "Something"});
        long node = inserter.createNode(map);
        index.add(node, map);
        index.flush();
        Neo4jTestCase.assertContains(index.get("name", (Object)"Something"), new Long[]{node});
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void testNumericValues() {
        String path = new File(PATH, "7").getAbsolutePath();
        BatchInserterImpl inserter = new BatchInserterImpl(path);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long node1 = inserter.createNode(null);
        index.add(node1, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)45)}));
        long node2 = inserter.createNode(null);
        index.add(node2, MapUtil.map((Object[])new Object[]{"number", ValueContext.numeric((Number)21)}));
        Neo4jTestCase.assertContains(index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)50, (boolean)true, (boolean)true)), new Long[]{node1, node2});
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(path);
        Node n1 = db.getNodeById(node1);
        Node n2 = db.getNodeById(node2);
        Index idx = db.index().forNodes("mine");
        Neo4jTestCase.assertContains(idx.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)21, (Integer)45, (boolean)false, (boolean)true)), new Node[]{n1});
        db.shutdown();
    }

    @Test
    public void testNumericValueArrays() {
        String path = new File(PATH, "8").getAbsolutePath();
        BatchInserterImpl inserter = new BatchInserterImpl(path);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex batchIndex = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long nodeId1 = inserter.createNode(null);
        batchIndex.add(nodeId1, MapUtil.map((Object[])new Object[]{"number", new ValueContext[]{ValueContext.numeric((Number)45), ValueContext.numeric((Number)98)}}));
        long nodeId2 = inserter.createNode(null);
        batchIndex.add(nodeId2, MapUtil.map((Object[])new Object[]{"number", new ValueContext[]{ValueContext.numeric((Number)47), ValueContext.numeric((Number)100)}}));
        IndexHits batchIndexResult1 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult1, Contains.contains(nodeId1, nodeId2));
        Assert.assertThat((Object)batchIndexResult1.size(), (Matcher)Is.is((Object)2));
        IndexHits batchIndexResult2 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)44, (Integer)46, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult2, Contains.contains(nodeId1));
        Assert.assertThat((Object)batchIndexResult2.size(), (Matcher)Is.is((Object)1));
        IndexHits batchIndexResult3 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)99, (Integer)101, (boolean)true, (boolean)true));
        Assert.assertThat((Object)batchIndexResult3, Contains.contains(nodeId2));
        Assert.assertThat((Object)batchIndexResult3.size(), (Matcher)Is.is((Object)1));
        IndexHits batchIndexResult4 = batchIndex.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)false, (boolean)false));
        Assert.assertThat((Object)batchIndexResult4, IsEmpty.isEmpty());
        provider.shutdown();
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(path);
        Node node1 = db.getNodeById(nodeId1);
        Node node2 = db.getNodeById(nodeId2);
        Index index = db.index().forNodes("mine");
        IndexHits indexResult1 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult1, Contains.contains(node1, node2));
        Assert.assertThat((Object)indexResult1.size(), (Matcher)Is.is((Object)2));
        IndexHits indexResult2 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)44, (Integer)46, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult2, Contains.contains(node1));
        Assert.assertThat((Object)indexResult2.size(), (Matcher)Is.is((Object)1));
        IndexHits indexResult3 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)99, (Integer)101, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult3, Contains.contains(node2));
        Assert.assertThat((Object)indexResult3.size(), (Matcher)Is.is((Object)1));
        IndexHits indexResult4 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)false, (boolean)false));
        Assert.assertThat((Object)indexResult4, IsEmpty.isEmpty());
        db.shutdown();
    }

    @Test
    public void indexNumbers() throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(new File(PATH, "9").getAbsolutePath());
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("mine", LuceneIndexImplementation.EXACT_CONFIG);
        long id = inserter.createNode(null);
        HashMap<String, Long> props = new HashMap<String, Long>();
        props.put("key", 123L);
        index.add(id, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)123L).size());
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"123").size());
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void addOrUpdateFlushBehaviour() throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(new File(PATH, "9").getAbsolutePath());
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("update", LuceneIndexImplementation.EXACT_CONFIG);
        long id = inserter.createNode(null);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("key", "value");
        index.add(id, props);
        index.updateOrAdd(id, props);
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value").size());
        index.flush();
        props.put("key", "value2");
        index.updateOrAdd(id, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value2").size());
        Assert.assertEquals((long)0L, (long)index.get("key", (Object)"value").size());
        props.put("key2", "value2");
        props.put("key", "value");
        index.updateOrAdd(id, props);
        Assert.assertEquals((long)0L, (long)index.get("key2", (Object)"value2").size());
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("key2", (Object)"value2").size());
        Assert.assertEquals((long)1L, (long)index.get("key", (Object)"value").size());
        long id2 = inserter.createNode(null);
        props = new HashMap();
        props.put("2key", "value");
        index.updateOrAdd(id2, props);
        props.put("2key", "value2");
        props.put("2key2", "value3");
        index.updateOrAdd(id2, props);
        index.flush();
        Assert.assertEquals((long)1L, (long)index.get("2key", (Object)"value2").size());
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void useStandardAnalyzer() throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("myindex", MapUtil.stringMap((String[])new String[]{"analyzer", MyStandardAnalyzer.class.getName()}));
        index.add(0L, MapUtil.map((Object[])new Object[]{"name", "Mattias"}));
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void cachesShouldBeFilledWhenAddToMultipleIndexesCreatedNow() throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        BatchInserterIndex index = provider.nodeIndex("index1", LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity("name", 100000);
        String nameKey = "name";
        String titleKey = "title";
        this.assertCacheIsEmpty(index, nameKey, titleKey);
        index.add(0L, MapUtil.map((Object[])new Object[]{"name", "Neo", "title", "Matrix"}));
        this.assertCacheContainsSomething(index, nameKey);
        this.assertCacheIsEmpty(index, titleKey);
        BatchInserterIndex index2 = provider.nodeIndex("index2", LuceneIndexImplementation.EXACT_CONFIG);
        index2.setCacheCapacity("title", 100000);
        this.assertCacheIsEmpty(index2, nameKey, titleKey);
        index2.add(0L, MapUtil.map((Object[])new Object[]{"name", "Neo", "title", "Matrix"}));
        this.assertCacheContainsSomething(index2, titleKey);
        this.assertCacheIsEmpty(index2, nameKey);
        provider.shutdown();
        inserter.shutdown();
    }

    @Test
    public void cachesDoesntGetFilledWhenAddingForAnExistingIndex() throws Exception {
        BatchInserterImpl inserter = new BatchInserterImpl(PATH);
        LuceneBatchInserterIndexProvider provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        String indexName = "index";
        BatchInserterIndex index = provider.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        index.add(0L, MapUtil.map((Object[])new Object[]{key, "Mattias"}));
        provider.shutdown();
        inserter.shutdown();
        inserter = new BatchInserterImpl(PATH);
        provider = new LuceneBatchInserterIndexProvider((BatchInserter)inserter);
        index = provider.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        index.setCacheCapacity(key, 100000);
        this.assertCacheIsEmpty(index, key);
        index.add(1L, MapUtil.map((Object[])new Object[]{key, "Persson"}));
        this.assertCacheIsEmpty(index, key);
        Assert.assertEquals((long)1L, (long)((Long)index.get(key, (Object)"Persson").getSingle()).intValue());
        provider.shutdown();
        inserter.shutdown();
    }

    private void assertCacheContainsSomething(BatchInserterIndex index, String ... keys) {
        Map<String, LruCache<String, Collection<Long>>> cache = this.getIndexCache(index);
        for (String key : keys) {
            Assert.assertTrue((cache.get(key).size() > 0 ? 1 : 0) != 0);
        }
    }

    private void assertCacheIsEmpty(BatchInserterIndex index, String ... keys) {
        Map<String, LruCache<String, Collection<Long>>> cache = this.getIndexCache(index);
        for (String key : keys) {
            LruCache<String, Collection<Long>> keyCache = cache.get(key);
            Assert.assertTrue((keyCache == null || keyCache.size() == 0 ? 1 : 0) != 0);
        }
    }

    private Map<String, LruCache<String, Collection<Long>>> getIndexCache(BatchInserterIndex index) {
        try {
            Field field = index.getClass().getDeclaredField("cache");
            field.setAccessible(true);
            return (Map)field.get(index);
        }
        catch (Exception e) {
            throw Exceptions.launderedException((Throwable)e);
        }
    }

    private static enum EdgeType implements RelationshipType
    {
        KNOWS;

    }
}

