/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.AbstractLuceneIndexTest;
import org.neo4j.index.impl.lucene.Contains;
import org.neo4j.index.impl.lucene.CustomAnalyzer;
import org.neo4j.index.impl.lucene.IsEmpty;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.WorkThread;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;
import org.neo4j.kernel.EmbeddedGraphDatabase;

public class TestLuceneIndex
extends AbstractLuceneIndexTest {
    @Rule
    public final TestName testname = new TestName();

    private <T extends PropertyContainer> void makeSureAdditionsCanBeRead(Index<T> index, AbstractLuceneIndexTest.EntityCreator<T> entityCreator) {
        String key = "name";
        String value = "Mattias";
        Assert.assertThat((Object)index.get(key, (Object)value).getSingle(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)index.get(key, (Object)value), IsEmpty.isEmpty());
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        T entity1 = entityCreator.create(new Object[0]);
        T entity2 = entityCreator.create(new Object[0]);
        index.add(entity1, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1));
            Assert.assertThat((Object)index.query(key, (Object)"*"), Contains.contains(entity1));
            Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1));
            this.restartTx();
        }
        index.add(entity2, key, (Object)value);
        Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1, entity2));
        this.restartTx();
        Assert.assertThat((Object)index.get(key, (Object)value), Contains.contains(entity1, entity2));
        index.delete();
    }

    @Test
    public void makeSureYouGetLatestTxModificationsInQueryByDefault() {
        Index<Node> index = this.nodeIndex("failing-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        Assert.assertThat((Object)index.query((Object)"key:value"), Contains.contains(node));
    }

    @Test
    public void makeSureLuceneIndexesReportAsWriteable() {
        Index<Node> index = this.nodeIndex("write-me", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        Assert.assertTrue((boolean)index.isWriteable());
    }

    @Test
    public void testStartupInExistingDirectory() {
        File dir = new File("target" + File.separator + "temp" + File.separator);
        Neo4jTestCase.deleteFileOrDirectory(dir);
        dir.mkdir();
        EmbeddedGraphDatabase graphDatabase = new EmbeddedGraphDatabase(dir.getAbsolutePath());
        Index index = graphDatabase.index().forNodes("nodes");
        Assert.assertNotNull((Object)index);
    }

    @Test
    public void makeSureAdditionsCanBeReadNodeExact() {
        this.makeSureAdditionsCanBeRead(this.nodeIndex("exact", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadNodeFulltext() {
        this.makeSureAdditionsCanBeRead(this.nodeIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadRelationshipExact() {
        this.makeSureAdditionsCanBeRead((Index)this.relationshipIndex("exact", LuceneIndexImplementation.EXACT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeReadRelationshipFulltext() {
        this.makeSureAdditionsCanBeRead((Index)this.relationshipIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void makeSureAdditionsCanBeRemovedInSameTx() {
        this.makeSureAdditionsCanBeRemoved(false);
    }

    @Test
    public void makeSureYouCanAskIfAnIndexExistsOrNot() {
        String name = "index-that-may-exist";
        Assert.assertFalse((boolean)graphDb.index().existsForNodes(name));
        graphDb.index().forNodes(name);
        Assert.assertTrue((boolean)graphDb.index().existsForNodes(name));
        Assert.assertFalse((boolean)graphDb.index().existsForRelationships(name));
        graphDb.index().forRelationships(name);
        Assert.assertTrue((boolean)graphDb.index().existsForRelationships(name));
    }

    private void makeSureAdditionsCanBeRemoved(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value = "Mattias";
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)value);
        if (restartTx) {
            this.restartTx();
        }
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
        index.remove((PropertyContainer)node, key, (Object)value);
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        this.restartTx();
        Assert.assertNull((Object)index.get(key, (Object)value).getSingle());
        node.delete();
        index.delete();
    }

    @Test
    public void makeSureAdditionsCanBeRemoved() {
        this.makeSureAdditionsCanBeRemoved(true);
    }

    private void makeSureSomeAdditionsCanBeRemoved(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key1 = "name";
        String key2 = "title";
        String value1 = "Mattias";
        Assert.assertNull((Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        Node node = graphDb.createNode();
        Node node2 = graphDb.createNode();
        index.add((PropertyContainer)node, key1, (Object)value1);
        index.add((PropertyContainer)node, key2, (Object)value1);
        index.add((PropertyContainer)node2, key1, (Object)value1);
        if (restartTx) {
            this.restartTx();
        }
        index.remove((PropertyContainer)node, key1, (Object)value1);
        index.remove((PropertyContainer)node, key2, (Object)value1);
        Assert.assertEquals((Object)node2, (Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        Assert.assertEquals((Object)node2, (Object)index.get(key1, (Object)value1).getSingle());
        Assert.assertNull((Object)index.get(key2, (Object)value1).getSingle());
        node.delete();
        index.delete();
    }

    @Test
    public void makeSureSomeAdditionsCanBeRemovedInSameTx() {
        this.makeSureSomeAdditionsCanBeRemoved(false);
    }

    @Test
    public void makeSureSomeAdditionsCanBeRemoved() {
        this.makeSureSomeAdditionsCanBeRemoved(true);
    }

    @Test
    public void makeSureThereCanBeMoreThanOneValueForAKeyAndEntity() {
        this.makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(false);
    }

    @Test
    public void makeSureThereCanBeMoreThanOneValueForAKeyAndEntitySameTx() {
        this.makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(true);
    }

    private void makeSureThereCanBeMoreThanOneValueForAKeyAndEntity(boolean restartTx) {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "Lucene";
        String value2 = "Index";
        String value3 = "Rules";
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)value1);
        index.add((PropertyContainer)node, key, (Object)value2);
        if (restartTx) {
            this.restartTx();
        }
        index.add((PropertyContainer)node, key, (Object)value3);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value3), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)"whatever"), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void shouldNotGetLatestTxModificationsWhenChoosingSpeedQueries() {
        Index<Node> index = this.nodeIndex("indexFooBar", LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        QueryContext queryContext = new QueryContext((Object)"value").tradeCorrectnessForSpeed();
        Assert.assertThat((Object)index.query("key", (Object)queryContext), IsEmpty.isEmpty());
        Assert.assertThat((Object)index.query("key", (Object)"value"), Contains.contains(node));
    }

    @Test
    public void makeSureArrayValuesAreSupported() {
        int i;
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "Lucene";
        String value2 = "Index";
        String value3 = "Rules";
        Assert.assertThat((Object)index.query(key, (Object)"*"), IsEmpty.isEmpty());
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, key, (Object)new String[]{value1, value2, value3});
        for (i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value3), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)"whatever"), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.remove((PropertyContainer)node, key, (Object)new String[]{value2, value3});
        for (i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)value1), Contains.contains(node));
            Assert.assertThat((Object)index.get(key, (Object)value2), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.get(key, (Object)value3), IsEmpty.isEmpty());
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void makeSureWildcardQueriesCanBeAsked() {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value1 = "neo4j";
        String value2 = "nescafe";
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        index.add((PropertyContainer)node1, key, (Object)value1);
        index.add((PropertyContainer)node2, key, (Object)value2);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query(key, (Object)"neo*"), Contains.contains(node1));
            Assert.assertThat((Object)index.query(key, (Object)"n?o4j"), Contains.contains(node1));
            Assert.assertThat((Object)index.query(key, (Object)"ne*"), Contains.contains(node1, node2));
            Assert.assertThat((Object)index.query((Object)(key + ":neo4j")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":neo*")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":n?o4j")), Contains.contains(node1));
            Assert.assertThat((Object)index.query((Object)(key + ":ne*")), Contains.contains(node1, node2));
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void makeSureCompositeQueriesCanBeAsked() {
        Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        Node neo = graphDb.createNode();
        Node trinity = graphDb.createNode();
        index.add((PropertyContainer)neo, "username", (Object)"neo@matrix");
        index.add((PropertyContainer)neo, "sex", (Object)"male");
        index.add((PropertyContainer)trinity, "username", (Object)"trinity@matrix");
        index.add((PropertyContainer)trinity, "sex", (Object)"female");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)"username:*@matrix AND sex:male"), Contains.contains(neo));
            Assert.assertThat((Object)index.query((Object)new QueryContext((Object)"username:*@matrix sex:male").defaultOperator(QueryParser.Operator.AND)), Contains.contains(neo));
            Assert.assertThat((Object)index.query((Object)"username:*@matrix OR sex:male"), Contains.contains(neo, trinity));
            Assert.assertThat((Object)index.query((Object)new QueryContext((Object)"username:*@matrix sex:male").defaultOperator(QueryParser.Operator.OR)), Contains.contains(neo, trinity));
            this.restartTx();
        }
        index.delete();
    }

    private <T extends PropertyContainer> void doSomeRandomUseCaseTestingWithExactIndex(Index<T> index, AbstractLuceneIndexTest.EntityCreator<T> creator) {
        String name = "name";
        String mattias = "Mattias Persson";
        String title = "title";
        String hacker = "Hacker";
        Assert.assertThat((Object)index.get(name, (Object)mattias), IsEmpty.isEmpty());
        T entity1 = creator.create(new Object[0]);
        T entity2 = creator.create(new Object[0]);
        Assert.assertNull((Object)index.get(name, (Object)mattias).getSingle());
        index.add(entity1, name, (Object)mattias);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Neo4jTestCase.assertContains(index.query(name, (Object)("\"" + mattias + "\"")), new PropertyContainer[]{entity1});
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\"")), new PropertyContainer[]{entity1});
        Assert.assertEquals(entity1, (Object)index.get(name, (Object)mattias).getSingle());
        Neo4jTestCase.assertContains(index.query("name", (Object)"Mattias*"), new PropertyContainer[]{entity1});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.query(name, (Object)("\"" + mattias + "\"")), Contains.contains(entity1));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\"")), Contains.contains(entity1));
        Assert.assertEquals(entity1, (Object)index.get(name, (Object)mattias).getSingle());
        Assert.assertThat((Object)index.query("name", (Object)"Mattias*"), Contains.contains(entity1));
        this.beginTx();
        index.add(entity2, title, (Object)hacker);
        index.add(entity1, title, (Object)hacker);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1, entity2));
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), new PropertyContainer[]{entity1, entity2});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1, entity2));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), Contains.contains(entity1, entity2));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" AND title:\"" + hacker + "\"")), Contains.contains(entity1));
        this.beginTx();
        index.remove(entity2, title, (Object)hacker);
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1));
        Neo4jTestCase.assertContains(index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), new PropertyContainer[]{entity1});
        this.commitTx();
        Assert.assertThat((Object)index.get(name, (Object)mattias), Contains.contains(entity1));
        Assert.assertThat((Object)index.get(title, (Object)hacker), Contains.contains(entity1));
        Assert.assertThat((Object)index.query((Object)("name:\"" + mattias + "\" OR title:\"" + hacker + "\"")), Contains.contains(entity1));
        this.beginTx();
        index.remove(entity1, title, (Object)hacker);
        index.remove(entity1, name, (Object)mattias);
        index.delete();
        this.commitTx();
    }

    @Test
    public void doSomeRandomUseCaseTestingWithExactNodeIndex() {
        this.doSomeRandomUseCaseTestingWithExactIndex(this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void doSomeRandomUseCaseTestingWithExactRelationshipIndex() {
        this.doSomeRandomUseCaseTestingWithExactIndex((Index)this.relationshipIndex("index", LuceneIndexImplementation.EXACT_CONFIG), RELATIONSHIP_CREATOR);
    }

    private <T extends PropertyContainer> void doSomeRandomTestingWithFulltextIndex(Index<T> index, AbstractLuceneIndexTest.EntityCreator<T> creator) {
        T entity1 = creator.create(new Object[0]);
        T entity2 = creator.create(new Object[0]);
        String key = "name";
        index.add(entity1, key, (Object)"The quick brown fox");
        index.add(entity2, key, (Object)"brown fox jumped over");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)"The quick brown fox"), Contains.contains(entity1));
            Assert.assertThat((Object)index.get(key, (Object)"brown fox jumped over"), Contains.contains(entity2));
            Assert.assertThat((Object)index.query(key, (Object)"quick"), Contains.contains(entity1));
            Assert.assertThat((Object)index.query(key, (Object)"brown"), Contains.contains(entity1, entity2));
            Assert.assertThat((Object)index.query(key, (Object)"quick OR jumped"), Contains.contains(entity1, entity2));
            Assert.assertThat((Object)index.query(key, (Object)"brown AND fox"), Contains.contains(entity1, entity2));
            this.restartTx();
        }
        index.delete();
    }

    @Test
    public void doSomeRandomTestingWithNodeFulltextInde() {
        this.doSomeRandomTestingWithFulltextIndex(this.nodeIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void doSomeRandomTestingWithRelationshipFulltextInde() {
        this.doSomeRandomTestingWithFulltextIndex((Index)this.relationshipIndex("fulltext", LuceneIndexImplementation.FULLTEXT_CONFIG), RELATIONSHIP_CREATOR);
    }

    @Test
    public void testNodeLocalRelationshipIndex() {
        RelationshipIndex index = this.relationshipIndex("locality", LuceneIndexImplementation.EXACT_CONFIG);
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"YO");
        Node startNode = graphDb.createNode();
        Node endNode1 = graphDb.createNode();
        Node endNode2 = graphDb.createNode();
        Relationship rel1 = startNode.createRelationshipTo(endNode1, (RelationshipType)type);
        Relationship rel2 = startNode.createRelationshipTo(endNode2, (RelationshipType)type);
        index.add((PropertyContainer)rel1, "name", (Object)"something");
        index.add((PropertyContainer)rel2, "name", (Object)"something");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)"name:something"), Contains.contains(rel1, rel2));
            Assert.assertThat((Object)index.query((Object)"name:something", null, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.query((Object)"name:something", startNode, endNode2), Contains.contains(rel2));
            Assert.assertThat((Object)index.query(null, startNode, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.get("name", (Object)"something", null, endNode1), Contains.contains(rel1));
            Assert.assertThat((Object)index.get("name", (Object)"something", startNode, endNode2), Contains.contains(rel2));
            Assert.assertThat((Object)index.get(null, null, startNode, endNode1), Contains.contains(rel1));
            this.restartTx();
        }
        rel2.delete();
        rel1.delete();
        startNode.delete();
        endNode1.delete();
        endNode2.delete();
        index.delete();
    }

    @Test
    public void testSortByRelevance() {
        Index<Node> index = this.nodeIndex("relevance", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        index.add((PropertyContainer)node1, "name", (Object)"something");
        index.add((PropertyContainer)node2, "name", (Object)"something");
        index.add((PropertyContainer)node2, "foo", (Object)"yes");
        index.add((PropertyContainer)node3, "name", (Object)"something");
        index.add((PropertyContainer)node3, "foo", (Object)"yes");
        index.add((PropertyContainer)node3, "bar", (Object)"yes");
        this.restartTx();
        IndexHits hits = index.query((Object)new QueryContext((Object)"+name:something foo:yes bar:yes").sort(Sort.RELEVANCE));
        Assert.assertEquals((Object)node3, (Object)hits.next());
        Assert.assertEquals((Object)node2, (Object)hits.next());
        Assert.assertEquals((Object)node1, (Object)hits.next());
        Assert.assertFalse((boolean)hits.hasNext());
        index.delete();
        node1.delete();
        node2.delete();
        node3.delete();
    }

    @Test
    public void testSorting() {
        Index<Node> index = this.nodeIndex("sort", LuceneIndexImplementation.EXACT_CONFIG);
        String name = "name";
        String title = "title";
        String other = "other";
        String sex = "sex";
        Node adam = graphDb.createNode();
        Node adam2 = graphDb.createNode();
        Node jack = graphDb.createNode();
        Node eva = graphDb.createNode();
        index.add((PropertyContainer)adam, name, (Object)"Adam");
        index.add((PropertyContainer)adam, title, (Object)"Software developer");
        index.add((PropertyContainer)adam, sex, (Object)"male");
        index.add((PropertyContainer)adam, other, (Object)"aaa");
        index.add((PropertyContainer)adam2, name, (Object)"Adam");
        index.add((PropertyContainer)adam2, title, (Object)"Blabla");
        index.add((PropertyContainer)adam2, sex, (Object)"male");
        index.add((PropertyContainer)adam2, other, (Object)"bbb");
        index.add((PropertyContainer)jack, name, (Object)"Jack");
        index.add((PropertyContainer)jack, title, (Object)"Apple sales guy");
        index.add((PropertyContainer)jack, sex, (Object)"male");
        index.add((PropertyContainer)jack, other, (Object)"ccc");
        index.add((PropertyContainer)eva, name, (Object)"Eva");
        index.add((PropertyContainer)eva, title, (Object)"Secretary");
        index.add((PropertyContainer)eva, sex, (Object)"female");
        index.add((PropertyContainer)eva, other, (Object)"ddd");
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{title})), new Node[]{adam2, adam, eva, jack});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{other})), new Node[]{adam, adam2, eva, jack});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(sex, new String[]{title})), new Node[]{eva, jack, adam2, adam});
            Neo4jTestCase.assertContainsInOrder(index.query(name, (Object)new QueryContext((Object)"*").sort(sex, new String[]{title})), new Node[]{eva, jack, adam2, adam});
            Neo4jTestCase.assertContainsInOrder(index.query((Object)new QueryContext((Object)"name:*").sort(name, new String[]{title}).top(2)), new Node[]{adam2, adam});
            this.restartTx();
        }
    }

    @Test
    public void testNumericValuesExactIndex() throws Exception {
        this.testNumericValues(this.nodeIndex("numeric", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testNumericValuesFulltextIndex() throws Exception {
        this.testNumericValues(this.nodeIndex("numeric-ft", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    private void testNumericValues(Index<Node> index) {
        Node node10 = graphDb.createNode();
        Node node6 = graphDb.createNode();
        Node node31 = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)node10, key, (Object)ValueContext.numeric((Number)10));
        index.add((PropertyContainer)node6, key, (Object)ValueContext.numeric((Number)6));
        index.add((PropertyContainer)node31, key, (Object)ValueContext.numeric((Number)31));
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)4, (Integer)40, (boolean)true, (boolean)true)), Contains.contains(node10, node6, node31));
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)6, (Integer)15, (boolean)true, (boolean)true)), Contains.contains(node10, node6));
            Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)6, (Integer)15, (boolean)false, (boolean)true)), Contains.contains(node10));
            this.restartTx();
        }
        index.remove((PropertyContainer)node6, key, (Object)ValueContext.numeric((Number)6));
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)4, (Integer)40, (boolean)true, (boolean)true)), Contains.contains(node10, node31));
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)4, (Integer)40, (boolean)true, (boolean)true)), Contains.contains(node10, node31));
    }

    @Test
    public void testNumericValueArrays() {
        Index<Node> index = this.nodeIndex("numeric-array", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        index.add((PropertyContainer)node1, "number", (Object)new ValueContext[]{ValueContext.numeric((Number)45), ValueContext.numeric((Number)98)});
        Node node2 = graphDb.createNode();
        index.add((PropertyContainer)node2, "number", (Object)new ValueContext[]{ValueContext.numeric((Number)47), ValueContext.numeric((Number)100)});
        IndexHits indexResult1 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult1, Contains.contains(node1, node2));
        Assert.assertThat((Object)indexResult1.size(), (Matcher)Is.is((Object)2));
        IndexHits indexResult2 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)44, (Integer)46, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult2, Contains.contains(node1));
        Assert.assertThat((Object)indexResult2.size(), (Matcher)Is.is((Object)1));
        IndexHits indexResult3 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)99, (Integer)101, (boolean)true, (boolean)true));
        Assert.assertThat((Object)indexResult3, Contains.contains(node2));
        Assert.assertThat((Object)indexResult3.size(), (Matcher)Is.is((Object)1));
        IndexHits indexResult4 = index.query("number", (Object)NumericRangeQuery.newIntRange((String)"number", (Integer)47, (Integer)98, (boolean)false, (boolean)false));
        Assert.assertThat((Object)indexResult4, IsEmpty.isEmpty());
        IndexHits indexResult5 = index.query("number", (Object)QueryContext.numericRange((String)"number", null, (Number)98, (boolean)true, (boolean)true));
        Neo4jTestCase.assertContains(indexResult5, new Node[]{node1, node2});
        IndexHits indexResult6 = index.query("number", (Object)QueryContext.numericRange((String)"number", (Number)47, null, (boolean)true, (boolean)true));
        Neo4jTestCase.assertContains(indexResult6, new Node[]{node1, node2});
    }

    @Test
    public void testRemoveNumericValues() {
        Index<Node> index = this.nodeIndex("numeric2", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        index.add((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        index.remove((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
        index.remove((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), IsEmpty.isEmpty());
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), IsEmpty.isEmpty());
        index.add((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        index.add((PropertyContainer)node2, key, (Object)new ValueContext((Object)5).indexNumeric());
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node1, node2));
        index.remove((PropertyContainer)node1, key, (Object)new ValueContext((Object)15).indexNumeric());
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
        this.restartTx();
        Assert.assertThat((Object)index.query((Object)NumericRangeQuery.newIntRange((String)key, (Integer)0, (Integer)20, (boolean)false, (boolean)false)), Contains.contains(node2));
    }

    @Test
    public void sortNumericValues() throws Exception {
        Index<Node> index = this.nodeIndex("numeric3", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)node1, key, (Object)ValueContext.numeric((Number)5));
        index.add((PropertyContainer)node2, key, (Object)ValueContext.numeric((Number)15));
        index.add((PropertyContainer)node3, key, (Object)ValueContext.numeric((Number)10));
        this.restartTx();
        Neo4jTestCase.assertContainsInOrder(index.query((Object)QueryContext.numericRange((String)key, (Number)5, (Number)15).sortNumeric(key, false)), new Node[]{node1, node3, node2});
    }

    @Test
    public void testIndexNumberAsString() {
        Index<Node> index = this.nodeIndex("nums", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        index.add((PropertyContainer)node1, "key", (Object)10);
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)node1, (Object)index.get("key", (Object)10).getSingle());
            Assert.assertEquals((Object)node1, (Object)index.get("key", (Object)"10").getSingle());
            Assert.assertEquals((Object)node1, (Object)index.query("key", (Object)10).getSingle());
            Assert.assertEquals((Object)node1, (Object)index.query("key", (Object)"10").getSingle());
            this.restartTx();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void makeSureIndexGetsCreatedImmediately() {
        this.nodeIndex("immediate-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Assert.assertTrue((boolean)graphDb.index().existsForNodes("immediate-index"));
        this.rollbackTx();
        Assert.assertTrue((boolean)graphDb.index().existsForNodes("immediate-index"));
        this.nodeIndex("immediate-index", LuceneIndexImplementation.EXACT_CONFIG);
    }

    @Test
    public void makeSureFulltextConfigIsCaseInsensitiveByDefault() {
        Index<Node> index = this.nodeIndex("ft-case-sensitive", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        String key = "name";
        String value = "Mattias Persson";
        index.add((PropertyContainer)node, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query("name", (Object)"[A TO Z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"[a TO z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"Mattias"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"mattias"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"Matt*"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"matt*"), Contains.contains(node));
            this.restartTx();
        }
    }

    @Test
    public void makeSureFulltextIndexCanBeCaseSensitive() {
        Index<Node> index = this.nodeIndex("ft-case-insensitive", MapUtil.stringMap(new HashMap(LuceneIndexImplementation.FULLTEXT_CONFIG), (String[])new String[]{"to_lower_case", "false"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "Mattias Persson";
        index.add((PropertyContainer)node, key, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.query("name", (Object)"[A TO Z]"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"[a TO z]"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.query("name", (Object)"Matt*"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"matt*"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.query("name", (Object)"Persson"), Contains.contains(node));
            Assert.assertThat((Object)index.query("name", (Object)"persson"), IsEmpty.isEmpty());
            this.restartTx();
        }
    }

    @Test
    public void makeSureCustomAnalyzerCanBeUsed() {
        CustomAnalyzer.called = false;
        Index<Node> index = this.nodeIndex("w-custom-analyzer", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "analyzer", CustomAnalyzer.class.getName(), "to_lower_case", "true"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "The value";
        index.add((PropertyContainer)node, key, (Object)value);
        this.restartTx();
        Assert.assertTrue((boolean)CustomAnalyzer.called);
        Assert.assertThat((Object)index.query(key, (Object)"[A TO Z]"), Contains.contains(node));
    }

    @Test
    public void makeSureCustomAnalyzerCanBeUsed2() {
        CustomAnalyzer.called = false;
        Index<Node> index = this.nodeIndex("w-custom-analyzer-2", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "analyzer", CustomAnalyzer.class.getName(), "to_lower_case", "true", "type", "fulltext"}));
        Node node = graphDb.createNode();
        String key = "name";
        String value = "The value";
        index.add((PropertyContainer)node, key, (Object)value);
        this.restartTx();
        Assert.assertTrue((boolean)CustomAnalyzer.called);
        Assert.assertThat((Object)index.query(key, (Object)"[A TO Z]"), Contains.contains(node));
    }

    @Test
    public void makeSureIndexNameAndConfigCanBeReachedFromIndex() {
        String indexName = "my-index-1";
        Index<Node> nodeIndex = this.nodeIndex(indexName, LuceneIndexImplementation.EXACT_CONFIG);
        Assert.assertEquals((Object)indexName, (Object)nodeIndex.getName());
        Assert.assertEquals((Object)LuceneIndexImplementation.EXACT_CONFIG, (Object)graphDb.index().getConfiguration(nodeIndex));
        String indexName2 = "my-index-2";
        RelationshipIndex relIndex = this.relationshipIndex(indexName2, LuceneIndexImplementation.FULLTEXT_CONFIG);
        Assert.assertEquals((Object)indexName2, (Object)relIndex.getName());
        Assert.assertEquals((Object)LuceneIndexImplementation.FULLTEXT_CONFIG, (Object)graphDb.index().getConfiguration((Index)relIndex));
    }

    @Test
    public void testStringQueryVsQueryObject() throws IOException {
        Index<Node> index = this.nodeIndex("query-diff", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "name", (Object)"Mattias Persson");
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query((Object)"name:Mattias AND name:Per*"), new Node[]{node});
            Neo4jTestCase.assertContains(index.query((Object)"name:mattias"), new Node[]{node});
            Neo4jTestCase.assertContains(index.query((Object)new TermQuery(new Term("name", "mattias"))), new Node[]{node});
            this.restartTx();
        }
        Assert.assertNull((Object)index.query((Object)new TermQuery(new Term("name", "Mattias"))).getSingle());
    }

    private <T extends PropertyContainer> void testAbandonedIds(AbstractLuceneIndexTest.EntityCreator<T> creator, Index<T> index) {
        T a = creator.create(new Object[0]);
        T b = creator.create(new Object[0]);
        T c = creator.create(new Object[0]);
        String key = "name";
        String value = "value";
        index.add(a, key, (Object)value);
        index.add(b, key, (Object)value);
        index.add(c, key, (Object)value);
        this.restartTx();
        creator.delete(b);
        this.restartTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
        this.rollbackTx();
        this.beginTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
        index.add(c, "something", (Object)"whatever");
        this.restartTx();
        IteratorUtil.count((Iterator)index.get(key, (Object)value));
    }

    @Test
    public void testAbandonedNodeIds() {
        this.testAbandonedIds(NODE_CREATOR, this.nodeIndex("abandoned", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testAbandonedNodeIdsFulltext() {
        this.testAbandonedIds(NODE_CREATOR, this.nodeIndex("abandonedf", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testAbandonedRelIds() {
        this.testAbandonedIds(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("abandoned", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testAbandonedRelIdsFulltext() {
        this.testAbandonedIds(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("abandonedf", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void makeSureYouCanRemoveFromRelationshipIndex() {
        Node n1 = graphDb.createNode();
        Node n2 = graphDb.createNode();
        Relationship r = n1.createRelationshipTo(n2, (RelationshipType)DynamicRelationshipType.withName((String)"foo"));
        RelationshipIndex index = graphDb.index().forRelationships("rel-index");
        String key = "bar";
        index.remove((PropertyContainer)r, key, (Object)"value");
        index.add((PropertyContainer)r, key, (Object)"otherValue");
        for (int i = 0; i < 2; ++i) {
            Assert.assertThat((Object)index.get(key, (Object)"value"), IsEmpty.isEmpty());
            Assert.assertThat((Object)index.get(key, (Object)"otherValue"), Contains.contains(r));
            this.restartTx();
        }
    }

    @Test
    public void makeSureYouCanGetEntityTypeFromIndex() {
        Index<Node> nodeIndex = this.nodeIndex("type-test", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        RelationshipIndex relIndex = this.relationshipIndex("type-test", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "exact"}));
        Assert.assertEquals(Node.class, (Object)nodeIndex.getEntityType());
        Assert.assertEquals(Relationship.class, (Object)relIndex.getEntityType());
    }

    @Test
    public void makeSureConfigurationCanBeModified() {
        Index<Node> index = this.nodeIndex("conf-index", LuceneIndexImplementation.EXACT_CONFIG);
        try {
            graphDb.index().setConfiguration(index, "provider", "something");
            Assert.fail((String)"Shouldn't be able to modify provider");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            graphDb.index().removeConfiguration(index, "provider");
            Assert.fail((String)"Shouldn't be able to modify provider");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String key = "my-key";
        String value = "my-value";
        String newValue = "my-new-value";
        Assert.assertNull((Object)graphDb.index().setConfiguration(index, key, value));
        Assert.assertEquals((Object)value, graphDb.index().getConfiguration(index).get(key));
        Assert.assertEquals((Object)value, (Object)graphDb.index().setConfiguration(index, key, newValue));
        Assert.assertEquals((Object)newValue, graphDb.index().getConfiguration(index).get(key));
        Assert.assertEquals((Object)newValue, (Object)graphDb.index().removeConfiguration(index, key));
        Assert.assertNull(graphDb.index().getConfiguration(index).get(key));
    }

    @Test
    public void makeSureSlightDifferencesInIndexConfigCanBeSupplied() {
        Map config = MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"});
        String name = "the-name";
        this.nodeIndex(name, config);
        this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"to_lower_case", "true"}));
        try {
            this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"to_lower_case", "false"}));
            Assert.fail((String)"Shouldn't be able to get index with these kinds of differences in config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.nodeIndex(name, MapUtil.stringMap(new HashMap(config), (String[])new String[]{"whatever", "something"}));
    }

    @Test
    public void testScoring() {
        Index<Node> index = this.nodeIndex("score-index", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        String key = "text";
        index.add((PropertyContainer)node1, key, (Object)"a time where no one was really awake");
        index.add((PropertyContainer)node2, key, (Object)"once upon a time there was");
        this.restartTx();
        IndexHits hits = index.query(key, (Object)new QueryContext((Object)"once upon a time was").sort(Sort.RELEVANCE));
        Node hit1 = (Node)hits.next();
        float score1 = hits.currentScore();
        Node hit2 = (Node)hits.next();
        float score2 = hits.currentScore();
        Assert.assertEquals((Object)node2, (Object)hit1);
        Assert.assertEquals((Object)node1, (Object)hit2);
        Assert.assertTrue((score1 > score2 ? 1 : 0) != 0);
    }

    @Test
    public void testTopHits() {
        RelationshipIndex index = this.relationshipIndex("topdocs", LuceneIndexImplementation.FULLTEXT_CONFIG);
        AbstractLuceneIndexTest.EntityCreator creator = RELATIONSHIP_CREATOR;
        String key = "text";
        Relationship rel1 = (Relationship)creator.create(key, "one two three four five six seven eight nine ten");
        Relationship rel2 = (Relationship)creator.create(key, "one two three four five six seven eight other things");
        Relationship rel3 = (Relationship)creator.create(key, "one two three four five six some thing else");
        Relationship rel4 = (Relationship)creator.create(key, "one two three four five what ever");
        Relationship rel5 = (Relationship)creator.create(key, "one two three four all that is good and bad");
        Relationship rel6 = (Relationship)creator.create(key, "one two three hill or something");
        Relationship rel7 = (Relationship)creator.create(key, "one two other time than this");
        index.add((PropertyContainer)rel2, key, rel2.getProperty(key));
        index.add((PropertyContainer)rel1, key, rel1.getProperty(key));
        index.add((PropertyContainer)rel3, key, rel3.getProperty(key));
        index.add((PropertyContainer)rel7, key, rel7.getProperty(key));
        index.add((PropertyContainer)rel5, key, rel5.getProperty(key));
        index.add((PropertyContainer)rel4, key, rel4.getProperty(key));
        index.add((PropertyContainer)rel6, key, rel6.getProperty(key));
        String query = "one two three four five six seven";
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)query).top(3).sort(Sort.RELEVANCE)), new Relationship[]{rel1, rel2, rel3});
            this.restartTx();
        }
    }

    @Test
    public void testSimilarity() {
        Index<Node> index = this.nodeIndex("similarity", MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext", "similarity", DefaultSimilarity.class.getName()}));
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        Neo4jTestCase.assertContains(index.get("key", (Object)"value"), new Node[]{node});
    }

    @Test
    public void testCombinedHitsSizeProblem() {
        Index<Node> index = this.nodeIndex("size-npe", LuceneIndexImplementation.EXACT_CONFIG);
        Node node1 = graphDb.createNode();
        Node node2 = graphDb.createNode();
        Node node3 = graphDb.createNode();
        String key = "key";
        String value = "value";
        index.add((PropertyContainer)node1, key, (Object)value);
        index.add((PropertyContainer)node2, key, (Object)value);
        this.restartTx();
        index.add((PropertyContainer)node3, key, (Object)value);
        IndexHits hits = index.get(key, (Object)value);
        Assert.assertEquals((long)3L, (long)hits.size());
    }

    private <T extends PropertyContainer> void testRemoveWithoutKey(AbstractLuceneIndexTest.EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String key2 = "key2";
        String value = "value";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value);
        index.add(entity1, key2, (Object)value);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value);
        index.add(entity2, key2, (Object)value);
        this.restartTx();
        Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1, key2);
        Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key2, (Object)value);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.get(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.get(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyNodes() throws Exception {
        this.testRemoveWithoutKey(NODE_CREATOR, this.nodeIndex("remove-wo-k", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyRelationships() throws Exception {
        this.testRemoveWithoutKey(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-k", LuceneIndexImplementation.EXACT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyValue(AbstractLuceneIndexTest.EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String value1 = "value1";
        String key2 = "key2";
        String value2 = "value2";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1);
        Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity2});
        Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity2});
        index.add(entity1, key1, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.get(key1, (Object)value1), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.get(key2, (Object)value2), new PropertyContainer[]{entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyValueNodes() throws Exception {
        this.testRemoveWithoutKeyValue(NODE_CREATOR, this.nodeIndex("remove-wo-kv", LuceneIndexImplementation.EXACT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyValueRelationships() throws Exception {
        this.testRemoveWithoutKeyValue(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-kv", LuceneIndexImplementation.EXACT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyFulltext(AbstractLuceneIndexTest.EntityCreator<T> creator, Index<T> index) throws Exception {
        String key1 = "key1";
        String key2 = "key2";
        String value1 = "value one";
        String value2 = "other value";
        String value = "value";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1, key2);
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key2, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyFulltextNode() throws Exception {
        this.testRemoveWithoutKeyFulltext(NODE_CREATOR, this.nodeIndex("remove-wo-k-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyFulltextRelationship() throws Exception {
        this.testRemoveWithoutKeyFulltext(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-k-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    private <T extends PropertyContainer> void testRemoveWithoutKeyValueFulltext(AbstractLuceneIndexTest.EntityCreator<T> creator, Index<T> index) throws Exception {
        String value = "value";
        String key1 = "key1";
        String value1 = value + " one";
        String key2 = "key2";
        String value2 = value + " two";
        T entity1 = creator.create(new Object[0]);
        index.add(entity1, key1, (Object)value1);
        index.add(entity1, key2, (Object)value2);
        T entity2 = creator.create(new Object[0]);
        index.add(entity2, key1, (Object)value1);
        index.add(entity2, key2, (Object)value2);
        this.restartTx();
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity1, entity2});
        index.remove(entity1);
        Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity2});
        Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
        index.add(entity1, key1, (Object)value1);
        for (int i = 0; i < 2; ++i) {
            Neo4jTestCase.assertContains(index.query(key1, (Object)value), new PropertyContainer[]{entity1, entity2});
            Neo4jTestCase.assertContains(index.query(key2, (Object)value), new PropertyContainer[]{entity2});
            this.restartTx();
        }
    }

    @Test
    public void testRemoveWithoutKeyValueFulltextNode() throws Exception {
        this.testRemoveWithoutKeyValueFulltext(NODE_CREATOR, this.nodeIndex("remove-wo-kv-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testRemoveWithoutKeyValueFulltextRelationship() throws Exception {
        this.testRemoveWithoutKeyValueFulltext(RELATIONSHIP_CREATOR, (Index)this.relationshipIndex("remove-wo-kv-f", LuceneIndexImplementation.FULLTEXT_CONFIG));
    }

    @Test
    public void testSortingWithTopHitsInPartCommittedPartLocal() {
        Index<Node> index = this.nodeIndex("mix", LuceneIndexImplementation.FULLTEXT_CONFIG);
        Node first = graphDb.createNode();
        Node second = graphDb.createNode();
        Node third = graphDb.createNode();
        Node fourth = graphDb.createNode();
        String key = "key";
        index.add((PropertyContainer)third, key, (Object)"ccc");
        index.add((PropertyContainer)second, key, (Object)"bbb");
        this.restartTx();
        index.add((PropertyContainer)fourth, key, (Object)"ddd");
        index.add((PropertyContainer)first, key, (Object)"aaa");
        Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)"*").sort(key, new String[0])), new Node[]{first, second, third, fourth});
        Neo4jTestCase.assertContainsInOrder(index.query(key, (Object)new QueryContext((Object)"*").sort(key, new String[0]).top(2)), new Node[]{first, second});
    }

    @Test
    public void shouldNotFindValueDeletedInSameTx() {
        Index nodeIndex = graphDb.index().forNodes("size-after-removal");
        Node node = graphDb.createNode();
        nodeIndex.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        nodeIndex.remove((PropertyContainer)node);
        for (int i = 0; i < 2; ++i) {
            IndexHits hits = nodeIndex.get("key", (Object)"value");
            Assert.assertEquals((long)0L, (long)hits.size());
            Assert.assertNull((Object)hits.getSingle());
            hits.close();
            this.restartTx();
        }
    }

    @Test
    public void notAbleToIndexWithNullKey() throws Exception {
        Index index = graphDb.index().forNodes("check-for-null");
        Node node = graphDb.createNode();
        try {
            index.add((PropertyContainer)node, null, (Object)"not allowed");
            Assert.fail((String)"Shouldn't be able to index something with null key");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Node createAndIndexNode(Index<Node> index, String key, String value) {
        Node node = graphDb.createNode();
        node.setProperty(key, (Object)value);
        index.add((PropertyContainer)node, key, (Object)value);
        return node;
    }

    @Test
    public void testRemoveNodeFromIndex() {
        Index<Node> index = this.nodeIndex("removal-1", LuceneIndexImplementation.EXACT_CONFIG);
        String key = "key";
        String value = "MYID";
        Node node = this.createAndIndexNode(index, key, value);
        index.remove((PropertyContainer)node);
        node.delete();
        Node node2 = this.createAndIndexNode(index, key, value);
        Assert.assertEquals((Object)node2, (Object)index.get(key, (Object)value).getSingle());
    }

    @Test
    public void canQueryWithWildcardEvenIfAlternativeRemovalMethodsUsedInSameTx1() throws Exception {
        Index<Node> index = this.nodeIndex("dfjk1", LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        index.remove((PropertyContainer)node, "key");
        Assert.assertNull((Object)index.query("key", (Object)"v*").getSingle());
        Assert.assertNull((Object)index.query("key", (Object)"*").getSingle());
    }

    @Test
    public void canQueryWithWildcardEvenIfAlternativeRemovalMethodsUsedInSameTx2() throws Exception {
        Index<Node> index = this.nodeIndex("dfjk2", LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        this.restartTx();
        index.remove((PropertyContainer)node);
        Assert.assertNull((Object)index.query("key", (Object)"v*").getSingle());
        Assert.assertNull((Object)index.query("key", (Object)"*").getSingle());
    }

    @Ignore(value="TODO Exposes a bug. Fixed in Lucene 3.4.0")
    @Test
    public void updateIndex() throws Exception {
        String TEXT = "text";
        String NUMERIC = "numeric";
        String TEXT_1 = "text_1";
        Index<Node> index = this.nodeIndex("update-index", LuceneIndexImplementation.EXACT_CONFIG);
        Node n = graphDb.createNode();
        index.add((PropertyContainer)n, NUMERIC, (Object)new ValueContext((Object)5).indexNumeric());
        index.add((PropertyContainer)n, TEXT, (Object)"text");
        index.add((PropertyContainer)n, TEXT_1, (Object)"text");
        this.commitTx();
        Assert.assertNotNull((Object)index.query((Object)QueryContext.numericRange((String)NUMERIC, (Number)5, (Number)5, (boolean)true, (boolean)true)).getSingle());
        Assert.assertNotNull((Object)index.get(TEXT_1, (Object)"text").getSingle());
        this.beginTx();
        index.remove((PropertyContainer)n, TEXT, (Object)"text");
        index.add((PropertyContainer)n, TEXT, (Object)"text 1");
        this.commitTx();
        Assert.assertNotNull((Object)index.get(TEXT_1, (Object)"text").getSingle());
        Assert.assertNotNull((Object)index.query((Object)QueryContext.numericRange((String)NUMERIC, (Number)5, (Number)5, (boolean)true, (boolean)true)).getSingle());
    }

    @Test
    public void notAbleToRemoveWithForbiddenKey() throws Exception {
        Index<Node> index = this.nodeIndex("broken", LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        index.add((PropertyContainer)node, "name", (Object)"Mattias");
        this.restartTx();
        try {
            index.remove((PropertyContainer)node, null);
            Assert.fail((String)"Shouldn't be able to");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            index.remove((PropertyContainer)node, "_id_");
            Assert.fail((String)"Shouldn't be able to");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="an issue that should be fixed at some point")
    @Test(expected=NotFoundException.class)
    public void shouldNotBeAbleToIndexNodeThatIsNotCommitted() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        String key = "noob";
        String value = "Johan";
        WorkThread thread = new WorkThread(index, graphDb, node);
        thread.beginTransaction();
        try {
            thread.add(node, key, value);
        }
        finally {
            thread.rollback();
        }
    }

    @Test
    public void putIfAbsentSingleThreaded() {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        String key = "name";
        String value = "Mattias";
        String value2 = "Persson";
        Assert.assertNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value));
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
        Assert.assertNotNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value));
        Assert.assertNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value2));
        Assert.assertNotNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value2));
        this.restartTx();
        Assert.assertNotNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value));
        Assert.assertNotNull((Object)index.putIfAbsent((PropertyContainer)node, key, (Object)value2));
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
    }

    @Test
    public void putIfAbsentMultiThreaded() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        this.commitTx();
        String key = "name";
        String value = "Mattias";
        WorkThread t1 = new WorkThread(index, graphDb, node);
        WorkThread t2 = new WorkThread(index, graphDb, node);
        t1.beginTransaction();
        t2.beginTransaction();
        Assert.assertNull((Object)t2.putIfAbsent(node, key, value).get());
        Future<Node> futurePut = t1.putIfAbsent(node, key, value);
        t1.waitUntilWaiting();
        t2.commit();
        Assert.assertNotNull((Object)futurePut.get());
        t1.commit();
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
    }

    @Test
    public void putIfAbsentOnOtherValueInOtherThread() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        this.commitTx();
        String key = "name";
        String value = "Mattias";
        String otherValue = "Tobias";
        WorkThread t1 = new WorkThread(index, graphDb, node);
        WorkThread t2 = new WorkThread(index, graphDb, node);
        t1.beginTransaction();
        t2.beginTransaction();
        Assert.assertNull((Object)t2.putIfAbsent(node, key, value).get());
        Future<Node> futurePut = t1.putIfAbsent(node, key, otherValue);
        t2.commit();
        Assert.assertNull((Object)futurePut.get());
        t1.commit();
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)otherValue).getSingle());
    }

    @Test
    public void putIfAbsentOnOtherKeyInOtherThread() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        this.commitTx();
        String key = "name";
        String otherKey = "friend";
        String value = "Mattias";
        WorkThread t1 = new WorkThread(index, graphDb, node);
        WorkThread t2 = new WorkThread(index, graphDb, node);
        t1.beginTransaction();
        t2.beginTransaction();
        Assert.assertNull((Object)t2.putIfAbsent(node, key, value).get());
        Assert.assertNull((Object)t1.putIfAbsent(node, otherKey, value).get());
        t2.commit();
        t1.commit();
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
        Assert.assertEquals((Object)node, (Object)index.get(otherKey, (Object)value).getSingle());
    }

    @Test
    public void putIfAbsentShouldntBlockIfNotAbsent() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        Node node = graphDb.createNode();
        String key = "key";
        String value = "value";
        index.add((PropertyContainer)node, key, (Object)value);
        this.restartTx();
        WorkThread otherThread = new WorkThread(index, graphDb, node);
        otherThread.beginTransaction();
        index.putIfAbsent((PropertyContainer)node, key, (Object)value);
        Assert.assertNotNull((Object)otherThread.putIfAbsent(node, key, value).get());
        otherThread.commit();
        this.commitTx();
    }

    @Test
    public void getOrCreateNodeWithUniqueFactory() throws Exception {
        String key = "name";
        String value = "Mattias";
        String property = "counter";
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        final AtomicInteger counter = new AtomicInteger();
        UniqueFactory.UniqueNodeFactory factory = new UniqueFactory.UniqueNodeFactory(index){

            protected void initialize(Node node, Map<String, Object> properties) {
                Assert.assertEquals((Object)"Mattias", (Object)properties.get("name"));
                Assert.assertEquals((long)1L, (long)properties.size());
                node.setProperty("counter", (Object)counter.getAndIncrement());
            }
        };
        Node unique = (Node)factory.getOrCreate("name", (Object)"Mattias");
        Assert.assertNotNull((Object)unique);
        Assert.assertEquals((String)"not initialized", (Object)0, (Object)unique.getProperty("counter", null));
        Assert.assertEquals((Object)unique, (Object)index.get("name", (Object)"Mattias").getSingle());
        Assert.assertEquals((Object)unique, (Object)factory.getOrCreate("name", (Object)"Mattias"));
        Assert.assertEquals((String)"initialized more than once", (Object)0, (Object)unique.getProperty("counter"));
        Assert.assertEquals((Object)unique, (Object)index.get("name", (Object)"Mattias").getSingle());
    }

    @Test
    public void getOrCreateRelationshipWithUniqueFactory() throws Exception {
        String key = "name";
        String value = "Mattias";
        final Node root = graphDb.createNode();
        RelationshipIndex index = this.relationshipIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        final DynamicRelationshipType type = DynamicRelationshipType.withName((String)"SINGLE");
        UniqueFactory.UniqueRelationshipFactory factory = new UniqueFactory.UniqueRelationshipFactory((Index)index){

            protected Relationship create(Map<String, Object> properties) {
                Assert.assertEquals((Object)"Mattias", (Object)properties.get("name"));
                Assert.assertEquals((long)1L, (long)properties.size());
                return root.createRelationshipTo(this.graphDatabase().createNode(), (RelationshipType)type);
            }
        };
        Relationship unique = (Relationship)factory.getOrCreate("name", (Object)"Mattias");
        Assert.assertEquals((Object)unique, (Object)root.getSingleRelationship((RelationshipType)type, Direction.BOTH));
        Assert.assertNotNull((Object)unique);
        Assert.assertEquals((Object)unique, (Object)index.get("name", (Object)"Mattias").getSingle());
        Assert.assertEquals((Object)unique, (Object)factory.getOrCreate("name", (Object)"Mattias"));
        Assert.assertEquals((Object)unique, (Object)root.getSingleRelationship((RelationshipType)type, Direction.BOTH));
        Assert.assertEquals((Object)unique, (Object)index.get("name", (Object)"Mattias").getSingle());
    }

    @Test
    public void getOrCreateMultiThreaded() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        String key = "name";
        String value = "Mattias";
        WorkThread t1 = new WorkThread(index, graphDb, null);
        WorkThread t2 = new WorkThread(index, graphDb, null);
        t1.beginTransaction();
        t2.beginTransaction();
        Node node = t2.getOrCreate(key, value, 0).get();
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)0, (Object)t2.getProperty((PropertyContainer)node, key));
        Future<Node> futurePut = t1.getOrCreate(key, value, 1);
        t1.waitUntilWaiting();
        t2.commit();
        Assert.assertEquals((Object)node, (Object)futurePut.get());
        Assert.assertEquals((Object)0, (Object)t1.getProperty((PropertyContainer)node, key));
        t1.commit();
        Assert.assertEquals((Object)node, (Object)index.get(key, (Object)value).getSingle());
    }

    @Test
    public void numericValueForGetInExactIndex() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.EXACT_CONFIG);
        this.numericValueForGet(index);
    }

    @Test
    public void numericValueForGetInFulltextIndex() throws Exception {
        Index<Node> index = this.nodeIndex(this.testname.getMethodName(), LuceneIndexImplementation.FULLTEXT_CONFIG);
        this.numericValueForGet(index);
    }

    private void numericValueForGet(Index<Node> index) {
        Node node = graphDb.createNode();
        long id = 100L;
        index.add((PropertyContainer)node, "name", (Object)ValueContext.numeric((Number)id));
        Assert.assertEquals((Object)node, (Object)index.get("name", (Object)ValueContext.numeric((Number)id)).getSingle());
        this.restartTx();
        Assert.assertEquals((Object)node, (Object)index.get("name", (Object)ValueContext.numeric((Number)id)).getSingle());
    }
}

