/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.impl.lucene.AbstractLuceneIndexTest;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.lucene.QueryContext;

@Ignore(value="These are performance and sanity tests which can't really be executed as automated tests for example a long running test which checks so that files aren't kept open")
public class TestPerformanceAndSanity
extends AbstractLuceneIndexTest {
    @Test
    public void testNodeInsertionSpeed() {
        this.testInsertionSpeed(this.nodeIndex("insertion-speed", LuceneIndexImplementation.EXACT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void testNodeFulltextInsertionSpeed() {
        this.testInsertionSpeed(this.nodeIndex("insertion-speed-full", LuceneIndexImplementation.FULLTEXT_CONFIG), NODE_CREATOR);
    }

    @Test
    public void testRelationshipInsertionSpeed() {
        this.testInsertionSpeed((Index)this.relationshipIndex("insertion-speed", LuceneIndexImplementation.EXACT_CONFIG), new AbstractLuceneIndexTest.FastRelationshipCreator());
    }

    private <T extends PropertyContainer> void testInsertionSpeed(Index<T> index, AbstractLuceneIndexTest.EntityCreator<T> creator) {
        int i;
        long t = System.currentTimeMillis();
        int max = 500000;
        for (int i2 = 0; i2 < max; ++i2) {
            T entity = creator.create(new Object[0]);
            if (i2 % 5000 == 5) {
                index.query((Object)new TermQuery(new Term("name", "The name " + i2)));
            }
            IteratorUtil.lastOrNull((Iterable)index.query((Object)new QueryContext((Object)new TermQuery(new Term("name", "The name " + i2))).tradeCorrectnessForSpeed()));
            IteratorUtil.lastOrNull((Iterable)index.get("name", (Object)("The name " + i2)));
            index.add(entity, "name", (Object)("The name " + i2));
            index.add(entity, "title", (Object)("Some title " + i2));
            index.add(entity, "something", (Object)(i2 + "Nothing"));
            index.add(entity, "else", (Object)(i2 + "kdfjkdjf" + i2));
            if (i2 % 30000 != 0) continue;
            this.restartTx();
            System.out.println(i2);
        }
        this.finishTx(true);
        System.out.println("insert:" + (System.currentTimeMillis() - t));
        t = System.currentTimeMillis();
        int count = 2000000;
        int resultCount = 0;
        for (i = 0; i < count; ++i) {
            resultCount += IteratorUtil.count((Iterator)index.get("name", (Object)("The name " + i % max)));
        }
        System.out.println("get(" + resultCount + "):" + (double)(System.currentTimeMillis() - t) / (double)count);
        t = System.currentTimeMillis();
        resultCount = 0;
        for (i = 0; i < count; ++i) {
            resultCount += IteratorUtil.count((Iterator)index.get("something", (Object)(i % max + "Nothing")));
        }
        System.out.println("get(" + resultCount + "):" + (double)(System.currentTimeMillis() - t) / (double)count);
    }

    @Test
    public void makeSureFilesAreClosedProperly() throws Exception {
        this.commitTx();
        final Index<Node> index = this.nodeIndex("open-files", LuceneIndexImplementation.EXACT_CONFIG);
        final long time = System.currentTimeMillis();
        final CountDownLatch latch = new CountDownLatch(30);
        int t = 0;
        while ((long)t < latch.getCount()) {
            final int thread = t++;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int i = 0;
                    while (System.currentTimeMillis() - time < 600000L) {
                        if (i % 10 == 0) {
                            int size;
                            if (i % 100 == 0) {
                                IndexHits itr;
                                int type = (int)(System.currentTimeMillis() % 3L);
                                if (type == 0) {
                                    itr = index.get("key", (Object)"value5");
                                    try {
                                        itr.getSingle();
                                    }
                                    catch (NoSuchElementException e) {
                                        // empty catch block
                                    }
                                    size = 99;
                                } else if (type == 1) {
                                    itr = index.get("key", (Object)"value5");
                                    for (size = 0; itr.hasNext() && size < 5; ++size) {
                                        itr.next();
                                    }
                                    itr.close();
                                } else {
                                    itr = index.get("key", (Object)"crap value");
                                    if (System.currentTimeMillis() % 10L > 5L) {
                                        IteratorUtil.count((Iterator)itr);
                                    }
                                }
                            } else {
                                size = IteratorUtil.count((Iterator)index.get("key", (Object)"value5"));
                                if (thread == 0) {
                                    System.out.println("hit size:" + size);
                                }
                            }
                        } else {
                            Transaction tx = AbstractLuceneIndexTest.graphDb.beginTx();
                            try {
                                for (int ii = 0; ii < 20; ++ii) {
                                    Node node = AbstractLuceneIndexTest.graphDb.createNode();
                                    index.add((PropertyContainer)node, "key", (Object)("value" + ii));
                                }
                                tx.success();
                            }
                            finally {
                                tx.finish();
                            }
                        }
                        ++i;
                    }
                    latch.countDown();
                }
            }.start();
        }
        latch.await();
    }

    @Test
    public void testPerformanceForManySmallTransactions() throws Exception {
        final Index<Node> index = this.nodeIndex("index", LuceneIndexImplementation.EXACT_CONFIG);
        int count = 5000;
        boolean group = true;
        int threads = 3;
        ArrayList<2> threadList = new ArrayList<2>();
        final AtomicInteger id = new AtomicInteger();
        final AtomicBoolean halt = new AtomicBoolean();
        long t = System.currentTimeMillis();
        int h = 0;
        while (h < 3) {
            final int n = h++;
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 5000 && !halt.get(); ++i) {
                            Transaction tx = AbstractLuceneIndexTest.graphDb.beginTx();
                            try {
                                for (int ii = 0; ii < 1; ++ii) {
                                    Node node = AbstractLuceneIndexTest.graphDb.createNode();
                                    index.get("key", (Object)("value" + System.currentTimeMillis() % 5000L)).getSingle();
                                    index.add((PropertyContainer)node, "key", (Object)("value" + id.getAndIncrement()));
                                }
                                tx.success();
                            }
                            finally {
                                tx.finish();
                            }
                            if (i % 100 != 0) continue;
                            System.out.println(n + ": " + i);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                        halt.set(true);
                    }
                }
            };
            threadList.add(thread);
            thread.start();
        }
        for (Thread thread : threadList) {
            thread.join();
        }
        long t1 = System.currentTimeMillis() - t;
        System.out.println(t1 + ", " + (double)t1 / 5000.0);
    }
}

