/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.Neo4jTestCase;
import org.neo4j.index.impl.lucene.AddDeleteQuit;
import org.neo4j.index.impl.lucene.AddRelToIndex;
import org.neo4j.index.impl.lucene.Inserter;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.kernel.CommonFactories;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.index.IndexStore;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;

public class TestRecovery {
    private String getDbPath() {
        return "target/var/recovery";
    }

    private GraphDatabaseService newGraphDbService() {
        String path = this.getDbPath();
        Neo4jTestCase.deleteFileOrDirectory(new File(path));
        return new EmbeddedGraphDatabase(path);
    }

    @Test
    public void testRecovery() throws Exception {
        final GraphDatabaseService graphDb = this.newGraphDbService();
        Index nodeIndex = graphDb.index().forNodes("node-index");
        RelationshipIndex relIndex = graphDb.index().forRelationships("rel-index");
        DynamicRelationshipType relType = DynamicRelationshipType.withName((String)"recovery");
        graphDb.beginTx();
        Random random = new Random();
        Thread stopper = new Thread(){

            @Override
            public void run() {
                TestRecovery.sleepNice(1000L);
                graphDb.shutdown();
            }
        };
        String[] keys = new String[]{"apoc", "zion", "neo"};
        try {
            stopper.start();
            for (int i = 0; i < 50; ++i) {
                Node node = graphDb.createNode();
                Node otherNode = graphDb.createNode();
                Relationship rel = node.createRelationshipTo(otherNode, (RelationshipType)relType);
                for (int ii = 0; ii < 3; ++ii) {
                    nodeIndex.add((PropertyContainer)node, keys[random.nextInt(keys.length)], (Object)random.nextInt());
                    relIndex.add((PropertyContainer)rel, keys[random.nextInt(keys.length)], (Object)random.nextInt());
                }
                TestRecovery.sleepNice(10L);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        while (stopper.getState() != Thread.State.TERMINATED) {
            TestRecovery.sleepNice(100L);
        }
        EmbeddedGraphDatabase newGraphDb = new EmbeddedGraphDatabase(this.getDbPath());
        newGraphDb.shutdown();
    }

    private static void sleepNice(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void testHardCoreRecovery() throws Exception {
        String path = "target/hcdb";
        Neo4jTestCase.deleteFileOrDirectory(new File(path));
        Process process = Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), Inserter.class.getName(), path});
        Thread.sleep(6000L);
        process.destroy();
        process.waitFor();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(path);
        Assert.assertTrue((boolean)db.index().existsForNodes("myIndex"));
        Index index = db.index().forNodes("myIndex");
        for (Node node : db.getAllNodes()) {
            for (String key : node.getPropertyKeys()) {
                String value = (String)node.getProperty(key);
                boolean found = false;
                for (Node indexedNode : index.get(key, (Object)value)) {
                    if (!indexedNode.equals(node)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalStateException(node + " has property '" + key + "'='" + value + "', but not in index");
            }
        }
        db.shutdown();
    }

    @Test
    public void testAsLittleAsPossibleRecoveryScenario() throws Exception {
        GraphDatabaseService db = this.newGraphDbService();
        Index index = db.index().forNodes("my-index");
        db.beginTx();
        Node node = db.createNode();
        index.add((PropertyContainer)node, "key", (Object)"value");
        db.shutdown();
        new EmbeddedGraphDatabase(this.getDbPath()).shutdown();
    }

    @Test
    public void testIndexDeleteIssue() throws Exception {
        GraphDatabaseService db = this.newGraphDbService();
        db.index().forNodes("index");
        db.shutdown();
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), AddDeleteQuit.class.getName(), this.getDbPath()}).waitFor());
        new EmbeddedGraphDatabase(this.getDbPath()).shutdown();
        db.shutdown();
    }

    @Test
    public void recoveryForRelationshipCommandsOnly() throws Exception {
        String path = this.getDbPath();
        Neo4jTestCase.deleteFileOrDirectory(new File(path));
        Assert.assertEquals((long)0L, (long)Runtime.getRuntime().exec(new String[]{"java", "-cp", System.getProperty("java.class.path"), AddRelToIndex.class.getName(), this.getDbPath()}).waitFor());
        Map params = MapUtil.genericMap((Object[])new Object[]{"store_dir", this.getDbPath(), IndexStore.class, new IndexStore(this.getDbPath()), LogBufferFactory.class, CommonFactories.defaultLogBufferFactory()});
        LuceneDataSource ds = new LuceneDataSource(params);
        ds.close();
    }
}

