/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Map;
import java.util.concurrent.Future;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.index.UniqueFactory;
import org.neo4j.index.impl.lucene.BeginTransactionCommand;
import org.neo4j.index.impl.lucene.CommandState;
import org.neo4j.index.impl.lucene.CommitCommand;
import org.neo4j.index.impl.lucene.CreateNodeAndIndexByCommand;
import org.neo4j.index.impl.lucene.DeleteIndexCommand;
import org.neo4j.index.impl.lucene.DieCommand;
import org.neo4j.index.impl.lucene.PutIfAbsentCommand;
import org.neo4j.index.impl.lucene.QueryIndexCommand;
import org.neo4j.index.impl.lucene.RemoveFromIndexCommand;
import org.neo4j.index.impl.lucene.RollbackCommand;
import org.neo4j.test.OtherThreadExecutor;

public class WorkThread
extends OtherThreadExecutor<CommandState> {
    private volatile boolean txOngoing;

    public WorkThread(Index<Node> index, GraphDatabaseService graphDb, Node node) {
        super((Object)new CommandState(index, graphDb, node));
    }

    public void createNodeAndIndexBy(String key, String value) throws Exception {
        this.execute(new CreateNodeAndIndexByCommand(key, value));
    }

    public void deleteIndex() throws Exception {
        this.execute(new DeleteIndexCommand());
    }

    public IndexHits<Node> queryIndex(String key, Object value) throws Exception {
        return (IndexHits)this.execute(new QueryIndexCommand(key, value));
    }

    public void commit() throws Exception {
        this.execute(new CommitCommand());
        this.txOngoing = false;
    }

    public void beginTransaction() throws Exception {
        assert (!this.txOngoing);
        this.execute(new BeginTransactionCommand());
        this.txOngoing = true;
    }

    public void removeFromIndex(String key, String value) throws Exception {
        this.execute(new RemoveFromIndexCommand(key, value));
    }

    public void rollback() throws Exception {
        if (!this.txOngoing) {
            return;
        }
        this.execute(new RollbackCommand());
        this.txOngoing = false;
    }

    public void die() throws Exception {
        this.execute(new DieCommand());
    }

    public Future<Node> putIfAbsent(Node node, String key, Object value) throws Exception {
        return this.executeDontWait(new PutIfAbsentCommand(node, key, value));
    }

    public void add(final Node node, final String key, final Object value) throws Exception {
        this.execute((OtherThreadExecutor.WorkerCommand)new OtherThreadExecutor.WorkerCommand<CommandState, Void>(){

            public Void doWork(CommandState state) {
                state.index.add((PropertyContainer)node, key, value);
                return null;
            }
        });
    }

    public Future<Node> getOrCreate(final String key, final Object value, final Object initialValue) throws Exception {
        return this.executeDontWait((OtherThreadExecutor.WorkerCommand)new OtherThreadExecutor.WorkerCommand<CommandState, Node>(){

            public Node doWork(CommandState state) {
                UniqueFactory.UniqueNodeFactory factory = new UniqueFactory.UniqueNodeFactory(state.index){

                    protected void initialize(Node node, Map<String, Object> properties) {
                        node.setProperty(key, initialValue);
                    }
                };
                return (Node)factory.getOrCreate(key, value);
            }
        });
    }

    public Object getProperty(final PropertyContainer entity, final String key) throws Exception {
        return this.execute((OtherThreadExecutor.WorkerCommand)new OtherThreadExecutor.WorkerCommand<CommandState, Object>(){

            public Object doWork(CommandState state) {
                return entity.getProperty(key);
            }
        });
    }
}

