/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.timeline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.lucene.LuceneTimeline;
import org.neo4j.index.lucene.TimelineIndex;
import org.neo4j.test.ImpermanentGraphDatabase;

public class TestTimeline {
    private GraphDatabaseService db;
    private Transaction tx;
    private EntityCreator<PropertyContainer> nodeCreator = new EntityCreator<PropertyContainer>(){

        @Override
        public Node create() {
            return TestTimeline.this.db.createNode();
        }
    };
    private EntityCreator<PropertyContainer> relationshipCreator = new EntityCreator<PropertyContainer>(){
        private final RelationshipType type = DynamicRelationshipType.withName((String)"whatever");

        @Override
        public Relationship create() {
            return TestTimeline.this.db.createNode().createRelationshipTo(TestTimeline.this.db.createNode(), this.type);
        }
    };

    @Before
    public void before() throws Exception {
        this.db = new ImpermanentGraphDatabase();
    }

    private void beginTx() {
        this.tx = this.db.beginTx();
    }

    private void commitTx() {
        this.tx.success();
        this.tx.finish();
    }

    private TimelineIndex<PropertyContainer> nodeTimeline() {
        return new LuceneTimeline(this.db, this.db.index().forNodes("timeline"));
    }

    private TimelineIndex<PropertyContainer> relationshipTimeline() {
        return new LuceneTimeline(this.db, (Index)this.db.index().forRelationships("timeline"));
    }

    private LinkedList<Pair<PropertyContainer, Long>> createTimestamps(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline, long ... timestamps) {
        this.beginTx();
        LinkedList<Pair<PropertyContainer, Long>> result = new LinkedList<Pair<PropertyContainer, Long>>();
        for (long timestamp : timestamps) {
            result.add(this.createTimestampedEntity(creator, timeline, timestamp));
        }
        this.commitTx();
        return result;
    }

    private Pair<PropertyContainer, Long> createTimestampedEntity(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline, long timestamp) {
        PropertyContainer entity = creator.create();
        timeline.add(entity, timestamp);
        return Pair.of((Object)entity, (Object)timestamp);
    }

    private List<PropertyContainer> sortedEntities(LinkedList<Pair<PropertyContainer, Long>> timestamps, final boolean reversed) {
        ArrayList<Pair<PropertyContainer, Long>> sorted = new ArrayList<Pair<PropertyContainer, Long>>(timestamps);
        Collections.sort(sorted, new Comparator<Pair<PropertyContainer, Long>>(){

            @Override
            public int compare(Pair<PropertyContainer, Long> o1, Pair<PropertyContainer, Long> o2) {
                return !reversed ? ((Long)o1.other()).compareTo((Long)o2.other()) : ((Long)o2.other()).compareTo((Long)o1.other());
            }
        });
        ArrayList<PropertyContainer> result = new ArrayList<PropertyContainer>();
        for (Pair pair : sorted) {
            result.add((PropertyContainer)pair.first());
        }
        return result;
    }

    private void makeSureFirstAndLastAreReturnedCorrectly(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 223456L, 12345L, 432234L);
        Assert.assertEquals((Object)timestamps.get(1).first(), (Object)timeline.getFirst());
        Assert.assertEquals((Object)timestamps.getLast().first(), (Object)timeline.getLast());
    }

    private void makeSureRangesAreReturnedInCorrectOrder(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 200000L, 400000L, 100000L, 500000L, 600000L, 900000L, 800000L);
        Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)IteratorUtil.asCollection((Iterable)timeline.getBetween(null, null)));
    }

    private void makeSureRangesAreReturnedInCorrectReversedOrder(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 200000L, 199999L, 400000L, 100000L, 500000L, 600000L, 900000L, 800000L);
        Assert.assertEquals(this.sortedEntities(timestamps, true), (Object)IteratorUtil.asCollection((Iterable)timeline.getBetween(null, null, true)));
    }

    private void makeSureWeCanQueryLowerDefaultThan1970(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, -10000L, 0L, 10000L);
        Assert.assertEquals(this.sortedEntities(timestamps, true), (Object)IteratorUtil.asCollection((Iterable)timeline.getBetween(null, Long.valueOf(10000L), true)));
    }

    private void makeSureUncommittedChangesAreSortedCorrectly(EntityCreator<PropertyContainer> creator, TimelineIndex<PropertyContainer> timeline) throws Exception {
        LinkedList<Pair<PropertyContainer, Long>> timestamps = this.createTimestamps(creator, timeline, 300000L, 100000L, 500000L, 900000L, 800000L);
        this.beginTx();
        timestamps.addAll(this.createTimestamps(creator, timeline, 40000L, 70000L, 20000L));
        Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)IteratorUtil.asCollection((Iterable)timeline.getBetween(null, null)));
        this.commitTx();
        Assert.assertEquals(this.sortedEntities(timestamps, false), (Object)IteratorUtil.asCollection((Iterable)timeline.getBetween(null, null)));
    }

    @Test
    public void makeSureFirstAndLastAreReturnedCorrectlyNode() throws Exception {
        this.makeSureFirstAndLastAreReturnedCorrectly(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureFirstAndLastAreReturnedCorrectlyRelationship() throws Exception {
        this.makeSureFirstAndLastAreReturnedCorrectly(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectOrderNode() throws Exception {
        this.makeSureRangesAreReturnedInCorrectOrder(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectOrderRelationship() throws Exception {
        this.makeSureRangesAreReturnedInCorrectOrder(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectReversedOrderNode() throws Exception {
        this.makeSureRangesAreReturnedInCorrectReversedOrder(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureRangesAreReturnedInCorrectReversedOrderRelationship() throws Exception {
        this.makeSureRangesAreReturnedInCorrectReversedOrder(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureUncommittedChangesAreSortedCorrectlyNode() throws Exception {
        this.makeSureUncommittedChangesAreSortedCorrectly(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureUncommittedChangesAreSortedCorrectlyRelationship() throws Exception {
        this.makeSureUncommittedChangesAreSortedCorrectly(this.relationshipCreator, this.relationshipTimeline());
    }

    @Test
    public void makeSureWeCanQueryLowerDefaultThan1970Node() throws Exception {
        this.makeSureWeCanQueryLowerDefaultThan1970(this.nodeCreator, this.nodeTimeline());
    }

    @Test
    public void makeSureWeCanQueryLowerDefaultThan1970Relationship() throws Exception {
        this.makeSureWeCanQueryLowerDefaultThan1970(this.relationshipCreator, this.relationshipTimeline());
    }

    private static interface EntityCreator<T extends PropertyContainer> {
        public T create();
    }
}

