/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.schema;

import java.util.Arrays;
import java.util.EnumSet;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrderCapability;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.AbstractLuceneIndexProvider;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.monitoring.Monitors;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

public class TextIndexProvider
extends AbstractLuceneIndexProvider {
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor("text", "1.0");
    public static final IndexCapability CAPABILITY = new TextIndexCapability();

    public TextIndexProvider(FileSystemAbstraction fileSystem, DirectoryFactory directoryFactory, IndexDirectoryStructure.Factory directoryStructureFactory, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker) {
        super(IndexType.TEXT, DESCRIPTOR, fileSystem, directoryFactory, directoryStructureFactory, monitors, config, readOnlyChecker);
    }

    @Override
    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        return index.getCapability().equals(IndexCapability.NO_CAPABILITY) ? index.withIndexCapability(CAPABILITY) : index;
    }

    public IndexType getIndexType() {
        return IndexType.TEXT;
    }

    public static class TextIndexCapability
    implements IndexCapability {
        public IndexOrderCapability orderCapability(ValueCategory ... valueCategories) {
            return IndexOrderCapability.NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.NO;
        }

        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return valueCategories.length == 1 && valueCategories[0] == ValueCategory.TEXT;
        }

        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            if (queryType == IndexQuery.IndexQueryType.ALL_ENTRIES) {
                return true;
            }
            if (!this.areValueCategoriesAccepted(valueCategory)) {
                return false;
            }
            switch (queryType) {
                case EXACT: 
                case STRING_PREFIX: 
                case STRING_SUFFIX: 
                case STRING_CONTAINS: 
                case RANGE: {
                    return true;
                }
            }
            return false;
        }

        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            if (Arrays.stream(queryTypes).anyMatch(EnumSet.of(IndexQuery.IndexQueryType.EXACT, IndexQuery.IndexQueryType.RANGE, IndexQuery.IndexQueryType.STRING_PREFIX)::contains)) {
                return 1.1;
            }
            return 1.0;
        }

        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            return false;
        }
    }
}

