/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade.lucene;

import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.upgrade.loader.EmbeddedJarLoader;
import org.neo4j.upgrade.loader.JarLoaderSupplier;
import org.neo4j.upgrade.lucene.ExplicitIndexMigrationException;
import org.neo4j.upgrade.lucene.IndexUpgraderWrapper;
import org.neo4j.upgrade.lucene.LuceneExplicitIndexUpgrader;

public class LuceneExplicitIndexUpgraderTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void failOnFileMigration() throws Exception {
        Path indexFolder = this.createPathForResource("indexPretender.txt");
        this.expectedException.expect(IllegalArgumentException.class);
        new LuceneExplicitIndexUpgrader(indexFolder, LuceneExplicitIndexUpgrader.NO_MONITOR);
    }

    @Test
    public void ignoreFoldersWithoutIndexes() throws URISyntaxException, ExplicitIndexMigrationException {
        Path indexFolder = this.createPathForResource("notIndexFolder");
        TrackingLuceneExplicitIndexUpgrader indexUpgrader = new TrackingLuceneExplicitIndexUpgrader(indexFolder);
        indexUpgrader.upgradeIndexes();
        Assert.assertTrue((boolean)indexUpgrader.getMigratedIndexes().isEmpty());
    }

    @Test
    public void migrateValidIndexes() throws URISyntaxException, ExplicitIndexMigrationException {
        Path indexFolder = this.createPathForResource("indexFolder");
        TrackingLuceneExplicitIndexUpgrader indexUpgrader = new TrackingLuceneExplicitIndexUpgrader(indexFolder);
        indexUpgrader.upgradeIndexes();
        Assert.assertThat(indexUpgrader.getMigratedIndexes(), (Matcher)Matchers.contains((Object[])new String[]{"index1", "index2"}));
    }

    @Test
    public void pointIncorrectIndexOnMigrationFailure() throws URISyntaxException, ExplicitIndexMigrationException {
        Path indexFolder = this.createPathForResource("indexFolder");
        TrackingLuceneExplicitIndexUpgrader indexUpgrader = new TrackingLuceneExplicitIndexUpgrader(indexFolder, true);
        this.expectedException.expect(ExplicitIndexMigrationException.class);
        this.expectedException.expect((Matcher)new ExplicitIndexMigrationExceptionBaseMatcher("index1", "index2"));
        indexUpgrader.upgradeIndexes();
    }

    private Path createPathForResource(String resourceName) throws URISyntaxException {
        return Paths.get(this.getClass().getClassLoader().getResource(resourceName).toURI());
    }

    private static class IndexUpgraderWrapperStub
    extends IndexUpgraderWrapper {
        private final Set<String> migratedIndexes;
        private final boolean failIndexUpgrade;

        IndexUpgraderWrapperStub(Supplier<EmbeddedJarLoader> jarLoaderSupplier, Set<String> migratedIndexes, boolean failIndexUpgrade) {
            super(jarLoaderSupplier);
            this.migratedIndexes = migratedIndexes;
            this.failIndexUpgrade = failIndexUpgrade;
        }

        public void upgradeIndex(Path indexPath) {
            if (this.failIndexUpgrade) {
                throw new RuntimeException("Fail index migration: " + indexPath);
            }
            this.migratedIndexes.add(indexPath.getFileName().toString());
        }
    }

    private static class TrackingLuceneExplicitIndexUpgrader
    extends LuceneExplicitIndexUpgrader {
        private final Set<String> migratedIndexes = new HashSet<String>();
        private final boolean failIndexUpgrade;

        TrackingLuceneExplicitIndexUpgrader(Path indexRootPath) {
            this(indexRootPath, false);
        }

        TrackingLuceneExplicitIndexUpgrader(Path indexRootPath, boolean failIndexUpgrade) {
            super(indexRootPath, NO_MONITOR);
            this.failIndexUpgrade = failIndexUpgrade;
        }

        IndexUpgraderWrapper createIndexUpgrader(String[] jars) {
            return new IndexUpgraderWrapperStub((Supplier<EmbeddedJarLoader>)JarLoaderSupplier.of((String[])jars), this.migratedIndexes, this.failIndexUpgrade);
        }

        public Set<String> getMigratedIndexes() {
            return this.migratedIndexes;
        }
    }

    private static class ExplicitIndexMigrationExceptionBaseMatcher
    extends TypeSafeDiagnosingMatcher<ExplicitIndexMigrationException> {
        private final String[] failedIndexNames;

        ExplicitIndexMigrationExceptionBaseMatcher(String ... failedIndexNames) {
            this.failedIndexNames = failedIndexNames;
        }

        public void describeTo(Description description) {
            description.appendText("Failed index should be one of:").appendText(Arrays.toString(this.failedIndexNames));
        }

        protected boolean matchesSafely(ExplicitIndexMigrationException item, Description mismatchDescription) {
            String brokendIndexName = item.getFailedIndexName();
            boolean matched = Arrays.asList(this.failedIndexNames).contains(brokendIndexName);
            if (!matched) {
                mismatchDescription.appendText("Failed index is: ").appendText(brokendIndexName);
            }
            return matched;
        }
    }
}

