/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.management;

import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.Primitives;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.AbstractGraphDatabase;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.management.Cache;
import org.neo4j.management.Neo4jManager;

public class ManagementBeansTest {
    private static AbstractGraphDatabase graphDb;

    @BeforeClass
    public static synchronized void startGraphDb() {
        graphDb = new EmbeddedGraphDatabase("target" + File.separator + "var" + File.separator + ManagementBeansTest.class.getSimpleName());
    }

    @AfterClass
    public static synchronized void stopGraphDb() {
        if (graphDb != null) {
            graphDb.shutdown();
            graphDb = null;
        }
    }

    @Test
    public void canAccessKernelBean() throws Exception {
        Kernel kernel = (Kernel)((JmxKernelExtension)graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class);
        Assert.assertNotNull((String)"kernel bean is null", (Object)kernel);
        Assert.assertNotNull((String)"MBeanQuery of kernel bean is null", (Object)kernel.getMBeanQuery());
    }

    @Test
    public void canAccessPrimitivesBean() throws Exception {
        Primitives primitives = (Primitives)((JmxKernelExtension)graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Primitives.class);
        Assert.assertNotNull((String)"primitives bean is null", (Object)primitives);
        primitives.getNumberOfNodeIdsInUse();
    }

    @Test
    public void canListAllBeans() throws Exception {
        Neo4jManager manager = this.getManager();
        Assert.assertTrue((String)"No beans returned", (manager.allBeans().size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void canGetConfigurationParameters() throws Exception {
        Neo4jManager manager = this.getManager();
        Map configuration = manager.getConfiguration();
        Assert.assertTrue((String)"No configuration returned", (configuration.size() > 0 ? 1 : 0) != 0);
    }

    private Neo4jManager getManager() {
        return new Neo4jManager((Kernel)((JmxKernelExtension)graphDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class));
    }

    @Test
    public void canGetCacheBean() throws Exception {
        Collection beans = this.getManager().getCacheBeans();
        Assert.assertNotNull((Object)beans);
        Assert.assertFalse((String)"No Cache beans found", (boolean)beans.isEmpty());
        for (Cache bean : beans) {
            Assert.assertNotNull((Object)bean);
        }
    }

    @Test
    public void canGetLockManagerBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getLockManagerBean());
    }

    @Test
    public void canGetMemoryMappingBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getMemoryMappingBean());
    }

    @Test
    public void canGetPrimitivesBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getPrimitivesBean());
    }

    @Test
    public void canGetStoreFileBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getStoreFileBean());
    }

    @Test
    public void canGetTransactionManagerBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getTransactionManagerBean());
    }

    @Test
    public void canGetXaManagerBean() throws Exception {
        Assert.assertNotNull((Object)this.getManager().getXaManagerBean());
    }

    @Test
    public void canAccessMemoryMappingCompositData() throws Exception {
        Assert.assertNotNull((String)"MemoryPools is null", (Object)this.getManager().getMemoryMappingBean().getMemoryPools());
    }

    @Test
    public void canAccessXaManagerCompositData() throws Exception {
        Assert.assertNotNull((String)"MemoryPools is null", (Object)this.getManager().getXaManagerBean().getXaResources());
    }
}

